/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.bootstrap.SparkParquetBootstrapDataProvider;
import org.apache.hudi.client.bootstrap.selector.FullRecordBootstrapModeSelector;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestBootstrap;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u0016,\u0001QBQa\u000f\u0001\u0005\u0002qB\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001!\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003I\u0005\"C(\u0001\u0001\u0004\u0005\t\u0015)\u0003B\u0011\u001d\u0001\u0006A1A\u0005\u0002ECa\u0001\u0019\u0001!\u0002\u0013\u0011\u0006\"C1\u0001\u0001\u0004\u0005\r\u0011\"\u0001c\u0011%\u0019\u0007\u00011AA\u0002\u0013\u0005A\rC\u0005g\u0001\u0001\u0007\t\u0011)Q\u0005;\"Iq\r\u0001a\u0001\u0002\u0004%\tA\u0019\u0005\nQ\u0002\u0001\r\u00111A\u0005\u0002%D\u0011b\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B/\t\u00131\u0004\u0001\u0019!a\u0001\n\u0003i\u0007\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0001w\u0011%A\b\u00011A\u0001B\u0003&a\u000eC\u0004z\u0001\t\u0007I\u0011\u0001>\t\u000f\u0005%\u0001\u0001)A\u0005w\"I\u00111\u0002\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011q\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0010!A\u00111\u0004\u0001C\u0002\u0013\u0005!\rC\u0004\u0002\u001e\u0001\u0001\u000b\u0011B/\t\u0011\u0005}\u0001A1A\u0005\u0002\tDq!!\t\u0001A\u0003%Q\f\u0003\u0005\u0002$\u0001\u0011\r\u0011\"\u0001c\u0011\u001d\t)\u0003\u0001Q\u0001\nuC\u0001\"a\n\u0001\u0005\u0004%\tA\u0019\u0005\b\u0003S\u0001\u0001\u0015!\u0003^\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002x\u0001!\t!!\u001c\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011\u0011\u0017\u0001\u0005\u0002\u00055\u0004bBA[\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003s\u0003A\u0011AA7\u0011\u001d\ti\f\u0001C\u0001\u0003[Bq!!1\u0001\t\u0003\ti\u0007C\u0004\u0002F\u0002!\t!a2\t\u0013\u0005U\u0007!%A\u0005\u0002\u0005]\u0007bBAw\u0001\u0011\u0005\u0011q\u001e\u0002\u001b)\u0016\u001cH\u000fR1uCN{WO]2f\r>\u0014(i\\8ugR\u0014\u0018\r\u001d\u0006\u0003Y5\n!BZ;oGRLwN\\1m\u0015\tqs&\u0001\u0003ik\u0012L'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001f\u0011\u0005y\u0002Q\"A\u0016\u0002\u000bM\u0004\u0018M]6\u0016\u0003\u0005\u0003\"A\u0011$\u000e\u0003\rS!\u0001R#\u0002\u0007M\fHN\u0003\u0002@_%\u0011qi\u0011\u0002\r'B\f'o[*fgNLwN\\\u0001\ngB\f'o[0%KF$\"AS'\u0011\u0005YZ\u0015B\u0001'8\u0005\u0011)f.\u001b;\t\u000f9\u001b\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002\rM\u0004\u0018M]6!\u0003)\u0019w.\\7p]>\u0003Ho]\u000b\u0002%B!1KW/^\u001d\t!\u0006\f\u0005\u0002Vo5\taK\u0003\u0002Xg\u00051AH]8pizJ!!W\u001c\u0002\rA\u0013X\rZ3g\u0013\tYFLA\u0002NCBT!!W\u001c\u0011\u0005Ms\u0016BA0]\u0005\u0019\u0019FO]5oO\u0006Y1m\\7n_:|\u0005\u000f^:!\u0003!\u0011\u0017m]3QCRDW#A/\u0002\u0019\t\f7/\u001a)bi\"|F%Z9\u0015\u0005)+\u0007b\u0002(\t\u0003\u0003\u0005\r!X\u0001\nE\u0006\u001cX\rU1uQ\u0002\nqa\u001d:d!\u0006$\b.A\u0006te\u000e\u0004\u0016\r\u001e5`I\u0015\fHC\u0001&k\u0011\u001dq5\"!AA\u0002u\u000b\u0001b\u001d:d!\u0006$\b\u000eI\u0001\u0003MN,\u0012A\u001c\t\u0003_Nl\u0011\u0001\u001d\u0006\u0003YFT!A]\u0018\u0002\r!\fGm\\8q\u0013\t!\bO\u0001\u0006GS2,7+_:uK6\faAZ:`I\u0015\fHC\u0001&x\u0011\u001dqe\"!AA\u00029\f1AZ:!\u00039\u0001\u0018M\u001d;ji&|g\u000eU1uQN,\u0012a\u001f\t\u0005y\u0006\rQL\u0004\u0002~\u007f:\u0011QK`\u0005\u0002q%\u0019\u0011\u0011A\u001c\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u0005q'A\bqCJ$\u0018\u000e^5p]B\u000bG\u000f[:!\u0003)qW/\u001c*fG>\u0014Hm]\u000b\u0003\u0003\u001f\u00012ANA\t\u0013\r\t\u0019b\u000e\u0002\u0004\u0013:$\u0018a\u00038v[J+7m\u001c:eg\u0002\n\u0001C\\;n%\u0016\u001cwN\u001d3t+B$\u0017\r^3\u0002#9,XNU3d_J$7/\u00169eCR,\u0007%\u0001\nwKJLg-[2bi&|gNU8x\u0017\u0016L\u0018a\u0005<fe&4\u0017nY1uS>t'k\\<LKf\u0004\u0013a\u0004<fe&4\u0017nY1uS>t7i\u001c7\u0002!Y,'/\u001b4jG\u0006$\u0018n\u001c8D_2\u0004\u0013aF8sS\u001eLg.\u00197WKJLg-[2bi&|gNV1m\u0003ay'/[4j]\u0006dg+\u001a:jM&\u001c\u0017\r^5p]Z\u000bG\u000eI\u0001\u0017kB$\u0017\r^3e-\u0016\u0014\u0018NZ5dCRLwN\u001c,bY\u00069R\u000f\u001d3bi\u0016$g+\u001a:jM&\u001c\u0017\r^5p]Z\u000bG\u000eI\u0001\u000bS:LG/[1mSj,Gc\u0001&\u00020!9\u0011\u0011\u0007\u0010A\u0002\u0005M\u0012a\u0002;f[B$\u0015N\u001d\t\u0005\u0003k\t\u0019%\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u00111\u0017\u000e\\3\u000b\t\u0005u\u0012qH\u0001\u0004]&|'BAA!\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0013q\u0007\u0002\u0005!\u0006$\b\u000e\u000b\u0003\u00020\u0005%\u0003\u0003BA&\u0003;j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0003S>TA!a\u0015\u0002V\u0005\u0019\u0011\r]5\u000b\t\u0005]\u0013\u0011L\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tY&M\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003?\niEA\u0004UK6\u0004H)\u001b:)\u0007y\t\u0019\u0007\u0005\u0003\u0002f\u0005\u001dTBAA)\u0013\u0011\tI'!\u0015\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005Q\u0005fA\u0010\u0002rA!\u0011QMA:\u0013\u0011\t)(!\u0015\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\n;fgRlU\r^1eCR\f'i\\8ugR\u0014\u0018\r]\"P/:{g\u000eU1si&$\u0018n\u001c8fI\"\u001a\u0001%a\u001f\u0011\t\u0005\u0015\u0014QP\u0005\u0005\u0003\u007f\n\tF\u0001\u0003UKN$\u0018\u0001\f;fgRlU\r^1eCR\f'i\\8ugR\u0014\u0018\r]\"P/\"Kg/Z*us2,\u0007+\u0019:uSRLwN\\3e)\rQ\u0015Q\u0011\u0005\u0007\u0003\u000f\u000b\u0003\u0019A/\u0002\u001b\t|w\u000e^:ue\u0006\u0004Xj\u001c3fQ\u001d\t\u00131RAN\u0003;\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\t)*!\u0016\u0002\rA\f'/Y7t\u0013\u0011\tI*a$\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ty*a)\"\u0005\u0005\u0005\u0016!D'F)\u0006#\u0015\tV!`\u001f:c\u0015,\t\u0002\u0002&\u0006Ya)\u0016'M?J+5i\u0014*EQ\r\t\u0013\u0011\u0016\t\u0005\u0003W\u000bi+\u0004\u0002\u0002\u0014&!\u0011qVAJ\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001$i\u0016\u001cH/T3uC\u0012\fG/\u0019\"p_R\u001cHO]1q\u0007>;\u0006+\u0019:uSRLwN\\3eQ\r\u0011\u00131P\u00016i\u0016\u001cH/T3uC\u0012\fG/\u0019\"p_R\u001cHO]1q\u001b>\u0013\u0006+\u0019:uSRLwN\\3e\u0013:d\u0017N\\3D_6\u0004\u0018m\u0019;j_:|e\u000eK\u0002$\u0003w\n1\u0005^3ti6+G/\u00193bi\u0006\u0014un\u001c;tiJ\f\u0007/T(S!\u0006\u0014H/\u001b;j_:,G\rK\u0002%\u0003w\nq\u0004^3ti\u001a+H\u000e\u001c\"p_R\u001cHO]1q\u0007>;\u0006+\u0019:uSRLwN\\3eQ\r)\u00131P\u00014i\u0016\u001cH/T3uC\u0012\fG/\u0019\"p_R\u001cHO]1q\u001b>\u0013\u0006+\u0019:uSRLwN\\3e\u0013:d\u0017N\\3DYV\u001cH/\u001a:j]\u001eD3AJA>\u0003\r\u0012XO\\'fi\u0006$\u0017\r^1C_>$8\u000f\u001e:ba\u0006sGMV3sS\u001aL8i\\7nSR$r!XAe\u0003\u001b\f\t\u000e\u0003\u0004\u0002L\u001e\u0002\r!X\u0001\ni\u0006\u0014G.\u001a+za\u0016D\u0001\"a4(!\u0003\u0005\rAU\u0001\nKb$(/Y(qiNDa!a5(\u0001\u0004i\u0016\u0001\u00062p_R\u001cHO]1q\u0017\u0016Lx-\u001a8DY\u0006\u001c8/A\u0017sk:lU\r^1eCR\f'i\\8ugR\u0014\u0018\r]!oIZ+'/\u001b4z\u0007>lW.\u001b;%I\u00164\u0017-\u001e7uII*\"!!7+\u0007I\u000bYn\u000b\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018!C;oG\",7m[3e\u0015\r\t9oN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAv\u0003C\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m1XM]5gs&s7M]3nK:$\u0018\r\u001c,jK^\u0014Vm];miRI!*!=\u0002v\u0006e(1\u0001\u0005\u0007\u0003gL\u0003\u0019A/\u00025\t|w\u000e^:ue\u0006\u00048i\\7nSRLen\u001d;b]R$\u0016.\\3\t\r\u0005]\u0018\u00061\u0001^\u0003]a\u0017\r^3ti\u000e{W.\\5u\u0013:\u001cH/\u00198u)&lW\rC\u0004\u0002|&\u0002\r!!@\u0002\u001b%\u001c\b+\u0019:uSRLwN\\3e!\r1\u0014q`\u0005\u0004\u0005\u00039$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u000bI\u0003\u0019AA\u007f\u0003YI7\u000fS5wKN#\u0018\u0010\\3QCJ$\u0018\u000e^5p]\u0016$\u0007")
public class TestDataSourceForBootstrap {
    private SparkSession spark;
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.DELETE_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BULKINSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
    private String basePath;
    private String srcPath;
    private FileSystem fs;
    private final List<String> partitionPaths = new .colon.colon((Object)"2020-04-01", (List)new .colon.colon((Object)"2020-04-02", (List)new .colon.colon((Object)"2020-04-03", (List)Nil$.MODULE$)));
    private final int numRecords;
    private final int numRecordsUpdate;
    private final String verificationRowKey;
    private final String verificationCol;
    private final String originalVerificationVal;
    private final String updatedVerificationVal;

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String basePath() {
        return this.basePath;
    }

    public void basePath_$eq(String x$1) {
        this.basePath = x$1;
    }

    public String srcPath() {
        return this.srcPath;
    }

    public void srcPath_$eq(String x$1) {
        this.srcPath = x$1;
    }

    public FileSystem fs() {
        return this.fs;
    }

    public void fs_$eq(FileSystem x$1) {
        this.fs = x$1;
    }

    public List<String> partitionPaths() {
        return this.partitionPaths;
    }

    public int numRecords() {
        return this.numRecords;
    }

    public int numRecordsUpdate() {
        return this.numRecordsUpdate;
    }

    public String verificationRowKey() {
        return this.verificationRowKey;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String originalVerificationVal() {
        return this.originalVerificationVal;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @BeforeEach
    public void initialize(@TempDir java.nio.file.Path tempDir) {
        this.spark_$eq(SparkSession$.MODULE$.builder().appName("Hoodie Datasource test").master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate());
        this.basePath_$eq(new StringBuilder(5).append(((Object)tempDir.toAbsolutePath()).toString()).append("/base").toString());
        this.srcPath_$eq(new StringBuilder(4).append(((Object)tempDir.toAbsolutePath()).toString()).append("/src").toString());
        this.fs_$eq(FSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration()));
    }

    @AfterEach
    public void tearDown() {
        block1: {
            if (this.spark() != null) {
                this.spark().stop();
                this.spark_$eq(null);
            }
            if (this.fs() == null) break block1;
            this.fs().close();
            this.fs_$eq(null);
        }
    }

    @Test
    public void testMetadataBootstrapCOWNonPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), Collections.emptyList(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").mode(SaveMode.Overwrite).save(this.srcPath());
        String bootstrapKeygenClass = NonpartitionedKeyGenerator.class.getName();
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)this.commonOpts().$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)bootstrapKeygenClass)}))), bootstrapKeygenClass);
        Predef$.MODULE$.assert(!this.fs().exists(new Path(this.basePath(), ".hoodie/.temp/00000000000001")));
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), Collections.emptyList(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), bootstrapKeygenClass).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDF1WithBasePath = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1WithBasePath.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF1WithBasePath.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, false, false);
    }

    @ParameterizedTest
    @ValueSource(strings={"METADATA_ONLY", "FULL_RECORD"})
    public void testMetadataBootstrapCOWHiveStylePartitioned(String bootstrapMode) {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).format("parquet").mode(SaveMode.Overwrite).save(this.srcPath());
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr").$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE.key()), (Object)bootstrapMode)}))), SimpleKeyGenerator.class.getName());
        Predef$.MODULE$.assert(!this.fs().exists(new Path(this.basePath(), ".hoodie/.temp/00000000000001")));
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), "true").mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDF4 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF4.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, true, true);
    }

    @Test
    public void testMetadataBootstrapCOWPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1 & Serializable & scala.Serializable)partitionPath -> {
            TestDataSourceForBootstrap.$anonfun$testMetadataBootstrapCOWPartitioned$1(this, sourceDF, partitionPath);
            return BoxedUnit.UNIT;
        });
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr"), SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewWithBasePathDF1 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewWithBasePathDF1.count());
        Dataset updateDf1 = hoodieROViewDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        updateDf1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        hoodieROViewDF2.collect();
        Assertions.assertEquals((Object)this.updatedVerificationVal(), (Object)((Row)hoodieROViewDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF2 = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime3 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDF4 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF4.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF4.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime3, true, false);
    }

    @Test
    public void testMetadataBootstrapMORPartitionedInlineCompactionOn() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1 & Serializable & scala.Serializable)partitionPath -> {
            TestDataSourceForBootstrap.$anonfun$testMetadataBootstrapMORPartitionedInlineCompactionOn$1(this, sourceDF, partitionPath);
            return BoxedUnit.UNIT;
        });
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr"), SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").option(HoodieCompactionConfig.INLINE_COMPACT.key(), "true").option(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF2.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDFWithBasePath.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
    }

    @Test
    public void testMetadataBootstrapMORPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1 & Serializable & scala.Serializable)partitionPath -> {
            TestDataSourceForBootstrap.$anonfun$testMetadataBootstrapMORPartitioned$1(this, sourceDF, partitionPath);
            return BoxedUnit.UNIT;
        });
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr"), SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
        Dataset updateDf1 = hoodieROViewDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        updateDf1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        hoodieROViewDF2.collect();
        Assertions.assertEquals((Object)this.originalVerificationVal(), (Object)((Row)hoodieROViewDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF2 = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)0L, (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
    }

    @Test
    public void testFullBootstrapCOWPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1 & Serializable & scala.Serializable)partitionPath -> {
            TestDataSourceForBootstrap.$anonfun$testFullBootstrapCOWPartitioned$1(this, sourceDF, partitionPath);
            return BoxedUnit.UNIT;
        });
        Dataset bootstrapDF = this.spark().emptyDataFrame();
        bootstrapDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").option(HoodieBootstrapConfig.BASE_PATH.key(), this.srcPath()).option(HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).option(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), FullRecordBootstrapModeSelector.class.getName()).option(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.key(), SparkParquetBootstrapDataProvider.class.getName()).mode(SaveMode.Overwrite).save(this.basePath());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((Object)"00000000000002", (Object)commitInstantTime1);
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF2.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, true, false);
    }

    @Test
    public void testMetadataBootstrapMORPartitionedInlineClustering() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).mode(SaveMode.Overwrite).save(this.srcPath());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"datestr")})));
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)writeOpts, SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "true").option(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key(), "1").option(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
    }

    public String runMetadataBootstrapAndVerifyCommit(String tableType, scala.collection.immutable.Map<String, String> extraOpts, String bootstrapKeygenClass) {
        Dataset bootstrapDF = this.spark().emptyDataFrame();
        bootstrapDF.write().format("hudi").options(extraOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option(HoodieBootstrapConfig.BASE_PATH.key(), this.srcPath()).option(HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key(), bootstrapKeygenClass).mode(SaveMode.Overwrite).save(this.basePath());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        String expectedBootstrapInstant = "FULL_RECORD".equals(extraOpts.getOrElse((Object)HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE.defaultValue())) ? "00000000000002" : "00000000000001";
        Assertions.assertEquals((Object)expectedBootstrapInstant, (Object)commitInstantTime1);
        return commitInstantTime1;
    }

    public scala.collection.immutable.Map<String, String> runMetadataBootstrapAndVerifyCommit$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public void verifyIncrementalViewResult(String bootstrapCommitInstantTime, String latestCommitInstantTime, boolean isPartitioned, boolean isHiveStylePartitioned) {
        block0: {
            Dataset hoodieIncViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), bootstrapCommitInstantTime).load(this.basePath());
            Assertions.assertEquals((long)this.numRecords(), (long)hoodieIncViewDF1.count());
            Row[] countsPerCommit = (Row[])hoodieIncViewDF1.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
            Assertions.assertEquals((int)1, (int)countsPerCommit.length);
            Assertions.assertEquals((Object)bootstrapCommitInstantTime, (Object)countsPerCommit[0].get(0));
            Dataset hoodieIncViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), bootstrapCommitInstantTime).load(this.basePath());
            Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieIncViewDF2.count());
            countsPerCommit = (Row[])hoodieIncViewDF2.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
            Assertions.assertEquals((int)1, (int)countsPerCommit.length);
            Assertions.assertEquals((Object)latestCommitInstantTime, (Object)countsPerCommit[0].get(0));
            if (!isPartitioned) break block0;
            String relativePartitionPath = isHiveStylePartitioned ? "/datestr=2020-04-02/*" : "/2020-04-02/*";
            Dataset hoodieIncViewDF3 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), bootstrapCommitInstantTime).option(DataSourceReadOptions$.MODULE$.INCR_PATH_GLOB().key(), relativePartitionPath).load(this.basePath());
            Assertions.assertEquals((long)hoodieIncViewDF2.filter(functions$.MODULE$.col("_hoodie_partition_path").contains((Object)"2020-04-02")).count(), (long)hoodieIncViewDF3.count());
        }
    }

    public static final /* synthetic */ void $anonfun$testMetadataBootstrapCOWPartitioned$1(TestDataSourceForBootstrap $this, Dataset sourceDF$1, String partitionPath) {
        sourceDF$1.filter(sourceDF$1.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder(1).append($this.srcPath()).append("/").append(partitionPath).toString());
    }

    public static final /* synthetic */ void $anonfun$testMetadataBootstrapMORPartitionedInlineCompactionOn$1(TestDataSourceForBootstrap $this, Dataset sourceDF$2, String partitionPath) {
        sourceDF$2.filter(sourceDF$2.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder(1).append($this.srcPath()).append("/").append(partitionPath).toString());
    }

    public static final /* synthetic */ void $anonfun$testMetadataBootstrapMORPartitioned$1(TestDataSourceForBootstrap $this, Dataset sourceDF$3, String partitionPath) {
        sourceDF$3.filter(sourceDF$3.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder(1).append($this.srcPath()).append("/").append(partitionPath).toString());
    }

    public static final /* synthetic */ void $anonfun$testFullBootstrapCOWPartitioned$1(TestDataSourceForBootstrap $this, Dataset sourceDF$4, String partitionPath) {
        sourceDF$4.filter(sourceDF$4.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder(1).append($this.srcPath()).append("/").append(partitionPath).toString());
    }

    public TestDataSourceForBootstrap() {
        this.numRecords = 100;
        this.numRecordsUpdate = 10;
        this.verificationRowKey = "trip_0";
        this.verificationCol = "driver";
        this.originalVerificationVal = "driver_0";
        this.updatedVerificationVal = "driver_update";
    }
}

