/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4A\u0001D\u0007\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001a\u0001\n\u0003\u0011\u0003b\u0002\u0016\u0001\u0001\u0004%\ta\u000b\u0005\u0007i\u0001\u0001\u000b\u0015B\u0012\t\u000fU\u0002!\u0019!C\u0001m!1q\t\u0001Q\u0001\n]BQ\u0001\u0013\u0001\u0005B%CQ!\u0016\u0001\u0005B%CQA\u0017\u0001\u0005\u0002%CQa\u0018\u0001\u0005\u0002%CQ!\u0019\u0001\u0005\u0002%\u0013A\u0004V3ti\u0012\u000bG/Y*pkJ\u001cWMR8s\u0005V\u001c7.\u001a;J]\u0012,\u0007P\u0003\u0002\u000f\u001f\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005A\t\u0012\u0001\u00025vI&T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQr\"A\u0005uKN$X\u000f^5mg&\u0011A$\u0007\u0002\u0015\u0011>|G-[3DY&,g\u000e\u001e+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005i\u0011!B:qCJ\\W#A\u0012\u0011\u0005\u0011BS\"A\u0013\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0011%E\u0005\u0003S\u0015\u0012Ab\u00159be.\u001cVm]:j_:\f\u0011b\u001d9be.|F%Z9\u0015\u00051\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#\u0001B+oSRDqaM\u0002\u0002\u0002\u0003\u00071%A\u0002yIE\naa\u001d9be.\u0004\u0013AC2p[6|gn\u00149ugV\tq\u0007\u0005\u00039{}zT\"A\u001d\u000b\u0005iZ\u0014!C5n[V$\u0018M\u00197f\u0015\tad&\u0001\u0006d_2dWm\u0019;j_:L!AP\u001d\u0003\u00075\u000b\u0007\u000f\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006!A.\u00198h\u0015\u0005!\u0015\u0001\u00026bm\u0006L!AR!\u0003\rM#(/\u001b8h\u0003-\u0019w.\\7p]>\u0003Ho\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u00031B#aB&\u0011\u00051\u001bV\"A'\u000b\u00059{\u0015aA1qS*\u0011\u0001+U\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00116#A\u0003kk:LG/\u0003\u0002U\u001b\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#\u0001C,\u0011\u00051C\u0016BA-N\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\tuKN$Hi\\;cY\u0016Len]3si\"\u0012\u0011\u0002\u0018\t\u0003\u0019vK!AX'\u0003\tQ+7\u000f^\u0001\u0019i\u0016\u001cHoQ8v]R<\u0016\u000e\u001e5Ck\u000e\\W\r^%oI\u0016D\bF\u0001\u0006]\u0003M!Xm\u001d;J]N,'\u000f^(wKJ<(/\u001b;fQ\tYA\f")
public class TestDataSourceForBucketIndex
extends HoodieClientTestBase {
    private SparkSession spark = null;
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)HoodieIndex.IndexType.BUCKET.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key()), (Object)"8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLayoutConfig.LAYOUT_TYPE.key()), (Object)HoodieStorageLayout.LayoutType.BUCKET.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME.key()), (Object)SparkBucketIndexPartitioner.class.getName())}));

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @Test
    public void testDoubleInsert() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF1.count());
    }

    @Test
    public void testCountWithBucketIndex() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.count());
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String commit2Time = ((Row)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertEquals((long)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)1L);
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(commit2Time)).$greater((Object)commit1Time));
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.join(hudiSnapshotDF1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        String[] partitionPaths = new String[]{"2020/01/10"};
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitionPaths);
        List records4 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("004", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF4 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF4.count());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.join(hudiSnapshotDF4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "inner").count());
    }

    @Test
    public void testInsertOverwrite() {
        String[] partitionPaths = new String[]{"2020/01/10"};
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitionPaths);
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("002", Predef$.MODULE$.int2Integer(20)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)20L, (long)hudiSnapshotDF1.count());
    }
}

