/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0004\b\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001a\u0001\n\u0003\u0019\u0003bB\u0016\u0001\u0001\u0004%\t\u0001\f\u0005\u0007k\u0001\u0001\u000b\u0015\u0002\u0013\t\u000fY\u0002!\u0019!C\u0005o!1a\b\u0001Q\u0001\naBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004R\u0001\u0001\u0006I!\u0011\u0005\u0006%\u0002!\te\u0015\u0005\u0006?\u0002!\te\u0015\u0005\u0006I\u0002!\ta\u0015\u0005\u0006S\u0002!\ta\u0015\u0002\u0019)\u0016\u001cH\u000fS8pI&,\u0017i\u0019;jm\u0016$\u0016.\\3mS:,'BA\b\u0011\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u0003#I\tA\u0001[;eS*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m\u0001\u0012!\u0003;fgR,H/\u001b7t\u0013\ti\"D\u0001\u000bI_>$\u0017.Z\"mS\u0016tG\u000fV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u00039\tQa\u001d9be.,\u0012\u0001\n\t\u0003K%j\u0011A\n\u0006\u0003O!\n1a]9m\u0015\t\u0011##\u0003\u0002+M\ta1\u000b]1sWN+7o]5p]\u0006I1\u000f]1sW~#S-\u001d\u000b\u0003[M\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012A!\u00168ji\"9AgAA\u0001\u0002\u0004!\u0013a\u0001=%c\u000511\u000f]1sW\u0002\n1\u0001\\8h+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e\u0013\u0003\u0015awn\u001a\u001bk\u0013\ti$H\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\u0006d_6lwN\\(qiN,\u0012!\u0011\t\u0005\u0005\u001eK\u0015*D\u0001D\u0015\t!U)A\u0005j[6,H/\u00192mK*\u0011aiL\u0001\u000bG>dG.Z2uS>t\u0017B\u0001%D\u0005\ri\u0015\r\u001d\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u0019\u0019FO]5oO\u0006Y1m\\7n_:|\u0005\u000f^:!\u0003\u0015\u0019X\r^+q)\u0005i\u0003FA\u0005V!\t1V,D\u0001X\u0015\tA\u0016,A\u0002ba&T!AW.\u0002\u000f),\b/\u001b;fe*\u0011A\fF\u0001\u0006UVt\u0017\u000e^\u0005\u0003=^\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007F\u0001\u0006b!\t1&-\u0003\u0002d/\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001-i\u0016\u001cHoR3u\u0019\u0006\u001cHoQ8n[&$X*\u001a;bI\u0006$\u0018mV5uQZ\u000bG.\u001b3ECR\fgi\u001c:D\u001f^C#a\u00034\u0011\u0005Y;\u0017B\u00015X\u0005\u0011!Vm\u001d;\u0002YQ,7\u000f^$fi2\u000b7\u000f^\"p[6LG/T3uC\u0012\fG/Y,ji\"4\u0016\r\\5e\t\u0006$\u0018MR8s\u001b>\u0013\u0006F\u0001\u0007g\u0001")
public class TestHoodieActiveTimeline
extends HoodieClientTestBase {
    private SparkSession spark = null;
    private final Logger log = LogManager.getLogger(TestHoodieActiveTimeline.class);
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @Test
    public void testGetLastCommitMetadataWithValidDataForCOW() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        String commit1Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        String[] partitionsForCommit1 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().read().format("org.apache.hudi").load(this.basePath).select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(0).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"2015/03/16", "2015/03/17", "2016/03/15"})).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionsForCommit1)));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.hadoopConf).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        Option ret1 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret1.isPresent());
        Tuple2 tuple2 = new Tuple2(((Pair)ret1.get()).getLeft(), ((Pair)ret1.get()).getRight());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HoodieInstant instant1 = (HoodieInstant)tuple2._1();
        HoodieCommitMetadata commitMetadata1 = (HoodieCommitMetadata)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)instant1, (Object)commitMetadata1);
        Tuple2 tuple23 = tuple22;
        HoodieInstant instant12 = (HoodieInstant)tuple23._1();
        HoodieCommitMetadata commitMetadata12 = (HoodieCommitMetadata)tuple23._2();
        Assertions.assertEquals((Object)instant12.getTimestamp(), (Object)commit1Time);
        String relativePath1 = (String)commitMetadata12.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath1.contains(commit1Time));
        Predef$.MODULE$.assert(relativePath1.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        this.spark().emptyDataFrame().write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_PARTITION_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), "2015/03/16").mode(SaveMode.Append).save(this.basePath);
        String commit2Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        long countPartitionDropped = this.spark().read().format("org.apache.hudi").load(this.basePath).where("_hoodie_partition_path = '2015/03/16'").count();
        Assertions.assertEquals((long)countPartitionDropped, (long)0L);
        activeTimeline = activeTimeline.reload();
        Option ret2 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret2.isPresent());
        Tuple2 tuple24 = new Tuple2(((Pair)ret2.get()).getLeft(), ((Pair)ret2.get()).getRight());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        HoodieInstant instant2 = (HoodieInstant)tuple24._1();
        HoodieCommitMetadata commitMetadata2 = (HoodieCommitMetadata)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)instant2, (Object)commitMetadata2);
        Tuple2 tuple26 = tuple25;
        HoodieInstant instant22 = (HoodieInstant)tuple26._1();
        HoodieCommitMetadata commitMetadata22 = (HoodieCommitMetadata)tuple26._2();
        Assertions.assertEquals((Object)instant22.getTimestamp(), (Object)commit1Time);
        String relativePath2 = (String)commitMetadata22.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath2.contains(commit1Time));
        Predef$.MODULE$.assert(relativePath2.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        List records3 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit3Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret3 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret3.isPresent());
        Tuple2 tuple27 = new Tuple2(((Pair)ret3.get()).getLeft(), ((Pair)ret3.get()).getRight());
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        HoodieInstant instant3 = (HoodieInstant)tuple27._1();
        HoodieCommitMetadata commitMetadata3 = (HoodieCommitMetadata)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)instant3, (Object)commitMetadata3);
        Tuple2 tuple29 = tuple28;
        HoodieInstant instant32 = (HoodieInstant)tuple29._1();
        HoodieCommitMetadata commitMetadata32 = (HoodieCommitMetadata)tuple29._2();
        Assertions.assertEquals((Object)instant32.getTimestamp(), (Object)commit3Time);
        String relativePath3 = (String)commitMetadata32.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath3.contains(commit3Time));
        Predef$.MODULE$.assert(relativePath3.contains(HoodieFileFormat.PARQUET.getFileExtension()));
    }

    @Test
    public void testGetLastCommitMetadataWithValidDataForMOR() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        String commit1Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.hadoopConf).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        Option ret1 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret1.isPresent());
        Tuple2 tuple2 = new Tuple2(((Pair)ret1.get()).getLeft(), ((Pair)ret1.get()).getRight());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HoodieInstant instant1 = (HoodieInstant)tuple2._1();
        HoodieCommitMetadata commitMetadata1 = (HoodieCommitMetadata)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)instant1, (Object)commitMetadata1);
        Tuple2 tuple23 = tuple22;
        HoodieInstant instant12 = (HoodieInstant)tuple23._1();
        HoodieCommitMetadata commitMetadata12 = (HoodieCommitMetadata)tuple23._2();
        Assertions.assertEquals((Object)instant12.getTimestamp(), (Object)commit1Time);
        String relativePath1 = (String)commitMetadata12.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath1.contains(commit1Time));
        Predef$.MODULE$.assert(relativePath1.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit2Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret2 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret2.isPresent());
        Tuple2 tuple24 = new Tuple2(((Pair)ret2.get()).getLeft(), ((Pair)ret2.get()).getRight());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        HoodieInstant instant2 = (HoodieInstant)tuple24._1();
        HoodieCommitMetadata commitMetadata2 = (HoodieCommitMetadata)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)instant2, (Object)commitMetadata2);
        Tuple2 tuple26 = tuple25;
        HoodieInstant instant22 = (HoodieInstant)tuple26._1();
        HoodieCommitMetadata commitMetadata22 = (HoodieCommitMetadata)tuple26._2();
        Assertions.assertEquals((Object)instant22.getTimestamp(), (Object)commit2Time);
        String relativePath2 = (String)commitMetadata22.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath2.contains(commit1Time));
        Predef$.MODULE$.assert(relativePath2.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension()));
        List records3 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "true").option("hoodie.compact.inline.max.delta.commits", "1").mode(SaveMode.Append).save(this.basePath);
        String commit3Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret3 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret3.isPresent());
        Tuple2 tuple27 = new Tuple2(((Pair)ret3.get()).getLeft(), ((Pair)ret3.get()).getRight());
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        HoodieInstant instant3 = (HoodieInstant)tuple27._1();
        HoodieCommitMetadata commitMetadata3 = (HoodieCommitMetadata)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)instant3, (Object)commitMetadata3);
        Tuple2 tuple29 = tuple28;
        HoodieInstant instant32 = (HoodieInstant)tuple29._1();
        HoodieCommitMetadata commitMetadata32 = (HoodieCommitMetadata)tuple29._2();
        Assertions.assertEquals((Object)instant32.getTimestamp(), (Object)commit3Time);
        String relativePath3 = (String)commitMetadata32.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath3.contains(commit3Time));
        Predef$.MODULE$.assert(relativePath3.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        List records4 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("004", Predef$.MODULE$.int2Integer(50)))).toList();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit4Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret4 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret4.isPresent());
        Tuple2 tuple210 = new Tuple2(((Pair)ret4.get()).getLeft(), ((Pair)ret4.get()).getRight());
        if (tuple210 == null) {
            throw new MatchError((Object)tuple210);
        }
        HoodieInstant instant4 = (HoodieInstant)tuple210._1();
        HoodieCommitMetadata commitMetadata4 = (HoodieCommitMetadata)tuple210._2();
        Tuple2 tuple211 = new Tuple2((Object)instant4, (Object)commitMetadata4);
        Tuple2 tuple212 = tuple211;
        HoodieInstant instant42 = (HoodieInstant)tuple212._1();
        HoodieCommitMetadata commitMetadata42 = (HoodieCommitMetadata)tuple212._2();
        Assertions.assertEquals((Object)instant42.getTimestamp(), (Object)commit4Time);
        String relativePath4 = (String)commitMetadata42.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath4.contains(commit3Time));
        Predef$.MODULE$.assert(relativePath4.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension()));
    }
}

