/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.function.BiPredicate;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\f\u0018\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001A\u0002\u0013\u0005A\u0006C\u00045\u0001\u0001\u0007I\u0011A\u001b\t\ry\u0002\u0001\u0015)\u0003.\u0011\u001dy\u0004A1A\u0005\n\u0001Caa\u0012\u0001!\u0002\u0013\t\u0005b\u0002%\u0001\u0005\u0004%I!\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002&\t\u000f9\u0003!\u0019!C\u0001\u001f\"1\u0001\r\u0001Q\u0001\nACq!\u0019\u0001C\u0002\u0013\u0005!\r\u0003\u0004n\u0001\u0001\u0006Ia\u0019\u0005\b]\u0002\u0011\r\u0011\"\u0001c\u0011\u0019y\u0007\u0001)A\u0005G\")\u0001\u000f\u0001C!c\")Q\u0010\u0001C!c\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u001f\u0001\u0011%\u0011q\b\u0005\b\u0003/\u0002A\u0011BA-\u00111\t9\u0007\u0001I\u0001\u0002\u0003\u0005I\u0011AA5\u00111\t9\b\u0001I\u0001\u0002\u0003\u0005I\u0011AA=\u0005\u0011\"Vm\u001d;J]\u000e\u0014X-\\3oi\u0006d'+Z1e/&$\bNR;mYR\u000b'\r\\3TG\u0006t'B\u0001\r\u001a\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u00035m\tA\u0001[;eS*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011J\u0012!\u0003;fgR,H/\u001b7t\u0013\t13E\u0001\u000bI_>$\u0017.Z\"mS\u0016tG\u000fV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003]\tQa\u001d9be.,\u0012!\f\t\u0003]Ij\u0011a\f\u0006\u0003aE\n1a]9m\u0015\tY3$\u0003\u00024_\ta1\u000b]1sWN+7o]5p]\u0006I1\u000f]1sW~#S-\u001d\u000b\u0003mq\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012A!\u00168ji\"9QhAA\u0001\u0002\u0004i\u0013a\u0001=%c\u000511\u000f]1sW\u0002\n1\u0001\\8h+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u001c\u0003\u0015awn\u001a\u001bk\u0013\t15I\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\u0007qKJ\u0014\u0015\r^2i'&TX-F\u0001K!\t94*\u0003\u0002Mq\t\u0019\u0011J\u001c;\u0002\u001bA,'OQ1uG\"\u001c\u0016N_3!\u0003)\u0019w.\\7p]>\u0003Ho]\u000b\u0002!B!\u0011K\u0016-Y\u001b\u0005\u0011&BA*U\u0003%IW.\\;uC\ndWM\u0003\u0002Vq\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0013&aA'baB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005Y\u0006twMC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&AB*ue&tw-A\u0006d_6lwN\\(qiN\u0004\u0013a\u0004<fe&4\u0017nY1uS>t7i\u001c7\u0016\u0003\r\u0004\"\u0001Z6\u000f\u0005\u0015L\u0007C\u000149\u001b\u00059'B\u00015 \u0003\u0019a$o\\8u}%\u0011!\u000eO\u0001\u0007!J,G-\u001a4\n\u0005}c'B\u000169\u0003A1XM]5gS\u000e\fG/[8o\u0007>d\u0007%\u0001\fva\u0012\fG/\u001a3WKJLg-[2bi&|gNV1m\u0003])\b\u000fZ1uK\u00124VM]5gS\u000e\fG/[8o-\u0006d\u0007%A\u0003tKR,\u0006\u000fF\u00017Q\ty1\u000f\u0005\u0002uw6\tQO\u0003\u0002wo\u0006\u0019\u0011\r]5\u000b\u0005aL\u0018a\u00026va&$XM\u001d\u0006\u0003uv\tQA[;oSRL!\u0001`;\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\t\u0001r\u0010E\u0002u\u0003\u0003I1!a\u0001v\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0019uKN$h)Y5m\u000b\u0006\u0014H.\u001f$pe&s7M\u001d,jK^\fV/\u001a:z\r>\u0014hj\u001c8Fq&\u001cH/\u001b8h\r&dWm\u001d\u000b\u0004m\u0005%\u0001bBA\u0006#\u0001\u0007\u0011QB\u0001\ni\u0006\u0014G.\u001a+za\u0016\u0004B!a\u0004\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0003n_\u0012,GNC\u0002\u0002\u0018e\taaY8n[>t\u0017\u0002BA\u000e\u0003#\u0011q\u0002S8pI&,G+\u00192mKRK\b/\u001a\u0015\b#\u0005}\u0011qFA\u0019!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003S9\u0018A\u00029be\u0006l7/\u0003\u0003\u0002.\u0005\r\"AC#ok6\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\u0012\u0011Q\u0002\u0015\u0004#\u0005U\u0002\u0003BA\u001c\u0003si!!a\n\n\t\u0005m\u0012q\u0005\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018!\b:v]&s7M]3nK:$\u0018\r\\)vKJL\u0018I\u001c3D_6\u0004\u0018M]3\u0015\u0013Y\n\t%!\u0012\u0002J\u00055\u0003BBA\"%\u0001\u00071-A\u0004ti\u0006\u0014H\u000fV:\t\r\u0005\u001d#\u00031\u0001d\u0003\u0015)g\u000e\u001a+t\u0011\u0019\tYE\u0005a\u0001\u0015\u0006A!-\u0019;dQ:+X\u000eC\u0004\u0002PI\u0001\r!!\u0015\u0002+\u0019\fG\u000e\u001c\"bG.4U\u000f\u001c7UC\ndWmU2b]B\u0019q'a\u0015\n\u0007\u0005U\u0003HA\u0004C_>dW-\u00198\u00029MDw.\u001e7e)\"\u0014xn^%g\r\u0006dGNY1dW&\u001bh)\u00197tKR)a'a\u0017\u0002^!9\u00111B\nA\u0002\u00055\u0001bBA0'\u0001\u0007\u0011\u0011M\u0001\u0003M:\u0004BaNA2m%\u0019\u0011Q\r\u001d\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014!\u00059s_R,7\r^3eI\u0011\fG/Y$f]R!\u00111NA;!\u0011\ti'!\u001d\u000e\u0005\u0005=$b\u0001\u0013\u0002\u0016%!\u00111OA8\u0005]Aun\u001c3jKR+7\u000f\u001e#bi\u0006<UM\\3sCR|'\u000fC\u0004>)\u0005\u0005\t\u0019A\u0015\u0002%A\u0014x\u000e^3di\u0016$GEY1tKB\u000bG\u000f\u001b\u000b\u00041\u0006m\u0004bB\u001f\u0016\u0003\u0003\u0005\r!\u000b")
public class TestIncrementalReadWithFullTableScan
extends HoodieClientTestBase {
    private SparkSession spark = null;
    private final Logger log = LogManager.getLogger(TestIncrementalReadWithFullTableScan.class);
    private final int perBatchSize;
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")}));
    private final String verificationCol;
    private final String updatedVerificationVal;

    public /* synthetic */ HoodieTestDataGenerator protected$dataGen(TestIncrementalReadWithFullTableScan x$1) {
        return x$1.dataGen;
    }

    public /* synthetic */ String protected$basePath(TestIncrementalReadWithFullTableScan x$1) {
        return x$1.basePath;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Logger log() {
        return this.log;
    }

    private int perBatchSize() {
        return this.perBatchSize;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testFailEarlyForIncrViewQueryForNonExistingFiles(HoodieTableType tableType) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.protected$dataGen(this).generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), Predef$.MODULE$.int2Integer(this.perBatchSize())))).toList();
            Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
            inputDF.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType.name()).option("hoodie.cleaner.commits.retained", "3").option("hoodie.keep.min.commits", "4").option("hoodie.keep.max.commits", "5").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.protected$basePath(this));
        });
        HoodieTableMetaClient hoodieMetaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        HoodieTimeline completedCommits = hoodieMetaClient.getCommitsTimeline().filterCompletedInstants();
        Object[] archivedInstants = hoodieMetaClient.getArchivedTimeline().filterCompletedInstants().getInstants().distinct().toArray();
        String startUnarchivedCommitTs = ((HoodieInstant)completedCommits.nthInstant(0).get()).getTimestamp();
        String endUnarchivedCommitTs = ((HoodieInstant)completedCommits.nthInstant(1).get()).getTimestamp();
        String startArchivedCommitTs = ((HoodieInstant)archivedInstants[0]).getTimestamp();
        String endArchivedCommitTs = ((HoodieInstant)archivedInstants[1]).getTimestamp();
        String startOutOfRangeCommitTs = HoodieInstantTimeGenerator.createNewInstantTime((long)0L);
        String endOutOfRangeCommitTs = HoodieInstantTimeGenerator.createNewInstantTime((long)0L);
        Assertions.assertTrue((boolean)HoodieTimeline.compareTimestamps((String)startOutOfRangeCommitTs, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)((HoodieInstant)completedCommits.lastInstant().get()).getTimestamp()));
        Assertions.assertTrue((boolean)HoodieTimeline.compareTimestamps((String)endOutOfRangeCommitTs, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)((HoodieInstant)completedCommits.lastInstant().get()).getTimestamp()));
        this.runIncrementalQueryAndCompare(startArchivedCommitTs, endArchivedCommitTs, 1, true);
        this.shouldThrowIfFallbackIsFalse(tableType, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runIncrementalQueryAndCompare(startArchivedCommitTs, endUnarchivedCommitTs, 5, false));
        this.runIncrementalQueryAndCompare(startArchivedCommitTs, endUnarchivedCommitTs, 5, true);
        this.shouldThrowIfFallbackIsFalse(tableType, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runIncrementalQueryAndCompare(startUnarchivedCommitTs, endUnarchivedCommitTs, 1, false));
        this.runIncrementalQueryAndCompare(startUnarchivedCommitTs, endUnarchivedCommitTs, 1, true);
        this.runIncrementalQueryAndCompare(startUnarchivedCommitTs, endOutOfRangeCommitTs, 5, true);
        this.runIncrementalQueryAndCompare(startOutOfRangeCommitTs, endOutOfRangeCommitTs, 0, false);
        this.runIncrementalQueryAndCompare(startOutOfRangeCommitTs, endOutOfRangeCommitTs, 0, true);
        this.runIncrementalQueryAndCompare(endUnarchivedCommitTs, startUnarchivedCommitTs, 0, false);
        this.runIncrementalQueryAndCompare(endUnarchivedCommitTs, startUnarchivedCommitTs, 0, true);
        Object[] reversedCommits = completedCommits.getReverseOrderedInstants().toArray();
        String startUncleanedCommitTs = ((HoodieInstant)reversedCommits[1]).getTimestamp();
        String endUncleanedCommitTs = ((HoodieInstant)reversedCommits[0]).getTimestamp();
        this.runIncrementalQueryAndCompare(startUncleanedCommitTs, endUncleanedCommitTs, 1, true);
        this.runIncrementalQueryAndCompare(startUncleanedCommitTs, endUncleanedCommitTs, 1, false);
    }

    private void runIncrementalQueryAndCompare(String startTs, String endTs, int batchNum, boolean fallBackFullTableScan) {
        Dataset hoodieIncViewDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), startTs).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), endTs).option(DataSourceReadOptions$.MODULE$.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().key(), fallBackFullTableScan).load(this.basePath);
        Assertions.assertEquals((long)(this.perBatchSize() * batchNum), (long)hoodieIncViewDF.count());
    }

    private void shouldThrowIfFallbackIsFalse(HoodieTableType tableType, Function0<BoxedUnit> fn) {
        String msg = "Should fail with Path does not exist";
        HoodieTableType hoodieTableType = tableType;
        if (HoodieTableType.COPY_ON_WRITE.equals(hoodieTableType)) {
            Assertions.assertThrows(AnalysisException.class, (Executable)new Executable(null, fn){
                private final Function0 fn$1;

                public void execute() {
                    this.fn$1.apply$mcV$sp();
                }
                {
                    this.fn$1 = fn$1;
                }
            }, (String)msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (HoodieTableType.MERGE_ON_READ.equals(hoodieTableType)) {
            SparkException exp = (SparkException)Assertions.assertThrows(SparkException.class, (Executable)new Executable(null, fn){
                private final Function0 fn$1;

                public void execute() {
                    this.fn$1.apply$mcV$sp();
                }
                {
                    this.fn$1 = fn$1;
                }
            }, (String)msg);
            Assertions.assertTrue((boolean)exp.getMessage().contains("FileNotFoundException"));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)hoodieTableType);
        }
    }

    public TestIncrementalReadWithFullTableScan() {
        this.perBatchSize = 100;
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

