/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestLayoutOptimization$;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001\u0002\u000b\u0016\u0001yAQ!\n\u0001\u0005\u0002\u0019B\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0001\u0016\t\u0013I\u0002\u0001\u0019!a\u0001\n\u0003\u0019\u0004\"\u0003\u001f\u0001\u0001\u0004\u0005\t\u0015)\u0003,\u0011\u001di\u0004A1A\u0005\u0002yBa!\u0012\u0001!\u0002\u0013y\u0004b\u0002$\u0001\u0005\u0004%\ta\u0012\u0005\u00071\u0002\u0001\u000b\u0011\u0002%\t\u000fe\u0003!\u0019!C\u0001\u000f\"1!\f\u0001Q\u0001\n!CQa\u0017\u0001\u0005BqCQ\u0001\u001b\u0001\u0005BqCQ!\u001c\u0001\u0005\u00029Dq!a\n\u0001\t\u0013\tIcB\u0004\u0002\\UA\t!!\u0018\u0007\rQ)\u0002\u0012AA0\u0011\u0019)\u0003\u0003\"\u0001\u0002n!9\u00111\u0004\t\u0005\u0002\u0005=\u0004\"CAD!\u0005\u0005I\u0011BAE\u0005Y!Vm\u001d;MCf|W\u000f^(qi&l\u0017N_1uS>t'B\u0001\f\u0018\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u00031e\tA\u0001[;eS*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t:\u0012!\u0003;fgR,H/\u001b7t\u0013\t!\u0013E\u0001\u000bI_>$\u0017.Z\"mS\u0016tG\u000fV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003U\tQa\u001d9be.,\u0012a\u000b\t\u0003YAj\u0011!\f\u0006\u0003]=\n1a]9m\u0015\tI\u0013$\u0003\u00022[\ta1\u000b]1sWN+7o]5p]\u0006I1\u000f]1sW~#S-\u001d\u000b\u0003ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012A!\u00168ji\"91hAA\u0001\u0002\u0004Y\u0013a\u0001=%c\u000511\u000f]1sW\u0002\n\u0011c]8ve\u000e,G+\u00192mKN\u001b\u0007.Z7b+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\".\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0015I\u0001\u0006TiJ,8\r\u001e+za\u0016\f!c]8ve\u000e,G+\u00192mKN\u001b\u0007.Z7bA\u0005aQ.\u001a;bI\u0006$\u0018m\u00149ugV\t\u0001\n\u0005\u0003J\u001dB\u0003V\"\u0001&\u000b\u0005-c\u0015!C5n[V$\u0018M\u00197f\u0015\tie'\u0001\u0006d_2dWm\u0019;j_:L!a\u0014&\u0003\u00075\u000b\u0007\u000f\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\rM#(/\u001b8h\u00035iW\r^1eCR\fw\n\u001d;tA\u0005Q1m\\7n_:|\u0005\u000f^:\u0002\u0017\r|W.\\8o\u001fB$8\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002i!\u00121B\u0018\t\u0003?\u001al\u0011\u0001\u0019\u0006\u0003C\n\f1!\u00199j\u0015\t\u0019G-A\u0004kkBLG/\u001a:\u000b\u0005\u0015\\\u0012!\u00026v]&$\u0018BA4a\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012AB\u001b\t\u0003?.L!\u0001\u001c1\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\t;fgRd\u0015-_8vi>\u0003H/[7ju\u0006$\u0018n\u001c8Gk:\u001cG/[8oC2$R\u0001N8|{~DQ\u0001]\u0007A\u0002E\f\u0011\u0002^1cY\u0016$\u0016\u0010]3\u0011\u0005ILhBA:x!\t!h'D\u0001v\u0015\t1X$\u0001\u0004=e>|GOP\u0005\u0003qZ\na\u0001\u0015:fI\u00164\u0017BA,{\u0015\tAh\u0007C\u0003}\u001b\u0001\u0007\u0011/A\bdYV\u001cH/\u001a:j]\u001e\f5OU8x\u0011\u0015qX\u00021\u0001r\u0003ia\u0017-_8vi>\u0003H/[7ju\u0006$\u0018n\u001c8TiJ\fG/Z4z\u0011\u0019\t\t!\u0004a\u0001c\u0006y2\u000f]1uS\u0006d7)\u001e:wK\u000e{W\u000e]8tSRLwN\\*ue\u0006$XmZ=)\u000f5\t)!!\u0006\u0002\u0018A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005=!-\u0001\u0004qCJ\fWn]\u0005\u0005\u0003'\tIA\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002\u001a\u0005\u0012\u00111D\u0001!i\u0016\u001cH\u000fT1z_V$x\n\u001d;j[&T\u0018\r^5p]B\u000b'/Y7fi\u0016\u00148\u000fK\u0002\u000e\u0003?\u0001B!!\t\u0002$5\u0011\u0011QB\u0005\u0005\u0003K\tiAA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fq\"Y:tKJ$(k\\<t\u001b\u0006$8\r\u001b\u000b\u0006i\u0005-\u0012Q\n\u0005\b\u0003[q\u0001\u0019AA\u0018\u0003\ryg.\u001a\t\u0005\u0003c\t9E\u0004\u0003\u00024\u0005\rc\u0002BA\u001b\u0003\u0003rA!a\u000e\u0002@9!\u0011\u0011HA\u001f\u001d\r!\u00181H\u0005\u00029%\u0011!dG\u0005\u0003SeI!AL\u0018\n\u0007\u0005\u0015S&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00131\n\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\u0012.\u0011\u001d\tyE\u0004a\u0001\u0003_\tQa\u001c;iKJDs\u0001AA*\u0003+\tI\u0006E\u0002`\u0003+J1!a\u0016a\u0005\r!\u0016mZ\u0011\u0002-\u00051B+Z:u\u0019\u0006Lx.\u001e;PaRLW.\u001b>bi&|g\u000e\u0005\u0002)!M)\u0001#!\u0019\u0002hA\u0019Q'a\u0019\n\u0007\u0005\u0015dG\u0001\u0004B]f\u0014VM\u001a\t\u0004k\u0005%\u0014bAA6m\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011Q\f\u000b\u0003\u0003c\u0002b!a\u001d\u0002~\u0005\u0005UBAA;\u0015\u0011\t9(!\u001f\u0002\rM$(/Z1n\u0015\r\tY\bV\u0001\u0005kRLG.\u0003\u0003\u0002\u0000\u0005U$AB*ue\u0016\fW\u000e\u0005\u0003\u0002\b\u0005\r\u0015\u0002BAC\u0003\u0013\u0011\u0011\"\u0011:hk6,g\u000e^:\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0017\u00032!UAG\u0013\r\tyI\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class TestLayoutOptimization
extends HoodieClientTestBase {
    private SparkSession spark;
    private final StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
    private final Map<String, String> metadataOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
    private final Map<String, String> commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}))).$plus$plus(this.metadataOpts());

    public static Stream<Arguments> testLayoutOptimizationParameters() {
        return TestLayoutOptimization$.MODULE$.testLayoutOptimizationParameters();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public StructType sourceTableSchema() {
        return this.sourceTableSchema;
    }

    public Map<String, String> metadataOpts() {
        return this.metadataOpts;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @ParameterizedTest
    @MethodSource(value={"testLayoutOptimizationParameters"})
    public void testLayoutOptimizationFunctional(String tableType, String clusteringAsRow, String layoutOptimizationStrategy, String spatialCurveCompositionStrategy) {
        String curveCompositionStrategy = (String)Option$.MODULE$.apply((Object)spatialCurveCompositionStrategy).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD.defaultValue());
        int targetRecordsCount = 10000;
        List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(targetRecordsCount)))).toList();
        Dataset writeDf = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        this.spark().sqlContext().setConf(HoodieFileIndex.DataSkippingFailureMode$.MODULE$.configName(), HoodieFileIndex.DataSkippingFailureMode$.MODULE$.Strict().value());
        writeDf.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option("hoodie.parquet.small.file.limit", "0").option("hoodie.clustering.inline", "true").option("hoodie.clustering.inline.max.commits", "1").option("hoodie.clustering.plan.strategy.target.file.max.bytes", "1073741824").option("hoodie.clustering.plan.strategy.small.file.limit", "629145600").option("hoodie.clustering.plan.strategy.max.bytes.per.group", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).option("hoodie.clustering.plan.strategy.target.file.max.bytes", String.valueOf(0x4000000L)).option(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), clusteringAsRow).option(HoodieClusteringConfig.LAYOUT_OPTIMIZE_STRATEGY.key(), layoutOptimizationStrategy).option(HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD.key(), curveCompositionStrategy).option(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), "begin_lat,begin_lon").mode(SaveMode.Overwrite).save(this.basePath);
        HoodieTableMetaClient hudiMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        HoodieInstant lastCommit = (HoodieInstant)hudiMetaClient.getActiveTimeline().getAllCommitsTimeline().lastInstant().get();
        Assertions.assertEquals((Object)"replacecommit", (Object)lastCommit.getAction());
        Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)lastCommit.getState());
        Dataset readDf = this.spark().read().format("hudi").load(this.basePath);
        Dataset readDfSkip = this.spark().read().option(DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key(), "true").options(this.metadataOpts()).format("hudi").load(this.basePath);
        Assertions.assertEquals((long)targetRecordsCount, (long)readDf.count());
        Assertions.assertEquals((long)targetRecordsCount, (long)readDfSkip.count());
        readDf.createOrReplaceTempView("hudi_snapshot_raw");
        readDfSkip.createOrReplaceTempView("hudi_snapshot_skipping");
        this.assertRowsMatch((Dataset<Row>)this.select$1("hudi_snapshot_raw"), (Dataset<Row>)this.select$1("hudi_snapshot_skipping"));
    }

    private void assertRowsMatch(Dataset<Row> one, Dataset<Row> other) {
        long rows = one.count();
        Predef$.MODULE$.assert(rows == other.count() && one.intersect(other).count() == rows);
    }

    private final Dataset select$1(String tableName) {
        return this.spark().sql(new StringBuilder(102).append("SELECT * FROM ").append(tableName).append(" WHERE begin_lat >= 0.49 AND begin_lat < 0.51 AND begin_lon >= 0.49 AND begin_lon < 0.51").toString());
    }
}

