/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.SparkDatasetMixin;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestMORDataSource$;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.util.JFunction$;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001\u0002\u0014(\u0001ABQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001A\u0002\u0013\u0005\u0001\tC\u0004I\u0001\u0001\u0007I\u0011A%\t\rI\u0003\u0001\u0015)\u0003B\u0011\u001d\u0019\u0006A1A\u0005\nQCaa\u0017\u0001!\u0002\u0013)\u0006b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007]\u0002\u0001\u000b\u0011\u00020\t\u000f=\u0004!\u0019!C\u0001a\"11\u0010\u0001Q\u0001\nEDq\u0001 \u0001C\u0002\u0013\u0005\u0001\u000f\u0003\u0004~\u0001\u0001\u0006I!\u001d\u0005\u0006}\u0002!\te \u0005\u0007\u0003/\u0001A\u0011I@\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!1\u0011\u0011\n\u0001\u0005\u0002}Da!a\u0015\u0001\t\u0003y\bBBA,\u0001\u0011\u0005q\u0010\u0003\u0004\u0002\\\u0001!\ta \u0005\u0007\u0003?\u0002A\u0011A@\t\r\u0005\r\u0004\u0001\"\u0001\u0000\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAy\u0001\u0011\u0005\u00111\u001f\u0005\u0007\u0005#\u0001A\u0011A@\t\r\tU\u0001\u0001\"\u0001\u0000\u0011\u0019\u0011I\u0002\u0001C\u0001\u007f\"1!Q\u0004\u0001\u0005\u0002}DaA!\t\u0001\t\u0003y\bB\u0002B\u0013\u0001\u0011\u0005q\u0010C\u0004\u0003*\u0001!\tAa\u000b\t\u000f\t\r\u0003\u0001\"\u0001\u0003F!9!q\n\u0001\u0005\u0002\tE\u0003\u0002\u0004B0\u0001A\u0005\t\u0011!A\u0005\u0002\t\u0005$!\u0005+fgRluJ\u0015#bi\u0006\u001cv.\u001e:dK*\u0011\u0001&K\u0001\u000bMVt7\r^5p]\u0006d'B\u0001\u0016,\u0003\u0011AW\u000fZ5\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0003i%\n\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005Y\u001a$\u0001\u0006%p_\u0012LWm\u00117jK:$H+Z:u\u0005\u0006\u001cX\r\u0005\u00029s5\t\u0011&\u0003\u0002;S\t\t2\u000b]1sW\u0012\u000bG/Y:fi6K\u00070\u001b8\u0002\rqJg.\u001b;?)\u0005i\u0004C\u0001 \u0001\u001b\u00059\u0013!B:qCJ\\W#A!\u0011\u0005\t3U\"A\"\u000b\u0005\u0011+\u0015aA:rY*\u0011qhK\u0005\u0003\u000f\u000e\u0013Ab\u00159be.\u001cVm]:j_:\f\u0011b\u001d9be.|F%Z9\u0015\u0005)\u0003\u0006CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%\u0001B+oSRDq!U\u0002\u0002\u0002\u0003\u0007\u0011)A\u0002yIE\naa\u001d9be.\u0004\u0013a\u00017pOV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002YW\u0005)An\\45U&\u0011!l\u0016\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u000bG>lWn\u001c8PaR\u001cX#\u00010\u0011\t}#gMZ\u0007\u0002A*\u0011\u0011MY\u0001\nS6lW\u000f^1cY\u0016T!a\u0019'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fA\n\u0019Q*\u00199\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n11\u000b\u001e:j]\u001e\f1bY8n[>tw\n\u001d;tA\u0005ya/\u001a:jM&\u001c\u0017\r^5p]\u000e{G.F\u0001r!\t\u0011\u0018P\u0004\u0002toB\u0011A\u000fT\u0007\u0002k*\u0011aoL\u0001\u0007yI|w\u000e\u001e \n\u0005ad\u0015A\u0002)sK\u0012,g-\u0003\u0002nu*\u0011\u0001\u0010T\u0001\u0011m\u0016\u0014\u0018NZ5dCRLwN\\\"pY\u0002\na#\u001e9eCR,GMV3sS\u001aL7-\u0019;j_:4\u0016\r\\\u0001\u0018kB$\u0017\r^3e-\u0016\u0014\u0018NZ5dCRLwN\u001c,bY\u0002\nQa]3u+B$\u0012A\u0013\u0015\u0004\u001b\u0005\r\u0001\u0003BA\u0003\u0003'i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0004CBL'\u0002BA\u0007\u0003\u001f\tqA[;qSR,'OC\u0002\u0002\u00125\nQA[;oSRLA!!\u0006\u0002\b\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3ADA\u000e!\u0011\t)!!\b\n\t\u0005}\u0011q\u0001\u0002\n\u0003\u001a$XM]#bG\"\f\u0011eZ3u'B\f'o[*fgNLwN\\#yi\u0016t7/[8og&s'.Z2u_J$\"!!\n\u0011\r\u0005\u001d\u0012\u0011GA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001B;uS2T1!a\f*\u0003\u0019\u0019w.\\7p]&!\u00111GA\u0015\u0005\u0019y\u0005\u000f^5p]B1\u0011qGA \u0003\u0007j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\tMVt7\r^5p]*\u0019\u00111\u00066\n\t\u0005\u0005\u0013\u0011\b\u0002\t\u0007>t7/^7feB\u0019!)!\u0012\n\u0007\u0005\u001d3I\u0001\fTa\u0006\u00148nU3tg&|g.\u0012=uK:\u001c\u0018n\u001c8t\u0003%!Xm\u001d;D_VtG\u000fK\u0002\u0011\u0003\u001b\u0002B!!\u0002\u0002P%!\u0011\u0011KA\u0004\u0005\u0011!Vm\u001d;\u0002#Q,7\u000f\u001e)bs2|\u0017\r\u001a#fY\u0016$X\rK\u0002\u0012\u0003\u001b\n!\u0003^3tiB\u0013XO\\3e\r&dG/\u001a:fI\"\u001a!#!\u0014\u0002)Q,7\u000f\u001e,fGR|'/\u001b>fIJ+\u0017\rZ3sQ\r\u0019\u0012QJ\u0001\u0011i\u0016\u001cHOT8Qe\u0016\u001cw.\u001c2j]\u0016D3\u0001FA'\u0003u!Xm\u001d;Qe\u0016\u001cu.\u001c2j]\u00164\u0015\u000e\\3e\r>\u0014(+Z1e\u001b>\u0013\u0006fA\u000b\u0002N\u0005IqO]5uK\u0012\u000bG/\u0019\u000b\u0004\u0015\u0006-\u0004bBA7-\u0001\u0007\u0011qN\u0001\u0005I\u0006$\u0018\r\u0005\u0007L\u0003c\n)(]A;\u0003k\nY(C\u0002\u0002t1\u0013a\u0001V;qY\u0016,\u0004cA&\u0002x%\u0019\u0011\u0011\u0010'\u0003\u0007%sG\u000fE\u0002L\u0003{J1!a M\u0005\u001d\u0011un\u001c7fC:\f1b\u00195fG.\fen]<feR\u0019!*!\"\t\u000f\u0005\u001du\u00031\u0001\u0002p\u00051Q\r\u001f9fGR\fAC^3sS\u001aL8k\u00195f[\u0006\fe\u000e\u001a+za\u0016\u001cHc\u0001&\u0002\u000e\"9\u0011q\u0012\rA\u0002\u0005E\u0015A\u00013g!\u0011\t\u0019*!+\u000f\t\u0005U\u0015Q\u0015\b\u0005\u0003/\u000b\u0019K\u0004\u0003\u0002\u001a\u0006\u0005f\u0002BAN\u0003?s1\u0001^AO\u0013\u0005q\u0013B\u0001\u0017.\u0013\ty4&\u0003\u0002E\u000b&\u0019\u0011qU\"\u0002\u000fA\f7m[1hK&!\u00111VAW\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002(\u000e\u000b!B^3sS\u001aL8\u000b[8x)\rQ\u00151\u0017\u0005\b\u0003\u001fK\u0002\u0019AAI\u0003\u0011\"Xm\u001d;Rk\u0016\u0014\u00180T(S/&$\bNQ1tKB\u000bG\u000f[!oI\u001aKG.Z%oI\u0016DH#\u0002&\u0002:\u0006u\u0006bBA^5\u0001\u0007\u00111P\u0001\u0010a\u0006\u0014H/\u001b;j_:,enY8eK\"9\u0011q\u0018\u000eA\u0002\u0005m\u0014!E5t\u001b\u0016$\u0018\rZ1uC\u0016s\u0017M\u00197fI\":!$a1\u0002T\u0006U\u0007\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\taJ|g/\u001b3fe*!\u0011QZA\u0006\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011[Ad\u0005%\u00195O^*pkJ\u001cW-A\u0003wC2,X\r\f\u0005\u0002X\u0006m\u0017q\\ArC\t\tI.\u0001\u0006ueV,GFZ1mg\u0016\f#!!8\u0002\u0013Q\u0014X/\u001a\u0017ueV,\u0017EAAq\u0003)1\u0017\r\\:fYQ\u0014X/Z\u0011\u0003\u0003K\f1BZ1mg\u0016dc-\u00197tK\"\u001a!$!;\u0011\t\u0005-\u0018Q^\u0007\u0003\u0003\u0017LA!a<\u0002L\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002+Q,7\u000f^'P%B\u000b'\u000f^5uS>t\u0007K];oKR)!*!>\u0002x\"9\u00111X\u000eA\u0002\u0005m\u0004bBA}7\u0001\u0007\u00111P\u0001\u0013Q&4Xm\u0015;zY\u0016\u0004\u0016M\u001d;ji&|g\u000eK\u0004\u001c\u0003\u0007\f\u0019.!@-\u0011\u0005}(1\u0001B\u0004\u0005\u0017\t#A!\u0001\u0002\u0017Q\u0014X/\u001a\u0017!M\u0006d7/Z\u0011\u0003\u0005\u000b\t1BZ1mg\u0016d\u0003\u0005\u001e:vK\u0006\u0012!\u0011B\u0001\rM\u0006d7/\u001a\u0017!M\u0006d7/Z\u0011\u0003\u0005\u001b\t!\u0002\u001e:vK2\u0002CO];fQ\rY\u0012\u0011^\u0001!i\u0016\u001cHOU3bIB\u000bG\u000f[:G_JlUM]4f\u001f:\u0014V-\u00193UC\ndW\rK\u0002\u001d\u0003\u001b\nA\u0004^3tiJ+\u0017\r\u001a)bi\"\u001chi\u001c:P]2LHj\\4GS2,7\u000fK\u0002\u001e\u0003\u001b\nq\u0004^3tiJ+\u0017\r\u001a'pO>sG._'fe\u001e,wJ\u001c*fC\u0012$\u0016M\u00197fQ\rq\u0012QJ\u0001 i\u0016\u001cH\u000fV3na\u001aKG.Z:DY\u0016\fgNR8s\u00072,8\u000f^3sS:<\u0007fA\u0010\u0002N\u0005qB/Z:u\u00072,8\u000f^3sS:<wJ\u001c(vY2\f'\r\\3D_2,XN\u001c\u0015\u0004A\u00055\u0013A\u0006;fgRDun\u001c3jK&\u001bH)\u001a7fi\u0016$Wj\u0014*)\u0007\u0005\ni%A\u0018uKN$\bK];oKB\u000b'\u000f^5uS>tgi\u001c:US6,7\u000f^1na\n\u000b7/\u001a3LKf<UM\\3sCR|'\u000fF\u0002K\u0005[AqAa\f#\u0001\u0004\tY(A\bf]\u0006\u0014G.\u001a$jY\u0016Le\u000eZ3yQ\u001d\u0011#1\u0007B\u001d\u0005w\u0001B!!2\u00036%!!qGAd\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdCA!\u0010\u0003@e\t\u0011!G\u0001\u0001Q\r\u0011\u0013\u0011^\u0001Ei\u0016\u001cHOU3bI>\u0003H/[7ju\u0016$\u0017+^3ss\u00063G/\u001a:J]\u001ad\u0017n\u001a5u\u0007>l\u0007/Y2uS>t\u0017I\u001c3D_6\u0004H.\u001a;fI\u0012+G\u000e^1D_6l\u0017\u000e\u001e\u000b\u0004\u0015\n\u001d\u0003b\u0002B\u0018G\u0001\u0007\u00111\u0010\u0015\bG\tM\"\u0011\bB&Y\u0011\u0011iDa\u0010)\u0007\r\nI/A\thKR\u0004\u0016\r\u001e5G_J\u0014v*U;fef$r!\u001dB*\u0005/\u0012Y\u0006\u0003\u0004\u0003V\u0011\u0002\r!]\u0001\tE\u0006\u001cX\rU1uQ\"9!\u0011\f\u0013A\u0002\u0005m\u0014aC;tK\u001ecwN\u00192j]\u001eDqA!\u0018%\u0001\u0004\t)(\u0001\nqCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b'fm\u0016d\u0017!\u00059s_R,7\r^3eI\u0011\fG/Y$f]R!!1\rB7!\u0011\u0011)G!\u001b\u000e\u0005\t\u001d$b\u0001\u001b\u0002.%!!1\u000eB4\u0005]Aun\u001c3jKR+7\u000f\u001e#bi\u0006<UM\\3sCR|'\u000fC\u0004RK\u0005\u0005\t\u0019A\u001f")
public class TestMORDataSource
extends HoodieClientTestBase
implements SparkDatasetMixin {
    private SparkSession spark;
    private final Logger log;
    private final scala.collection.immutable.Map<String, String> commonOpts;
    private final String verificationCol;
    private final String updatedVerificationVal;

    @Override
    public Dataset<Row> toDataset(SparkSession spark, java.util.List<HoodieRecord<?>> records) {
        return SparkDatasetMixin.toDataset$(this, spark, records);
    }

    public /* synthetic */ HoodieTestDataGenerator protected$dataGen(TestMORDataSource x$1) {
        return x$1.dataGen;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Logger log() {
        return this.log;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    public Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return HoodieConversionUtils$.MODULE$.toJavaOption((scala.Option)new Some((Object)JFunction$.MODULE$.toJava((Function1 & Serializable & scala.Serializable)receiver -> {
            TestMORDataSource.$anonfun$getSparkSessionExtensionsInjector$1(receiver);
            return BoxedUnit.UNIT;
        })));
    }

    @Test
    public void testCount() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.count());
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String commit2Time = ((Row)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertEquals((long)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)1L);
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(commit2Time)).$greater((Object)commit1Time));
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.join(hudiSnapshotDF1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        Dataset hudiIncDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit1Time).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiIncDF1.count());
        Assertions.assertEquals((long)1L, (long)hudiIncDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((Object)commit1Time, (Object)((Row)hudiIncDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString());
        hudiIncDF1.show(1);
        Dataset hudiIncDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit1Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiIncDF2.count());
        Assertions.assertEquals((long)1L, (long)hudiIncDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((Object)commit2Time, (Object)((Row)hudiIncDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString());
        hudiIncDF2.show(1);
        Dataset hudiIncDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiIncDF3.count());
        Assertions.assertEquals((long)1L, (long)hudiIncDF3.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((Object)commit2Time, (Object)((Row)hudiIncDF3.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString());
        Dataset emptyIncDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), "001").load(this.basePath);
        Assertions.assertEquals((long)0L, (long)emptyIncDF.count());
        Dataset hudiSnapshotSkipMergeDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotSkipMergeDF2.count());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotSkipMergeDF2.select("_hoodie_record_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotSkipMergeDF2.join(hudiSnapshotDF2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        Dataset hudiRODF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiRODF2.count());
        Buffer records3 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((long)hudiSnapshotDF3.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)2L);
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF3.filter(functions$.MODULE$.col("_hoodie_commit_time").$greater((Object)commit2Time)).count());
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF3.join(hudiSnapshotDF2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key", "_hoodie_commit_time"})), "inner").count());
        Dataset hudiIncDF4 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)50L, (long)hudiIncDF4.count());
        Dataset hudiIncDF4SkipMerge = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)200L, (long)hudiIncDF4SkipMerge.count());
        String[] partitionPaths = new String[]{"2020/01/10"};
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitionPaths);
        Buffer records4 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("004", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF4 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF4.count());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.join(hudiSnapshotDF4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "inner").count());
        Dataset hudiIncDF5 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)150L, (long)hudiIncDF5.count());
        Buffer records5 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateUniqueUpdates("005", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF5 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records5, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF5.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit5Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        Dataset hudiSnapshotDF5 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF5.count());
        Buffer records6 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("006", Predef$.MODULE$.int2Integer(2)))).asScala();
        Dataset inputDF6 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records6, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF6.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "true").mode(SaveMode.Append).save(this.basePath);
        String commit6Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        Dataset hudiSnapshotDF6 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(13).append(this.basePath).append("/2020/01/10/*").toString());
        Assertions.assertEquals((long)102L, (long)hudiSnapshotDF6.count());
        Dataset hudiIncDF6 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit5Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit6Time).load(this.basePath);
        Assertions.assertEquals((long)2L, (long)hudiIncDF6.count());
    }

    @Test
    public void testPayloadDelete() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueDeleteRecords("002", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF2.count());
        Assertions.assertEquals((long)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)1L);
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String commit2Time = ((Row)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertTrue((boolean)commit1Time.equals(commit2Time));
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF2.join(hudiSnapshotDF1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        Dataset hudiSnapshotDF2Unmerge = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2Unmerge.count());
        Dataset hudiIncDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)0L, (long)hudiIncDF1.count());
        Buffer records3 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueDeleteRecords("003", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)0L, (long)hudiSnapshotDF3.count());
    }

    @Test
    public void testPrunedFiltered() {
        scala.collection.immutable.Map opts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_path"));
        java.util.List hoodieRecords1 = this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100));
        Dataset<Row> inputDF1 = this.toDataset(this.spark(), hoodieRecords1);
        inputDF1.write().format("org.apache.hudi").options((Map)opts).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key(), DefaultHoodieRecordPayload.class.getName()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Assertions.assertEquals((Object)"amount,currency,tip_history,_hoodie_commit_seqno", (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hudiSnapshotDF1.select("fare.amount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.currency", "tip_history", "_hoodie_commit_seqno"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("_hoodie_commit_seqno")})).columns())).mkString(","));
        java.util.List records2 = this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(50));
        Dataset<Row> inputDF2 = this.toDataset(this.spark(), records2);
        inputDF2.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Dataset hudiIncDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").load(this.basePath);
        Dataset hudiIncDF1Skipmerge = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").load(this.basePath);
        Dataset hudiIncDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit1Time).load(this.basePath);
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF2.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).filter(functions$.MODULE$.col("_hoodie_commit_time").$greater((Object)commit1Time)).count());
        Assertions.assertEquals((long)50L, (long)hudiIncDF1.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).filter(functions$.MODULE$.col("_hoodie_commit_time").$greater((Object)commit1Time)).count());
        Assertions.assertEquals((long)50L, (long)hudiIncDF2.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).count());
        Assertions.assertEquals((long)150L, (long)hudiIncDF1Skipmerge.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).count());
        this.verifySchemaAndTypes((Dataset<Row>)hudiSnapshotDF1);
        this.verifySchemaAndTypes((Dataset<Row>)hudiSnapshotDF2);
        this.verifySchemaAndTypes((Dataset<Row>)hudiIncDF1);
        this.verifySchemaAndTypes((Dataset<Row>)hudiIncDF2);
        this.verifySchemaAndTypes((Dataset<Row>)hudiIncDF1Skipmerge);
        this.verifyShow((Dataset<Row>)hudiSnapshotDF1);
        this.verifyShow((Dataset<Row>)hudiSnapshotDF2);
        this.verifyShow((Dataset<Row>)hudiIncDF1);
        this.verifyShow((Dataset<Row>)hudiIncDF2);
        this.verifyShow((Dataset<Row>)hudiIncDF1Skipmerge);
        java.util.List record3 = this.dataGen.generateUpdatesWithTS("003", hoodieRecords1, -1);
        Dataset<Row> inputDF3 = this.toDataset(this.spark(), record3);
        inputDF3.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        this.verifyShow((Dataset<Row>)hudiSnapshotDF3);
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((long)0L, (long)hudiSnapshotDF3.filter("rider = 'rider-003'").count());
    }

    @Test
    public void testVectorizedReader() {
        this.spark().conf().set("spark.sql.parquet.enableVectorizedReader", true);
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(this.spark().conf().get("spark.sql.parquet.enableVectorizedReader"))).toBoolean());
        String schema = "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsAsPerSchema("001", Predef$.MODULE$.int2Integer(100), schema))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdatesAsPerSchema("002", Predef$.MODULE$.int2Integer(50), schema))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.count());
        Row sampleRow = (Row)hudiSnapshotDF2.select("fare", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "_hoodie_is_deleted"})).head();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)sampleRow.getDouble(0)), (Object)sampleRow.get(0));
        Assertions.assertEquals((Object)sampleRow.getString(1), (Object)sampleRow.get(1));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)sampleRow.getBoolean(2)), (Object)sampleRow.get(2));
        hudiSnapshotDF1.show(1);
        hudiSnapshotDF2.show(1);
    }

    @Test
    public void testNoPrecombine() {
        Buffer records = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        scala.collection.immutable.Map commonOptsNoPreCombine = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        inputDF.write().format("hudi").options((Map)commonOptsNoPreCombine).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), "MERGE_ON_READ").mode(SaveMode.Overwrite).save(this.basePath);
        this.spark().read().format("org.apache.hudi").load(this.basePath).count();
    }

    @Test
    public void testPreCombineFiledForReadMOR() {
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)99), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)14), (Object)BoxesRunTime.boxToInteger((int)98), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)16), (Object)BoxesRunTime.boxToInteger((int)97), (Object)BoxesRunTime.boxToBoolean((boolean)true)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)18), (Object)BoxesRunTime.boxToInteger((int)96), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    private void writeData(Tuple5<Object, String, Object, Object, Object> data) {
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestMORDataSource.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestMORDataSource$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Boolean").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_functional_TestMORDataSource$$typecreator5$1(TestMORDataSource $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{data})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestMORDataSource$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version", "_hoodie_is_deleted"}));
        df.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key(), DefaultHoodieRecordPayload.class.getCanonicalName()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "version").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), NonpartitionedKeyGenerator.class.getName()).mode(SaveMode.Append).save(this.basePath);
    }

    private void checkAnswer(Tuple5<Object, String, Object, Object, Object> expect) {
        Dataset readDf = this.spark().read().format("org.apache.hudi").load(new StringBuilder(2).append(this.basePath).append("/*").toString());
        if (BoxesRunTime.unboxToBoolean((Object)expect._5())) {
            if (!readDf.isEmpty()) {
                Predef$.MODULE$.println((Object)new StringBuilder(9).append("Found df ").append(((Row)readDf.collectAsList().get(0)).mkString(",")).toString());
            }
            Assertions.assertTrue((boolean)readDf.isEmpty());
        } else {
            Row row1 = ((Row[])readDf.select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "_hoodie_is_deleted"})).take(1))[0];
            Assertions.assertEquals((Object)Row$.MODULE$.apply(expect.productIterator().toSeq()), (Object)row1);
        }
    }

    public void verifySchemaAndTypes(Dataset<Row> df) {
        Assertions.assertEquals((Object)"amount,currency,tip_history,_hoodie_commit_seqno", (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select("fare.amount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.currency", "tip_history", "_hoodie_commit_seqno"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("_hoodie_commit_seqno")})).columns())).mkString(","));
        Row sampleRow = (Row)df.select("begin_lat", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_date", "fare.currency", "tip_history", "nation"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("_hoodie_commit_time")})).head();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)sampleRow.getDouble(0)), (Object)sampleRow.get(0));
        Assertions.assertEquals((Object)sampleRow.getDate(1), (Object)sampleRow.get(1));
        Assertions.assertEquals((Object)sampleRow.getString(2), (Object)sampleRow.get(2));
        Assertions.assertEquals((Object)sampleRow.getSeq(3), (Object)sampleRow.get(3));
        Assertions.assertEquals((Object)sampleRow.getAs(4), (Object)sampleRow.get(4));
    }

    public void verifyShow(Dataset<Row> df) {
        df.show(1);
        df.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).show(1);
    }

    @ParameterizedTest
    @CsvSource(value={"true,false", "true,true", "false,true", "false,false"})
    public void testQueryMORWithBasePathAndFileIndex(boolean partitionEncode, boolean isMetadataEnabled) {
        int N = 20;
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Overwrite).save(this.basePath);
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        int countIn20160315 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSource.$anonfun$testQueryMORWithBasePathAndFileIndex$1(record)));
        long count1 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath).filter("partition = '2016/03/15'").count();
        Assertions.assertEquals((long)countIn20160315, (long)count1);
        String partitionPath = partitionEncode ? "2016%2F03%2F15" : "2016/03/15";
        long count2 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(new StringBuilder(1).append(this.basePath).append("/").append(partitionPath).toString()).count();
        Assertions.assertEquals((long)countIn20160315, (long)count2);
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N + 1));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records2)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Append).save(this.basePath);
        Dataset hoodieIncViewDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime1).load(this.basePath);
        Assertions.assertEquals((long)(N + 1), (long)hoodieIncViewDF1.count());
    }

    @ParameterizedTest
    @CsvSource(value={"true, false", "false, true", "false, false", "true, true"})
    public void testMORPartitionPrune(boolean partitionEncode, boolean hiveStylePartition) {
        String[] partitions = (String[])((Object[])new String[]{"2021/03/01", "2021/03/02", "2021/03/03", "2021/03/04", "2021/03/05"});
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitions);
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(newDataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(records1).asJava()))).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        scala.collection.immutable.Map partitionCounts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToInteger((int)records1.count((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSource.$anonfun$testMORPartitionPrune$2(p, r))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStylePartition).mode(SaveMode.Overwrite).save(this.basePath);
        long count1 = this.spark().read().format("hudi").load(this.basePath).filter("partition = '2021/03/01'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/01")), (long)count1);
        long count2 = this.spark().read().format("hudi").load(this.basePath).filter("partition > '2021/03/01' and partition < '2021/03/03'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/02")), (long)count2);
        long count3 = this.spark().read().format("hudi").load(this.basePath).filter("partition != '2021/03/01'").count();
        Assertions.assertEquals((long)(records1.size() - BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/01"))), (long)count3);
        long count4 = this.spark().read().format("hudi").load(this.basePath).filter("partition like '2021/03/03%'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/03")), (long)count4);
        long count5 = this.spark().read().format("hudi").load(this.basePath).filter("partition like '%2021/03/%'").count();
        Assertions.assertEquals((long)records1.size(), (long)count5);
        long count6 = this.spark().read().format("hudi").load(this.basePath).filter("partition = '2021/03/01' or partition = '2021/03/05'").count();
        Assertions.assertEquals((long)(BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/01")) + BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/05"))), (long)count6);
        long count7 = this.spark().read().format("hudi").load(this.basePath).filter("substr(partition, 9, 10) = '03'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/03")), (long)count7);
    }

    @Test
    public void testReadPathsForMergeOnReadTable() {
        java.util.List records1 = this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        String baseFilePath = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths())).head())))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSource.$anonfun$testReadPathsForMergeOnReadTable$1(x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        java.util.List records2 = this.dataGen.generateUniqueDeleteRecords("002", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records2)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiReadPathDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), baseFilePath).load();
        int expectedCount1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSource.$anonfun$testReadPathsForMergeOnReadTable$3(this, record)));
        Assertions.assertEquals((long)expectedCount1, (long)hudiReadPathDF1.count());
        String logFilePath = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths())).head())))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSource.$anonfun$testReadPathsForMergeOnReadTable$4(x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        String readPaths = new StringBuilder(1).append(baseFilePath).append(",").append(logFilePath).toString();
        Dataset hudiReadPathDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), readPaths).load();
        Assertions.assertEquals((long)0L, (long)hudiReadPathDF2.count());
    }

    @Test
    public void testReadPathsForOnlyLogFiles() {
        this.initMetaClient(HoodieTableType.MERGE_ON_READ);
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieIndexConfig.INDEX_TYPE.key(), HoodieIndex.IndexType.INMEMORY.toString()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)DataSourceTestUtils.isLogFileOnly(this.basePath));
        String logFilePath = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths())).head())))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSource.$anonfun$testReadPathsForOnlyLogFiles$1(x$5))))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records2)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieIndexConfig.INDEX_TYPE.key(), HoodieIndex.IndexType.INMEMORY.toString()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)DataSourceTestUtils.isLogFileOnly(this.basePath));
        int expectedCount1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSource.$anonfun$testReadPathsForOnlyLogFiles$3(this, record)));
        Dataset hudiReadPathDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), logFilePath).load();
        Assertions.assertEquals((long)expectedCount1, (long)hudiReadPathDF.count());
    }

    @Test
    public void testReadLogOnlyMergeOnReadTable() {
        this.initMetaClient(HoodieTableType.MERGE_ON_READ);
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieIndexConfig.INDEX_TYPE.key(), HoodieIndex.IndexType.INMEMORY.toString()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)DataSourceTestUtils.isLogFileOnly(this.basePath));
        Assertions.assertEquals((long)20L, (long)this.spark().read().format("hudi").load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString()).count());
        Assertions.assertEquals((long)20L, (long)this.spark().read().format("hudi").load(this.basePath).count());
    }

    @Test
    public void testTempFilesCleanForClustering() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(1000)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option("hoodie.clustering.inline", "true").option("hoodie.clustering.plan.strategy.sort.columns", "begin_lat, begin_lon").mode(SaveMode.Overwrite).save(this.basePath);
        Path tempPath = new Path(this.basePath, ".hoodie/.temp");
        FileSystem fs = tempPath.getFileSystem(this.spark().sparkContext().hadoopConfiguration());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(tempPath))).isEmpty()));
    }

    @Test
    public void testClusteringOnNullableColumn() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(1000)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class))).withColumn("cluster_id", functions$.MODULE$.when(functions$.MODULE$.expr("end_lon < 0.2 "), (Object)functions$.MODULE$.lit(null).cast("string")).otherwise((Object)functions$.MODULE$.col("_row_key"))).withColumn("struct_cluster_col", functions$.MODULE$.when(functions$.MODULE$.expr("end_lon < 0.1"), (Object)functions$.MODULE$.lit(null)).otherwise((Object)functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("cluster_id"), functions$.MODULE$.col("_row_key")}))));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option("hoodie.clustering.inline", "true").option("hoodie.clustering.inline.max.commits", "1").option("hoodie.clustering.plan.strategy.target.file.max.bytes", "1073741824").option("hoodie.clustering.plan.strategy.small.file.limit", "629145600").option("hoodie.clustering.plan.strategy.sort.columns", "struct_cluster_col").mode(SaveMode.Overwrite).save(this.basePath);
    }

    @Test
    public void testHoodieIsDeletedMOR() {
        int numRecords = 100;
        int numRecordsToDelete = 2;
        String schema = "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
        Buffer records0 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsAsPerSchema("000", Predef$.MODULE$.int2Integer(numRecords), schema))).asScala();
        Dataset inputDF0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF0.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshotDF0 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)numRecords, (long)snapshotDF0.count());
        Dataset df1 = snapshotDF0.limit(numRecordsToDelete);
        Dataset dropDf = df1.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df1.columns())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith("_hoodie_")))));
        Dataset df2 = dropDf.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).cast((DataType)BooleanType$.MODULE$));
        df2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)(numRecords - numRecordsToDelete), (long)snapshotDF2.count());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPrunePartitionForTimestampBasedKeyGenerator(boolean enableFileIndex) {
        scala.collection.immutable.Map options = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.TimestampBasedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type"), (Object)"DATE_STRING"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat"), (Object)"yyyy/MM/dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timezone"), (Object)"GMT+8:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat"), (Object)"yyyy-MM-dd")})));
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_HOODIE_FILE_INDEX().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableFileIndex)).toString())}));
        HoodieTestDataGenerator dataGen1 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-01"}));
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateInserts("001", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.spark().sessionState().newHadoopConf()).build();
        String commit1Time = ((HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get()).getTimestamp();
        HoodieTestDataGenerator dataGen2 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-02"}));
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateInserts("002", Predef$.MODULE$.int2Integer(60)))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath);
        String commit2Time = ((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).getTimestamp();
        Buffer records3 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(20)))).asScala();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath);
        String commit3Time = ((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).getTimestamp();
        String pathForROQuery = this.getPathForROQuery(this.basePath, !enableFileIndex, 3);
        Dataset snapshotQueryRes = this.spark().read().format("hudi").options((Map)readOpts).load(this.basePath);
        Assertions.assertEquals((long)snapshotQueryRes.where(new StringBuilder(24).append("_hoodie_commit_time = '").append(commit1Time).append("'").toString()).count(), (long)50L);
        Assertions.assertEquals((long)snapshotQueryRes.where(new StringBuilder(24).append("_hoodie_commit_time = '").append(commit2Time).append("'").toString()).count(), (long)40L);
        Assertions.assertEquals((long)snapshotQueryRes.where(new StringBuilder(24).append("_hoodie_commit_time = '").append(commit3Time).append("'").toString()).count(), (long)20L);
        Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022-01-01'").count(), (long)50L);
        Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022-01-02'").count(), (long)60L);
        Dataset readOptimizedQueryRes = this.spark().read().format("hudi").options((Map)readOpts).option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(pathForROQuery);
        if (enableFileIndex) {
            Assertions.assertEquals((long)readOptimizedQueryRes.where("partition = '2022/01/01'").count(), (long)50L);
            Assertions.assertEquals((long)readOptimizedQueryRes.where("partition = '2022/01/02'").count(), (long)60L);
        } else {
            Assertions.assertEquals((long)readOptimizedQueryRes.where("partition = '2022-01-01'").count(), (long)50L);
            Assertions.assertEquals((long)readOptimizedQueryRes.where("partition = '2022-01-02'").count(), (long)60L);
        }
        Dataset incrementalQueryRes = this.spark().read().format("hudi").options((Map)readOpts).option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit3Time).load(this.basePath);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-01'").count(), (long)0L);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-02'").count(), (long)20L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReadOptimizedQueryAfterInflightCompactionAndCompletedDeltaCommit(boolean enableFileIndex) {
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_mor_ro_read_test_table", (Object)new StringBuilder(15).append(this.basePath).append("_mor_test_table").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName = (String)tuple2._1();
        String tablePath = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName, (Object)tablePath);
        Tuple2 tuple23 = tuple22;
        String tableName2 = (String)tuple23._1();
        String tablePath2 = (String)tuple23._2();
        String precombineField = "col3";
        String recordKeyField = "key";
        String dataField = "age";
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)precombineField), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)recordKeyField), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1")}));
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_HOODIE_FILE_INDEX().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableFileIndex)).toString())}));
        String pathForROQuery = this.getPathForROQuery(tablePath2, !enableFileIndex, 0);
        Dataset firstDf = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{recordKeyField})).withColumn(precombineField, functions$.MODULE$.expr(recordKeyField)).withColumn(dataField, functions$.MODULE$.expr(new StringBuilder(7).append(recordKeyField).append(" + 1000").toString()));
        firstDf.write().format("hudi").options((Map)options).mode(SaveMode.Overwrite).save(tablePath2);
        Dataset secondDf = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{recordKeyField})).withColumn(precombineField, functions$.MODULE$.expr(recordKeyField)).withColumn(dataField, functions$.MODULE$.expr(new StringBuilder(7).append(recordKeyField).append(" + 2000").toString()));
        secondDf.write().format("hudi").options((Map)options).mode(SaveMode.Append).save(tablePath2);
        scala.collection.immutable.Map compactionOptions = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY.key()), (Object)CompactionTriggerStrategy.NUM_COMMITS.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)OverwriteWithLatestAvroPayload.class.getName())})));
        SparkRDDWriteClient client = DataSourceUtils.createHoodieClient((JavaSparkContext)JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext()), (String)"", (String)tablePath2, (String)tableName2, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)compactionOptions));
        String compactionInstant = (String)client.scheduleCompaction(Option.empty()).get();
        client.compact(compactionInstant);
        client.close();
        Dataset thirdDf = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{recordKeyField})).withColumn(precombineField, functions$.MODULE$.expr(recordKeyField)).withColumn(dataField, functions$.MODULE$.expr(new StringBuilder(7).append(recordKeyField).append(" + 3000").toString()));
        thirdDf.write().format("hudi").options((Map)options).mode(SaveMode.Append).save(tablePath2);
        Dataset roDf = this.spark().read().format("org.apache.hudi").options((Map)readOpts).option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(pathForROQuery);
        Assertions.assertEquals((long)10L, (long)roDf.count());
        Assertions.assertEquals((long)1000L, (long)((Row[])roDf.where(functions$.MODULE$.col(recordKeyField).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0))).select(dataField, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())[0].getLong(0));
    }

    public String getPathForROQuery(String basePath, boolean useGlobbing, int partitionPathLevel) {
        return useGlobbing ? new StringBuilder(0).append(basePath).append(new StringOps(Predef$.MODULE$.augmentString("/*")).$times(partitionPathLevel + 1)).toString() : basePath;
    }

    public static final /* synthetic */ void $anonfun$getSparkSessionExtensionsInjector$1(SparkSessionExtensions receiver) {
        new HoodieSparkSessionExtension().apply(receiver);
    }

    public static final /* synthetic */ boolean $anonfun$testQueryMORWithBasePathAndFileIndex$1(HoodieRecord record) {
        String string = record.getPartitionPath();
        String string2 = "2016/03/15";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testMORPartitionPrune$2(String p$1, HoodieRecord r) {
        String string = r.getPartitionPath();
        String string2 = p$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsForMergeOnReadTable$1(FileStatus x$1) {
        return x$1.getPath().getName().endsWith("parquet");
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsForMergeOnReadTable$3(TestMORDataSource $this, HoodieRecord record) {
        String string = record.getPartitionPath();
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.protected$dataGen($this).getPartitionPaths())).head();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsForMergeOnReadTable$4(FileStatus x$3) {
        return x$3.getPath().getName().contains("log");
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsForOnlyLogFiles$1(FileStatus x$5) {
        return x$5.getPath().getName().contains("log");
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsForOnlyLogFiles$3(TestMORDataSource $this, HoodieRecord record) {
        String string = record.getPartitionPath();
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.protected$dataGen($this).getPartitionPaths())).head();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public TestMORDataSource() {
        SparkDatasetMixin.$init$(this);
        this.spark = null;
        this.log = LogManager.getLogger(TestMORDataSource.class);
        this.commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

