/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\u0007\u000e\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004*\u0001\u0001\u0006Ia\t\u0005\bU\u0001\u0011\r\u0011\"\u0001,\u0011\u0019q\u0004\u0001)A\u0005Y!9q\b\u0001b\u0001\n\u0003\u0001\u0005BB&\u0001A\u0003%\u0011\tC\u0004M\u0001\t\u0007I\u0011\u0001!\t\r5\u0003\u0001\u0015!\u0003B\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u00151\u0006\u0001\"\u0001X\u0005a!Vm\u001d;N\u001fJ#\u0015\r^1T_V\u00148-Z*u_J\fw-\u001a\u0006\u0003\u001d=\t!BZ;oGRLwN\\1m\u0015\t\u0001\u0012#\u0001\u0003ik\u0012L'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\u0011!dD\u0001\ni\u0016\u001cH/\u001e;jYNL!\u0001H\r\u0003AM\u0003\u0018M]6DY&,g\u000e\u001e$v]\u000e$\u0018n\u001c8bYR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u00035\t1\u0001\\8h+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0012\u0003\u0015awn\u001a\u001bk\u0013\tASE\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\u0006d_6lwN\\(qiN,\u0012\u0001\f\t\u0005[Q2d'D\u0001/\u0015\ty\u0003'A\u0005j[6,H/\u00192mK*\u0011\u0011GM\u0001\u000bG>dG.Z2uS>t'\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ur#aA'baB\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0005Y\u0006twMC\u0001<\u0003\u0011Q\u0017M^1\n\u0005uB$AB*ue&tw-A\u0006d_6lwN\\(qiN\u0004\u0013a\u0004<fe&4\u0017nY1uS>t7i\u001c7\u0016\u0003\u0005\u0003\"AQ%\u000f\u0005\r;\u0005C\u0001#3\u001b\u0005)%B\u0001$\u0016\u0003\u0019a$o\\8u}%\u0011\u0001JM\u0001\u0007!J,G-\u001a4\n\u0005uR%B\u0001%3\u0003A1XM]5gS\u000e\fG/[8o\u0007>d\u0007%\u0001\fva\u0012\fG/\u001a3WKJLg-[2bi&|gNV1m\u0003])\b\u000fZ1uK\u00124VM]5gS\u000e\fG/[8o-\u0006d\u0007%\u0001\u0003d_:4G#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005M\u000b\u0012!B:qCJ\\\u0017BA+S\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\fuKN$X*\u001a:hK>s'+Z1e'R|'/Y4f)\rAF,\u0019\t\u00033jk\u0011AM\u0005\u00037J\u0012A!\u00168ji\")Ql\u0003a\u0001=\u0006\t\u0012n]'fi\u0006$\u0017\r^1F]\u0006\u0014G.\u001a3\u0011\u0005e{\u0016B\u000113\u0005\u001d\u0011un\u001c7fC:DQAY\u0006A\u0002\u0005\u000ba\u0002\u001d:f\u0007>l\u0017N\\3GS\u0016dG\r\u000b\u0003\fIB\f\bCA3o\u001b\u00051'BA4i\u0003!\u0001(o\u001c<jI\u0016\u0014(BA5k\u0003\u0019\u0001\u0018M]1ng*\u00111\u000e\\\u0001\bUV\u0004\u0018\u000e^3s\u0015\ti7#A\u0003kk:LG/\u0003\u0002pM\nI1i\u001d<T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0005eR4\b0I\u0001t\u0003\u0015!(/^3-C\u0005)\u0018A\u0005;sk\u0016dc-\u0019:f]\r,(O]3oGf\f\u0013a^\u0001\u0007M\u0006d7/\u001a\u0017\"\u0003e\f1CZ1mg\u0016dc-\u0019:f]\r,(O]3oGfD#aC>\u0011\u0005qlX\"\u00015\n\u0005yD'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"2\u0001!!\u0001q\u0003\u001b\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fQ\u0017aA1qS&!\u00111BA\u0003\u0005\r!\u0016mZ\u0011\u0002\u001d\u0001")
public class TestMORDataSourceStorage
extends SparkClientFunctionalTestHarness {
    private final Logger log = LogManager.getLogger(TestMORDataSourceStorage.class);
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
    private final String verificationCol;
    private final String updatedVerificationVal;

    private Logger log() {
        return this.log;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    @ParameterizedTest
    @CsvSource(value={"true,", "true,fare.currency", "false,", "false,fare.currency"})
    public void testMergeOnReadStorage(boolean isMetadataEnabled, String preComineField) {
        scala.collection.immutable.Map options = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)String.valueOf(isMetadataEnabled)));
        if (!StringUtils.isNullOrEmpty((String)preComineField)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)preComineField));
        }
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);
        FileSystem fs = FSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)options).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset hudiRODF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hudiRODF1.count());
        String insertCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        List insertCommitTimes = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(hudiRODF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collectAsList()).map((Function1 & Serializable & scala.Serializable)r -> r.getString(0), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)new .colon.colon((Object)insertCommitTime, (List)Nil$.MODULE$), (Object)insertCommitTimes);
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String updateCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        List updateCommitTimes = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collectAsList()).map((Function1 & Serializable & scala.Serializable)r -> r.getString(0), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)new .colon.colon((Object)updateCommitTime, (List)Nil$.MODULE$), (Object)updateCommitTimes);
        String verificationRowKey = ((Row)hudiSnapshotDF2.limit(1).select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0);
        Dataset inputDF3 = hudiSnapshotDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        inputDF3.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        Dataset hudiSnapshotDF3 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((Object)this.updatedVerificationVal(), (Object)((Row)hudiSnapshotDF3.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
    }

    public TestMORDataSourceStorage() {
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

