/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\u0006\f\u0001QAQa\u0007\u0001\u0005\u0002qAqA\u0004\u0001C\u0002\u0013\u0005q\u0004\u0003\u0004)\u0001\u0001\u0006I\u0001\t\u0005\bS\u0001\u0001\r\u0011\"\u0001+\u0011\u001d)\u0004\u00011A\u0005\u0002YBa!\u0010\u0001!B\u0013Y\u0003\"\u0002 \u0001\t\u0003z\u0004\"\u0002$\u0001\t\u00039\u0005\"B2\u0001\t\u0013!'\u0001\n+fgRlU\r^1eCR\fG+\u00192mK^KG\u000f[*qCJ\\G)\u0019;b'>,(oY3\u000b\u00051i\u0011A\u00034v]\u000e$\u0018n\u001c8bY*\u0011abD\u0001\u0005QV$\u0017N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q!\u0001G\u0007\u0002\u0013Q,7\u000f^;uS2\u001c\u0018B\u0001\u000e\u0018\u0005\u0001\u001a\u0006/\u0019:l\u00072LWM\u001c;Gk:\u001cG/[8oC2$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005YQ#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t11\u000b\u001e:j]\u001e\fQ\u0001[;eS\u0002\n!bY8n[>tw\n\u001d;t+\u0005Y\u0003\u0003\u0002\u00174A\u0001j\u0011!\f\u0006\u0003]=\n\u0011\"[7nkR\f'\r\\3\u000b\u0005A\n\u0014AC2pY2,7\r^5p]*\t!'A\u0003tG\u0006d\u0017-\u0003\u00025[\t\u0019Q*\u00199\u0002\u001d\r|W.\\8o\u001fB$8o\u0018\u0013fcR\u0011qg\u000f\t\u0003qej\u0011!M\u0005\u0003uE\u0012A!\u00168ji\"9A(BA\u0001\u0002\u0004Y\u0013a\u0001=%c\u0005Y1m\\7n_:|\u0005\u000f^:!\u0003\u0011\u0019wN\u001c4\u0015\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!aQ\b\u0002\u000bM\u0004\u0018M]6\n\u0005\u0015\u0013%!C*qCJ\\7i\u001c8g\u0003=!Xm\u001d;SK\u0006$\u0017MY5mSRLHCA\u001cI\u0011\u0015I\u0005\u00021\u0001K\u0003Y\u0019w.\u001c9bGRtU/\u001c#fYR\f7i\\7nSR\u001c\bC\u0001\u001dL\u0013\ta\u0015GA\u0002J]RDC\u0001\u0003([7B\u0011q\nW\u0007\u0002!*\u0011\u0011KU\u0001\taJ|g/\u001b3fe*\u00111\u000bV\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005U3\u0016a\u00026va&$XM\u001d\u0006\u0003/F\tQA[;oSRL!!\u0017)\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\u0005S:$8\u000f\f\u0002];v\t\u0011!H\u0001\u0006Q\tAq\f\u0005\u0002aC6\t!+\u0003\u0002c%\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\u0019A\f'o]3SK\u000e|'\u000fZ:\u0015\u0005\u0015|\u0007C\u00014m\u001d\t9'.D\u0001i\u0015\tI')A\u0002tc2L!a\u001b5\u0002\u000fA\f7m[1hK&\u0011QN\u001c\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!a\u001b5\t\u000bAL\u0001\u0019A9\u0002\u000fI,7m\u001c:egB\u0019!/\u001f?\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<\u0014\u0003\u0019a$o\\8u}%\t!'\u0003\u0002lc%\u0011!p\u001f\u0002\u0004'\u0016\f(BA62!\ri\u00181\u0001\b\u0003}~\u0004\"\u0001^\u0019\n\u0007\u0005\u0005\u0011'\u0001\u0004Qe\u0016$WMZ\u0005\u0004O\u0005\u0015!bAA\u0001c!:\u0001!!\u0003\u0002\u0016\u0005]\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=A+A\u0002ba&LA!a\u0005\u0002\u000e\t\u0019A+Y4\u0002\u000bY\fG.^3\"\u00031\u0001")
public class TestMetadataTableWithSparkDataSource
extends SparkClientFunctionalTestHarness {
    private final String hudi;
    private scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));

    public String hudi() {
        return this.hudi;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public void commonOpts_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.commonOpts = x$1;
    }

    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    @ParameterizedTest
    @ValueSource(ints={1, 5})
    public void testReadability(int compactNumDeltaCommits) {
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
        scala.collection.immutable.Map combinedOpts = this.commonOpts().$plus$plus((GenTraversableOnce)metadataOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)((Object)BoxesRunTime.boxToInteger((int)compactNumDeltaCommits)).toString())})));
        List newRecords = dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100));
        Dataset<Row> newRecordsDF = this.parseRecords((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((List)newRecords)).asScala()));
        newRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        List updatedRecords = dataGen.generateUpdates("002", newRecords);
        Dataset<Row> updatedRecordsDF = this.parseRecords((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((List)updatedRecords)).asScala()));
        updatedRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        Dataset filesPartitionDF = this.spark().read().format(this.hudi()).load(new StringBuilder(23).append(this.basePath()).append("/.hoodie/metadata/files").toString());
        filesPartitionDF.show();
        Assertions.assertEquals((long)4L, (long)filesPartitionDF.count());
        Seq expectedKeys = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2015/03/16", "2015/03/17", "2016/03/15", "__all_partitions__"}));
        Seq keys = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesPartitionDF.select("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertEquals((Object)expectedKeys, (Object)keys);
        Dataset colStatsDF = this.spark().read().format(this.hudi()).load(new StringBuilder(30).append(this.basePath()).append("/.hoodie/metadata/column_stats").toString());
        colStatsDF.show();
    }

    private Dataset<Row> parseRecords(Seq<String> records) {
        return this.spark().read().json(this.spark().sparkContext().parallelize(records, 2, ClassTag$.MODULE$.apply(String.class)));
    }

    public TestMetadataTableWithSparkDataSource() {
        this.hudi = "org.apache.hudi";
    }
}

