/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGlobalDeleteRecordGenerator
extends KeyGeneratorTestUtilities {
    private TypedProperties getCommonProps(boolean getComplexRecordKey) {
        TypedProperties properties = new TypedProperties();
        if (getComplexRecordKey) {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key,pii_col");
        } else {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        }
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        return properties;
    }

    private TypedProperties getPropertiesWithoutRecordKeyProp() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }

    private TypedProperties getWrongRecordKeyFieldProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_wrong_key");
        return properties;
    }

    private TypedProperties getProps() {
        TypedProperties properties = this.getCommonProps(true);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp,ts_ms");
        return properties;
    }

    @Test
    public void testNullRecordKeyFields() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GlobalDeleteKeyGenerator(this.getPropertiesWithoutRecordKeyProp()));
    }

    @Test
    public void testWrongRecordKeyField() {
        GlobalDeleteKeyGenerator keyGenerator = new GlobalDeleteKeyGenerator(this.getWrongRecordKeyFieldProps());
        Assertions.assertThrows(HoodieKeyException.class, () -> keyGenerator.getRecordKey(TestGlobalDeleteRecordGenerator.getRecord()));
    }

    @Test
    public void testHappyFlow() {
        GlobalDeleteKeyGenerator keyGenerator = new GlobalDeleteKeyGenerator(this.getProps());
        GenericRecord record = TestGlobalDeleteRecordGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)key.getRecordKey(), (Object)"_row_key:key1,pii_col:pi");
        Assertions.assertEquals((Object)key.getPartitionPath(), (Object)"");
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)keyGenerator.getRecordKey(row), (Object)"_row_key:key1,pii_col:pi");
        Assertions.assertEquals((Object)keyGenerator.getPartitionPath(row), (Object)"");
    }
}

