/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import junit.framework.TestCase;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNonpartitionedKeyGenerator
extends KeyGeneratorTestUtilities {
    private TypedProperties getCommonProps(boolean getComplexRecordKey) {
        TypedProperties properties = new TypedProperties();
        if (getComplexRecordKey) {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key, pii_col");
        } else {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        }
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        return properties;
    }

    private TypedProperties getPropertiesWithoutPartitionPathProp() {
        return this.getCommonProps(false);
    }

    private TypedProperties getPropertiesWithPartitionPathProp() {
        TypedProperties properties = this.getCommonProps(true);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp,ts_ms");
        return properties;
    }

    private TypedProperties getPropertiesWithoutRecordKeyProp() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }

    private TypedProperties getWrongRecordKeyFieldProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_wrong_key");
        return properties;
    }

    @Test
    public void testNullRecordKeyFields() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new NonpartitionedKeyGenerator(this.getPropertiesWithoutRecordKeyProp()));
    }

    @Test
    public void testNonNullPartitionPathFields() {
        TypedProperties properties = this.getPropertiesWithPartitionPathProp();
        NonpartitionedKeyGenerator keyGenerator = new NonpartitionedKeyGenerator(properties);
        GenericRecord record = TestNonpartitionedKeyGenerator.getRecord();
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)properties.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()), (Object)"timestamp,ts_ms");
        Assertions.assertEquals((Object)keyGenerator.getPartitionPath(row), (Object)"");
    }

    @Test
    public void testNullPartitionPathFields() {
        TypedProperties properties = this.getPropertiesWithoutPartitionPathProp();
        NonpartitionedKeyGenerator keyGenerator = new NonpartitionedKeyGenerator(properties);
        GenericRecord record = TestNonpartitionedKeyGenerator.getRecord();
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)keyGenerator.getPartitionPath(row), (Object)"");
    }

    @Test
    public void testWrongRecordKeyField() {
        NonpartitionedKeyGenerator keyGenerator = new NonpartitionedKeyGenerator(this.getWrongRecordKeyFieldProps());
        Assertions.assertThrows(HoodieKeyException.class, () -> keyGenerator.getRecordKey(TestNonpartitionedKeyGenerator.getRecord()));
    }

    @Test
    public void testSingleValueKeyGeneratorNonPartitioned() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "timestamp");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "");
        NonpartitionedKeyGenerator keyGenerator = new NonpartitionedKeyGenerator(properties);
        TestCase.assertEquals((int)keyGenerator.getRecordKeyFieldNames().size(), (int)1);
        TestCase.assertEquals((int)keyGenerator.getPartitionPathFields().size(), (int)0);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = record.get("timestamp").toString();
        HoodieKey hoodieKey = keyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)"", (String)hoodieKey.getPartitionPath());
    }

    @Test
    public void testMultipleValueKeyGeneratorNonPartitioned1() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "timestamp,driver");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "");
        NonpartitionedKeyGenerator keyGenerator = new NonpartitionedKeyGenerator(properties);
        TestCase.assertEquals((int)keyGenerator.getRecordKeyFieldNames().size(), (int)2);
        TestCase.assertEquals((int)keyGenerator.getPartitionPathFields().size(), (int)0);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = "timestamp:" + record.get("timestamp").toString() + ",driver" + ":" + record.get("driver").toString();
        String partitionPath = "";
        HoodieKey hoodieKey = keyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)partitionPath, (String)hoodieKey.getPartitionPath());
    }
}

