/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.File;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.util.PathUtils$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a2Aa\u0001\u0003\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013\tiA+Z:u!\u0006$\b.\u0016;jYNT!!\u0002\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\tA!A\u0007uKN$x\t\\8c!\u0006$\bn\u001d\u000b\u00035u\u0001\"aD\u000e\n\u0005q\u0001\"\u0001B+oSRDQA\b\u0002A\u0002}\tq\u0001^3na\u0012K'\u000f\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005\u0011\u0011n\u001c\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0003GS2,\u0007FA\u000f)!\tI\u0013'D\u0001+\u0015\t\u00113F\u0003\u0002-[\u0005\u0019\u0011\r]5\u000b\u00059z\u0013a\u00026va&$XM\u001d\u0006\u0003a)\tQA[;oSRL!A\r\u0016\u0003\u000fQ+W\u000e\u001d#je\"\u0012!\u0001\u000e\t\u0003kYj\u0011aK\u0005\u0003o-\u0012A\u0001V3ti\u0002")
public class TestPathUtils {
    @Test
    public void testGlobPaths(@TempDir File tempDir) {
        Seq folders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(Paths.get(tempDir.getAbsolutePath(), "folder1").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie", "metadata").toUri())}));
        Seq files = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(Paths.get(tempDir.getAbsolutePath(), "folder1", "file1").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder1", "file2").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2", "file3").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2", "file4").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie", "metadata", "file5").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie", "metadata", "file6").toUri())}));
        folders.foreach((Function1 & java.io.Serializable & Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$1(folder)));
        files.foreach((Function1 & java.io.Serializable & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$2(file)));
        Seq paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(2).append(tempDir.getAbsolutePath()).append("/*").toString()}));
        Seq globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)folders.filterNot((Function1 & java.io.Serializable & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$3(entry)))).sortWith((Function2 & java.io.Serializable & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$4(x$1, x$2))), (Object)globbedPaths.sortWith((Function2 & java.io.Serializable & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$5(x$3, x$4))));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(tempDir.getAbsolutePath()).append("/*/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)files.filterNot((Function1 & java.io.Serializable & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$6(entry)))).sortWith((Function2 & java.io.Serializable & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$7(x$5, x$6))), (Object)globbedPaths.sortWith((Function2 & java.io.Serializable & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$8(x$7, x$8))));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(tempDir.getAbsolutePath()).append("/folder1/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{(Path)files.apply(0), (Path)files.apply(1)}))).sortWith((Function2 & java.io.Serializable & Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$9(x$9, x$10))), (Object)globbedPaths.sortWith((Function2 & java.io.Serializable & Serializable)(x$11, x$12) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$10(x$11, x$12))));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(tempDir.getAbsolutePath()).append("/folder2/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{(Path)files.apply(2), (Path)files.apply(3)}))).sortWith((Function2 & java.io.Serializable & Serializable)(x$13, x$14) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$11(x$13, x$14))), (Object)globbedPaths.sortWith((Function2 & java.io.Serializable & Serializable)(x$15, x$16) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$12(x$15, x$16))));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(tempDir.getAbsolutePath()).append("/folder1/*").toString(), new StringBuilder(10).append(tempDir.getAbsolutePath()).append("/folder2/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)files.filterNot((Function1 & java.io.Serializable & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$13(entry)))).sortWith((Function2 & java.io.Serializable & Serializable)(x$17, x$18) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$14(x$17, x$18))), (Object)globbedPaths.sortWith((Function2 & java.io.Serializable & Serializable)(x$19, x$20) -> BoxesRunTime.boxToBoolean((boolean)TestPathUtils.$anonfun$testGlobPaths$15(x$19, x$20))));
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$1(Path folder) {
        return new File(folder.toUri()).mkdir();
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$2(Path file) {
        return new File(file.toUri()).createNewFile();
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$3(Path entry) {
        return entry.toString().contains(".hoodie");
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$4(Path x$1, Path x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.toString())).$less((Object)x$2.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$5(Path x$3, Path x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.toString())).$less((Object)x$4.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$6(Path entry) {
        return entry.toString().contains(".hoodie");
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$7(Path x$5, Path x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.toString())).$less((Object)x$6.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$8(Path x$7, Path x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7.toString())).$less((Object)x$8.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$9(Path x$9, Path x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9.toString())).$less((Object)x$10.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$10(Path x$11, Path x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11.toString())).$less((Object)x$12.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$11(Path x$13, Path x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13.toString())).$less((Object)x$14.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$12(Path x$15, Path x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15.toString())).$less((Object)x$16.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$13(Path entry) {
        return entry.toString().contains(".hoodie");
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$14(Path x$17, Path x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17.toString())).$less((Object)x$18.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testGlobPaths$15(Path x$19, Path x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$19.toString())).$less((Object)x$20.toString());
    }
}

