/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.sql.avro.SchemaConverters;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.types.DataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A2Aa\u0001\u0003\u0001\u001f!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C\tiA+Z:u\u0003Z\u0014xnU3s\t\u0016T!!\u0002\u0004\u0002\t\u00054(o\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0015\u0005!\u0001.\u001e3j\u0013\tY\u0002DA\nTa\u0006\u00148.\u00113baR,'oU;qa>\u0014H/\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\t\u0005\u0011B/Z:u\u0003Z\u0014x.\u00168j_:\u001cVM\u001d#f)\u0005\u0011\u0003CA\t$\u0013\t!#C\u0001\u0003V]&$\bF\u0001\u0002'!\t9c&D\u0001)\u0015\tI#&A\u0002ba&T!a\u000b\u0017\u0002\u000f),\b/\u001b;fe*\u0011Q\u0006D\u0001\u0006UVt\u0017\u000e^\u0005\u0003_!\u0012A\u0001V3ti\u0002")
public class TestAvroSerDe
implements SparkAdapterSupport {
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    private SparkAdapter sparkAdapter$lzycompute() {
        TestAvroSerDe testAvroSerDe = this;
        synchronized (testAvroSerDe) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    @Test
    public void testAvroUnionSerDe() {
        DataType catalystSchema;
        GenericData.Record minValue = new GenericData.Record(IntWrapper.SCHEMA$);
        minValue.put("value", (Object)BoxesRunTime.boxToInteger((int)9));
        GenericData.Record maxValue = new GenericData.Record(IntWrapper.SCHEMA$);
        maxValue.put("value", (Object)BoxesRunTime.boxToInteger((int)10));
        GenericData.Record record = new GenericData.Record(HoodieMetadataColumnStats.SCHEMA$);
        record.put("fileName", (Object)"9388c460-4ace-4274-9a0b-d44606af60af-0_2-25-35_20220520154514641.parquet");
        record.put("columnName", (Object)"c8");
        record.put("minValue", (Object)minValue);
        record.put("maxValue", (Object)maxValue);
        record.put("valueCount", (Object)BoxesRunTime.boxToLong((long)10L));
        record.put("nullCount", (Object)BoxesRunTime.boxToLong((long)0L));
        record.put("totalSize", (Object)BoxesRunTime.boxToLong((long)94L));
        record.put("totalUncompressedSize", (Object)BoxesRunTime.boxToLong((long)54L));
        record.put("isDeleted", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        GenericData.Record originalAvroRecord = record;
        Schema avroSchema = HoodieMetadataColumnStats.SCHEMA$;
        SchemaConverters.SchemaType schemaType = SchemaConverters$.MODULE$.toSqlType(avroSchema);
        if (schemaType == null) {
            throw new MatchError((Object)schemaType);
        }
        DataType dataType = catalystSchema = schemaType.dataType();
        DataType catalystSchema2 = dataType;
        HoodieAvroDeserializer deserializer = this.sparkAdapter().createAvroDeserializer(avroSchema, catalystSchema2);
        HoodieAvroSerializer serializer = this.sparkAdapter().createAvroSerializer(catalystSchema2, avroSchema, false);
        Object row = deserializer.deserialize((Object)originalAvroRecord).get();
        Object deserializedAvroRecord = serializer.serialize(row);
        Assertions.assertEquals((Object)originalAvroRecord, (Object)deserializedAvroRecord);
    }

    public TestAvroSerDe() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

