/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.spark.hudi.benchmark.HoodieBenchmark;
import org.apache.spark.hudi.benchmark.HoodieBenchmark$;
import org.apache.spark.hudi.benchmark.HoodieBenchmarkBase;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class AvroSerDerBenchmark$
extends HoodieBenchmarkBase {
    public static AvroSerDerBenchmark$ MODULE$;
    private final SparkSession spark;

    static {
        new AvroSerDerBenchmark$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public SparkSession getSparkSession() {
        return SparkSession$.MODULE$.builder().master("local[1]").config("spark.driver.memory", "8G").appName(this.getClass().getCanonicalName()).getOrCreate();
    }

    public Dataset<Row> getDataFrame(long numbers) {
        return this.spark().range(0L, numbers).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).withColumn("c1", functions$.MODULE$.lit((Object)"AvroSerDerBenchmark")).withColumn("c2", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)12.99))).withColumn("c3", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)));
    }

    private void avroSerializerBenchmark() {
        HoodieBenchmark benchmark = new HoodieBenchmark("perf avro serializer for hoodie", 50000000L, HoodieBenchmark$.MODULE$.$lessinit$greater$default$3(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("serialize internalRow to avro Record", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
            Dataset<Row> df = MODULE$.getDataFrame(50000000L);
            Schema avroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), "record", "my");
            MODULE$.spark().sparkContext().getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{avroSchema}));
            HoodieSparkUtils$.MODULE$.createRdd(df, "record", "my", (Option)new Some((Object)avroSchema)).foreach((Function1 & Serializable & scala.Serializable)f -> {
                AvroSerDerBenchmark$.$anonfun$avroSerializerBenchmark$2(f);
                return BoxedUnit.UNIT;
            });
        });
        benchmark.run();
    }

    private void avroDeserializerBenchmark() {
        HoodieBenchmark benchmark = new HoodieBenchmark("perf avro deserializer for hoodie", 10000000L, HoodieBenchmark$.MODULE$.$lessinit$greater$default$3(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        Dataset<Row> df = this.getDataFrame(10000000L);
        StructType sparkSchema = df.schema();
        Schema avroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), "record", "my");
        RDD testRdd = HoodieSparkUtils$.MODULE$.createRdd(df, "record", "my", (Option)new Some((Object)avroSchema));
        testRdd.cache();
        testRdd.foreach((Function1 & Serializable & scala.Serializable)f -> {
            AvroSerDerBenchmark$.$anonfun$avroDeserializerBenchmark$1(f);
            return BoxedUnit.UNIT;
        });
        this.spark().sparkContext().getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{avroSchema}));
        benchmark.addCase("deserialize avro Record to internalRow", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> testRdd.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)sparkSchema, "record", "my");
            Function1 avroToRowConverter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(schema, sparkSchema);
            return iter.map((Function1 & Serializable & scala.Serializable)record -> (InternalRow)((Option)avroToRowConverter.apply(record)).get());
        }, testRdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)).foreach((Function1 & Serializable & scala.Serializable)f -> {
            AvroSerDerBenchmark$.$anonfun$avroDeserializerBenchmark$5(f);
            return BoxedUnit.UNIT;
        }));
        benchmark.run();
    }

    @Override
    public void afterAll() {
        this.spark().stop();
    }

    @Override
    public void runBenchmarkSuite(String[] mainArgs) {
        this.avroSerializerBenchmark();
        this.avroDeserializerBenchmark();
    }

    public static final /* synthetic */ void $anonfun$avroSerializerBenchmark$2(GenericRecord f) {
    }

    public static final /* synthetic */ void $anonfun$avroDeserializerBenchmark$1(GenericRecord f) {
    }

    public static final /* synthetic */ void $anonfun$avroDeserializerBenchmark$5(InternalRow f) {
    }

    private AvroSerDerBenchmark$() {
        MODULE$ = this;
        this.spark = this.getSparkSession();
    }
}

