/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tqA+Z:u\u00032$XM\u001d+bE2,'B\u0001\u0003\u0006\u0003\u0011AW\u000fZ5\u000b\u0005\u00199\u0011aA:rY*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0012\u001b\u0005\u0019\u0011B\u0001\n\u0004\u0005YAun\u001c3jKN\u0003\u0018M]6Tc2$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0016!\t\u0001\u0002\u0001")
public class TestAlterTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$3(TestAlterTable $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" change column id id int comment 'primary id'").toString());
        CatalogTable catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        $this.spark().sql(new StringBuilder(65).append("alter table ").append(tableName).append(" change column name name string comment 'name column'").toString());
        $this.spark().sessionState().catalog().refreshTable(new TableIdentifier(tableName));
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        $this.assertResult("name column", catalogTable.schema().apply(catalogTable.schema().fieldIndex("name")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        String newTableName = new StringBuilder(2).append(tableName).append("_1").toString();
        $this.spark().sql(new StringBuilder(23).append("alter table ").append(tableName).append(" rename to ").append(newTableName).toString());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(tableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(newTableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        Configuration hadoopConf = $this.spark().sessionState().newHadoopConf();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(hadoopConf).build();
        $this.assertResult(newTableName, metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(newTableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(37).append("alter table ").append(newTableName).append(" add columns(ext0 string)").toString());
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newTableName));
        $this.assertResult(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "ts", "ext0"})), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieSqlCommonUtils$.MODULE$.removeMetaFields(catalogTable.schema()).fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
        $this.checkExceptionContain(new StringBuilder(39).append("alter table ").append(newTableName).append(" change column id id bigint").toString(), "ALTER TABLE CHANGE COLUMN is not supported for changing column 'id' with type 'IntegerType' to 'id' with type 'LongType'");
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(newTableName).append(" values(2, 'a2', 12, 1000, 'e0')").toString());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append("\n             |merge into ").append(newTableName).append(" t0\n             |using (\n             |  select 1 as id, 'a1' as name, 12 as price, 1001 as ts, 'e0' as ext0\n             |) s0\n             |on t0.id = s0.id\n             |when matched then update set *\n             |when not matched then insert *\n           ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1001), "e0"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
        $this.spark().sql(new StringBuilder(48).append("update ").append(newTableName).append(" set price = 10, ext0 = null where id = 1").toString());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
        $this.spark().sql(new StringBuilder(48).append("update ").append(newTableName).append(" set price = 10, ext0 = null where id = 2").toString());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(newTableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
        String partitionedTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(411).append("\n             |create table ").append(partitionedTable).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             |) using hudi\n             | location '").append(tmp$1.getCanonicalPath()).append("/").append(partitionedTable).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by (dt)\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(partitionedTable).append(" values(1, 'a1', 10, 1000, '2021-07-25')").toString());
        $this.spark().sql(new StringBuilder(37).append("alter table ").append(partitionedTable).append(" add columns(ext0 double)").toString());
        $this.checkAnswer(new StringBuilder(42).append("select id, name, price, ts, dt, ext0 from ").append(partitionedTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-07-25", null}))}));
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(partitionedTable).append(" values(2, 'a2', 10, 1000, 1, '2021-07-25')").toString());
        $this.checkAnswer(new StringBuilder(54).append("select id, name, price, ts, dt, ext0 from ").append(partitionedTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-07-25", null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-07-25", BoxesRunTime.boxToDouble((double)1.0)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestAlterTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestAlterTable.$anonfun$new$3($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$6(TestAlterTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            String newTableName = new StringBuilder(2).append(tableName).append("_1").toString();
            Option oldLocation = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName)).properties().get((Object)"path");
            $this.spark().sql(new StringBuilder(23).append("alter table ").append(tableName).append(" rename to ").append(newTableName).toString());
            Option newLocation = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newTableName)).properties().get((Object)"path");
            Assertion assertion = oldLocation.nonEmpty() ? $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)newLocation.equals((Object)oldLocation)), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199)) : $this.assertResult(None$.MODULE$, newLocation, Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            String locTableName = new StringBuilder(4).append(tableName).append("_loc").toString();
            String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(locTableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(locTableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            String newLocTableName = new StringBuilder(2).append(locTableName).append("_1").toString();
            Option oldLocation2 = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(locTableName)).properties().get((Object)"path");
            $this.spark().sql(new StringBuilder(23).append("alter table ").append(locTableName).append(" rename to ").append(newLocTableName).toString());
            Option newLocation2 = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newLocTableName)).properties().get((Object)"path");
            return oldLocation2.nonEmpty() ? $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)newLocation2.equals((Object)oldLocation2)), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235)) : $this.assertResult(None$.MODULE$, newLocation2, Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(TestAlterTable $this, File tmp$3, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$3.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(602).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.write.concurrency.mode='optimistic_concurrency_control',\n             |  hoodie.cleaner.policy.failed.writes='LAZY',\n             |  hoodie.write.lock.provider='org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" change column id id int comment 'primary id'").toString());
        CatalogTable catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        $this.spark().sql(new StringBuilder(65).append("alter table ").append(tableName).append(" change column name name string comment 'name column'").toString());
        $this.spark().sessionState().catalog().refreshTable(new TableIdentifier(tableName));
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        $this.assertResult("name column", catalogTable.schema().apply(catalogTable.schema().fieldIndex("name")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        String newTableName = new StringBuilder(2).append(tableName).append("_1").toString();
        $this.spark().sql(new StringBuilder(23).append("alter table ").append(tableName).append(" rename to ").append(newTableName).toString());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(tableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(newTableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        Configuration hadoopConf = $this.spark().sessionState().newHadoopConf();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(hadoopConf).build();
        $this.assertResult(newTableName, metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(newTableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(37).append("alter table ").append(newTableName).append(" add columns(ext0 string)").toString());
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newTableName));
        $this.assertResult(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "ts", "ext0"})), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieSqlCommonUtils$.MODULE$.removeMetaFields(catalogTable.schema()).fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
        $this.checkExceptionContain(new StringBuilder(39).append("alter table ").append(newTableName).append(" change column id id bigint").toString(), "ALTER TABLE CHANGE COLUMN is not supported for changing column 'id' with type 'IntegerType' to 'id' with type 'LongType'");
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(newTableName).append(" values(2, 'a2', 12, 1000, 'e0')").toString());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$9(TestAlterTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestAlterTable.$anonfun$new$10($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestAlterTable() {
        this.test("Test Alter Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("Test Alter Rename Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("Test Alter Table With OCC", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$9(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
    }
}

