/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.TestAlterTableDropPartition$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tYB+Z:u\u00032$XM\u001d+bE2,GI]8q!\u0006\u0014H/\u001b;j_:T!\u0001B\u0003\u0002\t!,H-\u001b\u0006\u0003\r\u001d\t1a]9m\u0015\tA\u0011\"A\u0003ta\u0006\u00148N\u0003\u0002\u000b\u0017\u00051\u0011\r]1dQ\u0016T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0001\"\u0001E\t\u000e\u0003\rI!AE\u0002\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u000b\u0011\u0005A\u0001\u0001")
public class TestAlterTableDropPartition
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$5(TestAlterTableDropPartition $this, boolean urlencode$1, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator5$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021/10/01"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"l4", (Object)"v1", (Object)"2021/10/02")})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "dt"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), urlencode$1).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), SimpleKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021/10/01')").toString());
        String partitionPath = urlencode$1 ? PartitionPathEncodeUtils.escapePathName((String)"2021/10/01") : "2021/10/01";
        $this.checkAnswer(new StringBuilder(15).append("select dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/10/02"}))}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(2).append(tmp.getCanonicalPath()).append("/").append(tableName).append("/").append(partitionPath).toString())), Prettifier$.MODULE$.default(), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        if (urlencode$1) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{PartitionPathEncodeUtils.escapePathName((String)"2021/10/02")}))}));
        } else {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/10/02"}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$8(TestAlterTableDropPartition $this, boolean urlencode$2, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator13$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021/10/01")})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator13$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "dt"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), urlencode$2).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), SimpleKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(256).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.cleaner.commits.retained= '1'\n             | )\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021/10/01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(tableName).append(" values (2, \"l4\", \"v1\", \"2021/10/02\")").toString());
        String partitionPath = urlencode$2 ? PartitionPathEncodeUtils.escapePathName((String)"2021/10/01") : "2021/10/01";
        $this.checkAnswer(new StringBuilder(15).append("select dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/10/02"}))}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(2).append(tmp.getCanonicalPath()).append("/").append(tableName).append("/").append(partitionPath).toString())), Prettifier$.MODULE$.default(), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        if (urlencode$2) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{PartitionPathEncodeUtils.escapePathName((String)"2021/10/02")}))}));
        } else {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/10/02"}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$12(TestAlterTableDropPartition $this, boolean hiveStyle$1, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator21$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021", (Object)"10", (Object)"01"), new Tuple6((Object)BoxesRunTime.boxToInteger((int)2), (Object)"l4", (Object)"v1", (Object)"2021", (Object)"10", (Object)"02")})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator21$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "year", "month", "day"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "year,month,day").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStyle$1).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkExceptionContain(new StringBuilder(53).append("alter table ").append(tableName).append(" drop partition (year='2021', month='10')").toString(), "All partition columns need to be specified for Hoodie's partition");
        $this.spark().sql(new StringBuilder(63).append("alter table ").append(tableName).append(" drop partition (year='2021', month='10', day='01')").toString());
        $this.checkAnswer(new StringBuilder(43).append("select id, name, ts, year, month, day from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "l4", "v1", "2021", "10", "02"}))}));
        if (hiveStyle$1) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=10/day=02"}))}));
        } else {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/10/02"}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$15(TestAlterTableDropPartition $this, boolean hiveStyle$2, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator29$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator29$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021", (Object)"10", (Object)"01")})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestAlterTableDropPartition$$typecreator29$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "year", "month", "day"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "year,month,day").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStyle$2).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(256).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.cleaner.commits.retained= '1'\n             | )\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(63).append("alter table ").append(tableName).append(" drop partition (year='2021', month='10', day='01')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(tableName).append(" values (2, \"l4\", \"v1\", \"2021\", \"10\", \"02\")").toString());
        $this.checkAnswer(new StringBuilder(43).append("select id, name, ts, year, month, day from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "l4", "v1", "2021", "10", "02"}))}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(27).append(tmp.getCanonicalPath()).append("/").append(tableName).append("/year=2021/month=10/day=01").toString())), Prettifier$.MODULE$.default(), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        if (hiveStyle$2) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=10/day=02"}))}));
        } else {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/10/02"}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$18(TestAlterTableDropPartition $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(411).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             |) using hudi\n             | location '").append(tmp$1.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by (dt)\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(98).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, '01'), ").append("(2, 'a2', 10, 1000, '02'), (3, 'a3', 10, 1000, '03')").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "03"}))}));
        $this.spark().sql(new StringBuilder(39).append("alter table ").append(tableName).append(" drop partition (dt = '01')").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "03"}))}));
        Configuration hadoopConf = $this.spark().sessionState().newHadoopConf();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString()).setConf(hadoopConf).build();
        Option lastInstant = metaClient.getActiveTimeline().lastInstant();
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails((HoodieInstant)lastInstant.get()).get()), HoodieCommitMetadata.class);
        String schemaStr = (String)commitMetadata.getExtraMetadata().get("schema");
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)schemaStr));
        $this.spark().sql(new StringBuilder(28).append("delete from ").append(tableName).append(" where dt = '02'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "03"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$17(TestAlterTableDropPartition $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestAlterTableDropPartition.$anonfun$new$18($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$20(TestAlterTableDropPartition $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(2).append(tmp.getCanonicalPath()).append("t/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(ts)\n           | location '").append(basePath).append("'\n           | ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieClientFromPath($this.spark(), basePath, Predef$.MODULE$.Map().empty());
        String firstScheduleInstant = HoodieActiveTimeline.createNewInstantTime();
        client.scheduleClusteringAtInstant(firstScheduleInstant, Option.empty());
        $this.checkAnswer(new StringBuilder(24).append("call show_clustering('").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.REQUESTED.name(), "*"}))}));
        String partition = "ts=1002";
        String errMsg = new StringBuilder(149).append("Failed to drop partitions. Please ensure that there are no pending table service actions (clustering/compaction) for the partitions to be deleted: [").append(partition).append("]").toString();
        $this.checkExceptionContain(new StringBuilder(29).append("ALTER TABLE ").append(tableName).append(" DROP PARTITION(").append(partition).append(")").toString(), errMsg);
    }

    public static final /* synthetic */ void $anonfun$new$22(TestAlterTableDropPartition $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(2).append(tmp.getCanonicalPath()).append("t/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(404).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts',\n           |  hoodie.index.type = 'INMEMORY'\n           | )\n           | partitioned by(ts)\n           | location '").append(basePath).append("'\n           | ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004)").toString());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieClientFromPath($this.spark(), basePath, Predef$.MODULE$.Map().empty());
        String firstScheduleInstant = HoodieActiveTimeline.createNewInstantTime();
        Assertions.assertTrue((boolean)client.scheduleCompactionAtInstant(firstScheduleInstant, Option.empty()));
        $this.checkAnswer(new StringBuilder(24).append("call show_compaction('").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)5), HoodieInstant.State.REQUESTED.name()}))}));
        String partition = "ts=1002";
        String errMsg = new StringBuilder(149).append("Failed to drop partitions. Please ensure that there are no pending table service actions (clustering/compaction) for the partitions to be deleted: [").append(partition).append("]").toString();
        $this.checkExceptionContain(new StringBuilder(29).append("ALTER TABLE ").append(tableName).append(" DROP PARTITION(").append(partition).append(")").toString(), errMsg);
    }

    public TestAlterTableDropPartition() {
        this.test("Drop non-partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(272).append("\n         | create table ").append(tableName).append(" (\n         |  id bigint,\n         |  name string,\n         |  ts string,\n         |  dt string\n         | )\n         | using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         | )\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(80).append("insert into ").append(tableName).append(" values (1, \"z3\", \"v1\", \"2021-10-01\"), (2, \"l4\", \"v1\", \"2021-10-02\")").toString());
            this.checkExceptionContain(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01')").toString(), new StringBuilder(65).append(tableName).append(" is a non-partitioned table that is not allowed to drop partition").toString());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Seq$.MODULE$.empty()));
        }, new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("Lazy Clean drop non-partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(322).append("\n         | create table ").append(tableName).append(" (\n         |  id bigint,\n         |  name string,\n         |  ts string,\n         |  dt string\n         | )\n         | using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts',\n         |  hoodie.cleaner.commits.retained= '1'\n         | )\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(80).append("insert into ").append(tableName).append(" values (1, \"z3\", \"v1\", \"2021-10-01\"), (2, \"l4\", \"v1\", \"2021-10-02\")").toString());
            this.checkExceptionContain(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01')").toString(), new StringBuilder(65).append(tableName).append(" is a non-partitioned table that is not allowed to drop partition").toString());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Seq$.MODULE$.empty()));
        }, new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)urlencode -> {
            this.test(new StringBuilder(52).append("Drop single-partition table' partitions, urlencode: ").append(BoxesRunTime.unboxToBoolean((Object)urlencode)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$5($this, urlencode, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)urlencode -> {
            this.test(new StringBuilder(63).append("Lazy Clean drop single-partition table' partitions, urlencode: ").append(BoxesRunTime.unboxToBoolean((Object)urlencode)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$8($this, urlencode, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            return BoxedUnit.UNIT;
        });
        this.test("Drop single-partition table' partitions created by sql", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(303).append("\n         | create table ").append(tableName).append(" (\n         |  id bigint,\n         |  name string,\n         |  ts string,\n         |  dt string\n         | )\n         | using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         | )\n         | partitioned by (dt)\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(80).append("insert into ").append(tableName).append(" values (1, \"z3\", \"v1\", \"2021-10-01\"), (2, \"l4\", \"v1\", \"2021-10-02\")").toString());
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_3()) {
                this.checkExceptionContain(new StringBuilder(62).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01', dt='2021-10-02')").toString(), "Found duplicate keys `dt`");
            } else {
                this.checkExceptionContain(new StringBuilder(62).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01', dt='2021-10-02')").toString(), "Found duplicate keys 'dt'");
            }
            this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01')").toString());
            this.checkAnswer(new StringBuilder(29).append("select id, name, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "l4", "v1", "2021-10-02"}))}));
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt=2021-10-02"}))}));
        }, new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)hiveStyle -> {
            this.test(new StringBuilder(74).append("Drop multi-level partitioned table's partitions, isHiveStylePartitioning: ").append(BoxesRunTime.unboxToBoolean((Object)hiveStyle)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$12($this, hiveStyle, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)hiveStyle -> {
            this.test(new StringBuilder(85).append("Lazy Clean drop multi-level partitioned table's partitions, isHiveStylePartitioning: ").append(BoxesRunTime.unboxToBoolean((Object)hiveStyle)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$15($this, hiveStyle, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            return BoxedUnit.UNIT;
        });
        this.test("check instance schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTableDropPartition.$anonfun$new$17(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("Prevent a partition from being dropped if there are pending CLUSTERING jobs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTableDropPartition.$anonfun$new$20(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.test("Prevent a partition from being dropped if there are pending COMPACTs jobs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTableDropPartition.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
    }
}

