/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0019B+Z:u\u0007>l\u0007/Y2uS>tG+\u00192mK*\u0011A!B\u0001\u0005QV$\u0017N\u0003\u0002\u0007\u000f\u0005\u00191/\u001d7\u000b\u0005!I\u0011!B:qCJ\\'B\u0001\u0006\f\u0003\u0019\t\u0007/Y2iK*\tA\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001#E\u0007\u0002\u0007%\u0011!c\u0001\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0006\t\u0003!\u0001\u0001")
public class TestCompactionTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestCompactionTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(24).append("schedule compaction  on ").append(tableName).toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 2").toString());
        $this.spark().sql(new StringBuilder(24).append("schedule compaction  on ").append(tableName).toString());
        Row[] compactionRows = (Row[])$this.spark().sql(new StringBuilder(28).append("show compaction on ").append(tableName).append(" limit 10").toString()).collect();
        String[] timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[1]).toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(19).append("show compaction on ").append(tableName).toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[0]).toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(19).append("show compaction on ").append(tableName).toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }

    public static final /* synthetic */ void $anonfun$new$5(TestCompactionTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(20).append("run compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(21).append("show compaction on '").append(tmp.getCanonicalPath()).append("'").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 1").toString());
        $this.spark().sql(new StringBuilder(25).append("schedule compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 2").toString());
        $this.spark().sql(new StringBuilder(25).append("schedule compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(21).append("show compaction on '").append(tmp.getCanonicalPath()).append("'").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        $this.spark().sql(new StringBuilder(20).append("run compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(21).append("show compaction on '").append(tmp.getCanonicalPath()).append("'").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        $this.checkException(new StringBuilder(29).append("run compaction on '").append(tmp.getCanonicalPath()).append("' at 12345").toString(), new StringBuilder(88).append("Compaction instant: 12345 is not found in ").append(tmp.getCanonicalPath()).append(", Available pending compaction instants are:  ").toString());
    }

    public TestCompactionTable() {
        this.test("Test compaction table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 22));
        this.test("Test compaction path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionTable.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }
}

