/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.hudi.TestCreateTable$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tyA+Z:u\u0007J,\u0017\r^3UC\ndWM\u0003\u0002\u0005\u000b\u0005!\u0001.\u001e3j\u0015\t1q!A\u0002tc2T!\u0001C\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Y\u0011AB1qC\u000eDWMC\u0001\r\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0002\u0005\u0002\u0011#5\t1!\u0003\u0002\u0013\u0007\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011\u0001\u0003\u0001")
public class TestCreateTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$6(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(294).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id,name',\n           |  type = 'cow'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        $this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        $this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        $this.assertResult(CatalogTableType$.MODULE$.EXTERNAL(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        $this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> new StructField(x$3, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        $this.assertResult(table.properties().apply((Object)"type"), "cow", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        $this.assertResult(table.properties().apply((Object)"primaryKey"), "id,name", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | partitioned by (dt)\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  type = 'mor'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("/h0'\n       ").toString())).stripMargin());
        CatalogTable table2 = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        $this.assertResult(table2.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        $this.assertResult(table2.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        $this.assertResult(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt"})), table2.partitionColumnNames(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        $this.assertResult(HoodieParquetRealtimeInputFormat.class.getCanonicalName(), table2.storage().inputFormat().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        String tableName3 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n           |create table ").append(tableName3).append("\n           |using hudi\n           |location '").append(tmp.getCanonicalPath()).append("/h0'\n         ").toString())).stripMargin());
        CatalogTable table3 = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName3));
        $this.assertResult(table3.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        $this.assertResult(table3.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        $this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> new StructField(x$4, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dt", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table3.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
    }

    public static final /* synthetic */ void $anonfun$new$10(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(312).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id1',\n             |  type = 'cow'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts1',\n             |  type = 'cow'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  type = 'cow1'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
    }

    public static final /* synthetic */ void $anonfun$new$16(TestCreateTable $this, File tmp$2, String tableType) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(275).append("\n             | create table ").append(tableName1).append(" using hudi\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName1).append("'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n       ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName1).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        String tableName2 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(320).append("\n             | create table ").append(tableName2).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName2).append("'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName2).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
        String tableName3 = $this.generateTableName();
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(362).append("\n               | create table ").append(tableName3).append(" using hudi\n               | partitioned by (dt)\n               | tblproperties(\n               |    primaryKey = 'id',\n               |    type = '").append(tableType).append("'\n               | )\n               | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName3).append("'\n               | AS\n               | select null as id, 'a1' as name, 10 as price, '2021-05-07' as dt\n               |\n             ").toString())).stripMargin()), ClassTag$.MODULE$.apply(Exception.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n             | create table ").append(tableName3).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName3).append("'\n             | AS\n             | select cast('2021-05-06 00:00:00' as timestamp) as dt, 1 as id, 'a1' as name, 10 as\n             | price\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName3).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, cast(dt as string) from ").append(tableName3).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-06 00:00:00"}))}));
        String tableName4 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             | create table ").append(tableName4).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName4).append("'\n             | AS\n             | select cast('2021-05-06' as date) as dt, 1 as id, 'a1' as name, 10 as\n             | price\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName4).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, cast(dt as string) from ").append(tableName4).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-06"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$15(TestCreateTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestCreateTable.$anonfun$new$16($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$19(TestCreateTable $this, File tmp) {
        String parentPath = tmp.getCanonicalPath();
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'mor'\n           | )\n           | location '").append(parentPath).append("/").append(tableName1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a1', 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a2', 1100)").toString());
        String roTableName1 = new StringBuilder(3).append(tableName1).append("_ro").toString();
        String rtTableName1 = new StringBuilder(3).append(tableName1).append("_rt").toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n           |create table ").append(roTableName1).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '").append(parentPath).append("/").append(tableName1).append("'\n           |").toString())).stripMargin());
        CatalogTable roCatalogTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(roTableName1));
        $this.assertResult(roCatalogTable.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        $this.assertResult(roCatalogTable.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        $this.assertResult(roCatalogTable.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        $this.assertResult(roCatalogTable.storage().properties().apply((Object)"hoodie.query.as.ro.table"), "true", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        $this.checkAnswer(new StringBuilder(25).append("select id, name, ts from ").append(roTableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n           |create table ").append(rtTableName1).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'false'\n           |)\n           |location '").append(parentPath).append("/").append(tableName1).append("'\n           |").toString())).stripMargin());
        CatalogTable rtCatalogTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(rtTableName1));
        $this.assertResult(rtCatalogTable.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        $this.assertResult(rtCatalogTable.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        $this.assertResult(rtCatalogTable.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        $this.assertResult(rtCatalogTable.storage().properties().apply((Object)"hoodie.query.as.ro.table"), "false", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        $this.checkAnswer(new StringBuilder(25).append("select id, name, ts from ").append(rtTableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToInteger((int)1100)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$21(TestCreateTable $this, File tmp) {
        String parentPath = tmp.getCanonicalPath();
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n           |create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'cow'\n           | )\n           | location '").append(parentPath).append("/").append(tableName1).append("'\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a1', 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a2', 1100)").toString());
        String roTableName1 = new StringBuilder(3).append(tableName1).append("_ro").toString();
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n           |create table ").append(roTableName1).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '").append(parentPath).append("/").append(tableName1).append("'\n           |").toString())).stripMargin(), "Creating ro/rt table should only apply to a mor table.");
        String tableName2 = $this.generateTableName();
        String rtTableName2 = new StringBuilder(3).append(tableName2).append("_rt").toString();
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n           |create table ").append(rtTableName2).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '").append(parentPath).append("/").append(tableName2).append("'\n           |").toString())).stripMargin(), "Creating ro/rt table need the existence of the base table.");
        String tableName3 = $this.generateTableName();
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n           | create table ").append(tableName3).append(" using hudi\n           | tblproperties(\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    type = 'mor',\n           |    'hoodie.query.as.ro.table' = 'true'\n           | )\n           | location '").append(parentPath).append("/").append(tableName3).append("'\n           | AS\n           | select 1 as id, 'a1' as name, 1000 as ts\n           | ").toString())).stripMargin(), "Not support CTAS for the ro/rt table");
    }

    public static final /* synthetic */ void $anonfun$new$23(TestCreateTable $this, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(494).append("\n           | create table ").append(tableName).append(" using hudi\n           | partitioned by (dt)\n           | tblproperties(\n           |    hoodie.database.name = \"databaseName\",\n           |    hoodie.table.name = \"tableName\",\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    hoodie.datasource.write.operation = 'upsert',\n           |    type = '").append(tableType).append("'\n           | )\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt, 1000 as ts\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
        String tablePath = (String)table.storage().properties().apply((Object)"path");
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf($this.spark().sessionState().newHadoopConf()).build();
        Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        $this.assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
    }

    public static final /* synthetic */ void $anonfun$new$25(TestCreateTable $this, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(488).append("\n           | create table ").append(tableName).append(" using hudi\n           | partitioned by (dt)\n           | options(\n           |    hoodie.database.name = \"databaseName\",\n           |    hoodie.table.name = \"tableName\",\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    hoodie.datasource.write.operation = 'upsert',\n           |    type = '").append(tableType).append("'\n           | )\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt, 1000 as ts\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
        String tablePath = (String)table.storage().properties().apply((Object)"path");
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf($this.spark().sessionState().newHadoopConf()).build();
        Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
        $this.assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
        Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
    }

    public static final /* synthetic */ void $anonfun$new$29(TestCreateTable $this, File tmp$3, String partitionValue) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$3.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestCreateTable$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_spark_sql_hudi_TestCreateTable$$typecreator5$1(TestCreateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)partitionValue)})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestCreateTable$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), new StringBuilder(9).append("original_").append(tableName).toString()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), SimpleKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n             |create table ").append(tableName).append(" using hudi\n             |partitioned by (dt)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin(), "It is not allowed to specify partition columns when the table schema is not defined.");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, value, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf($this.spark().sessionState().newHadoopConf()).build();
        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
        $this.assertResult("dt", properties.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        $this.assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        $this.assertResult("hudi_database", metaClient.getTableConfig().getDatabaseName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        $this.assertResult(new StringBuilder(9).append("original_").append(tableName).toString(), metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        $this.spark().sql(new StringBuilder(42).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, '").append(partitionValue).append("')").toString());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(209).append("\n             |merge into ").append(tableName).append(" h0\n             |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts, '").append(partitionValue).append("' as dt) s0\n             |on h0.id = s0.id\n             |when matched then update set *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set value = value + 1 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
    }

    public static final /* synthetic */ void $anonfun$new$28(TestCreateTable $this, File tmp) {
        String databaseName = "hudi_database";
        $this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
        $this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-08-02", "2021/08/02"}))).foreach((Function1 & Serializable & scala.Serializable)partitionValue -> {
            TestCreateTable.$anonfun$new$29($this, tmp, partitionValue);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$32(TestCreateTable $this, File tmp$4, String day) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$4.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestCreateTable$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_TestCreateTable$$typecreator13$1(TestCreateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)day, (Object)BoxesRunTime.boxToInteger((int)12))})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestCreateTable$$typecreator13$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "day", "hh"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "day,hh").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id, name, value, ts, day, hh from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf($this.spark().sessionState().newHadoopConf()).build();
        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        $this.assertResult("day,hh", properties.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
        $this.assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, '").append(day).append("', 12)").toString());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:1", new StringBuilder(3).append(day).append("/12").toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringBuilder(3).append(day).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n             |merge into ").append(tableName).append(" h0\n             |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts, '").append(day).append("' as day, 12 as hh) s0\n             |on h0.id = s0.id\n             |when matched then update set *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:1", new StringBuilder(3).append(day).append("/12").toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringBuilder(3).append(day).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set value = value + 1 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:1", new StringBuilder(3).append(day).append("/12").toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringBuilder(3).append(day).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringBuilder(3).append(day).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$31(TestCreateTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-08-02", "2021/08/02"}))).foreach((Function1 & Serializable & scala.Serializable)day -> {
            TestCreateTable.$anonfun$new$32($this, tmp, day);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$34(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestCreateTable$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_hudi_TestCreateTable$$typecreator21$1(TestCreateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000))})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestCreateTable$$typecreator21$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), NonpartitionedKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tmp.getCanonicalPath());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n           |create table ").append(tableName).append(" using hudi\n           |location '").append(tmp.getCanonicalPath()).append("'\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tmp.getCanonicalPath()).setConf($this.spark().sessionState().newHadoopConf()).build();
        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
        $this.assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(88).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "", BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "", BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n           |merge into ").append(tableName).append(" h0\n           |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts) s0\n           |on h0.id = s0.id\n           |when matched then update set *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set value = value + 1 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    private final Assertion checkKeyGenerator$1(String targetGenerator, String tableName) {
        String tablePath = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).location().getPath();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.spark().sessionState().newHadoopConf()).build();
        String realKeyGenerator = (String)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms()).get((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()).get();
        return this.assertResult(targetGenerator, realKeyGenerator, Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974));
    }

    public TestCreateTable() {
        this.test("Test Create Managed Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String databaseName = "hudi_database";
            this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
            this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(415).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | tblproperties (\n         |   hoodie.database.name = \"databaseName\",\n         |   hoodie.table.name = \"tableName\",\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts',\n         |   hoodie.datasource.write.operation = 'upsert'\n         | )\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> new StructField(x$1, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
            String tablePath = (String)table.storage().properties().apply((Object)"path");
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.spark().sessionState().newHadoopConf()).build();
            HoodieTableConfig tableConfig = metaClient.getTableConfig();
            this.assertResult(databaseName, tableConfig.getDatabaseName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            this.assertResult(tableName, tableConfig.getTableName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(tableConfig.contains(DataSourceWriteOptions$.MODULE$.OPERATION().key())));
            return this.spark().sql("use default");
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("Test Create Hoodie Table With Options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long,\n         |  dt string\n         | ) using hudi\n         | partitioned by (dt)\n         | options (\n         |   hoodie.database.name = \"databaseName\",\n         |   hoodie.table.name = \"tableName\",\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts',\n         |   hoodie.datasource.write.operation = 'upsert'\n         | )\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            this.assertResult(table.properties().apply((Object)"type"), "cow", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            this.assertResult(table.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            this.assertResult(table.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new StructField(x$2, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dt", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
            String tablePath = (String)table.storage().properties().apply((Object)"path");
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.spark().sessionState().newHadoopConf()).build();
            Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)tableConfig.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            this.assertResult("dt", tableConfig.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.assertResult("id", tableConfig.apply((Object)HoodieTableConfig.RECORDKEY_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            this.assertResult("ts", tableConfig.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            this.assertResult(SimpleKeyGenerator.class.getCanonicalName(), tableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            this.assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            this.assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Test Create External Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("Test Table Column Validate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("Test Create Table As Select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$15(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("Test Create ro/rt Table In The Right Way", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$19(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.test("Test Create ro/rt Table In The Wrong Way", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$21(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        this.test("Test Create Table As Select With Tblproperties For Filter Props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestCreateTable.$anonfun$new$23(this, tableType);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        this.test("Test Create Table As Select With Options For Filter Props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestCreateTable.$anonfun$new$25(this, tableType);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        this.test("Test Create Table As Select when 'spark.sql.datetime.java8API.enabled' enables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            try {
                this.spark().conf().set("spark.sql.datetime.java8API.enabled", true);
                String tableName = this.generateTableName();
                this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           |create table ").append(tableName).append("\n           |using hudi\n           |partitioned by(dt)\n           |options(type = 'cow', primaryKey = 'id')\n           |as\n           |select 1 as id, 'a1' as name, 10 as price, cast('2021-05-07 00:00:00' as timestamp) as dt\n           |").toString())).stripMargin());
                this.checkAnswer(new StringBuilder(48).append("select id, name, price, cast(dt as string) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-07 00:00:00"}))}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.spark().conf().set("spark.sql.datetime.java8API.enabled", false);
            }
            return boxedUnit;
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        this.test("Test Create Table From Existing Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$28(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
        this.test("Test Create Table From Existing Hoodie Table For Multi-Level Partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$31(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        this.test("Test Create Table From Existing Hoodie Table For None Partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$34(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
        this.test("Test Create Table Existing In Catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n         |create table ").append(tableName).append(" (\n         | id int,\n         | name string,\n         | price double\n         |) using hudi\n         |tblproperties(primaryKey = 'id')\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(35).append("alter table ").append(tableName).append(" add columns(ts bigint)").toString());
            return this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(184).append("\n         |create table if not exists ").append(tableName).append(" (\n         | id int,\n         | name string,\n         | price double\n         |) using hudi\n         |tblproperties(primaryKey = 'id')\n         |").toString())).stripMargin());
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
        if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
            this.test("Test create table with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
                String tableName = this.generateTableName();
                this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           | ) using hudi\n           | comment \"This is a simple hudi table\"\n           | tblproperties (\n           |   primaryKey = 'id',\n           |   preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
                String shown = ((Row)this.spark().sql(new StringBuilder(18).append("show create table ").append(tableName).toString()).head()).getString(0);
                return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)shown.contains("COMMENT 'This is a simple hudi table'")), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
            }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 895));
        }
        this.test("Test CTAS using an illegal definition -- a COW table with compaction enabled.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(269).append("\n         | create table ").append(tableName).append(" using hudi\n         | tblproperties(\n         |    primaryKey = 'id',\n         |    type = 'cow',\n         |    hoodie.compact.inline='true'\n         | )\n         | AS\n         | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n         |").toString())).stripMargin(), "Compaction is not supported on a CopyOnWrite table");
            String dbPath = this.spark().sessionState().catalog().getDatabaseMetadata("default").locationUri().getPath();
            String tablePath = new StringBuilder(1).append(dbPath).append("/").append(tableName).toString();
            return this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)this.existsPath(tablePath)), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
        this.test("Test Create Non-Hudi Table(Parquet Table)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String databaseName = "test_database";
            this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
            this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using parquet\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 951));
            this.assertResult("parquet", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 952));
            this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 953));
            this.assertResult(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
            return this.spark().sql("use default");
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
        this.test("Test Infer KegGenClazz", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(307).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkKeyGenerator$1("org.apache.hudi.keygen.NonpartitionedKeyGenerator", tableName);
            this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | partitioned by (ts)\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkKeyGenerator$1("org.apache.hudi.keygen.SimpleKeyGenerator", tableName);
            this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(343).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | partitioned by (ts)\n         | tblproperties (\n         |   primaryKey = 'id,name',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkKeyGenerator$1("org.apache.hudi.keygen.ComplexKeyGenerator", tableName);
            return this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 965));
    }
}

