/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00051\tiA+Z:u\tJ|\u0007\u000fV1cY\u0016T!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\u0011I!a\u0005\u0003\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\f\u0011\u0005E\u0001\u0011\u0001F1mi\u0016\u00148+\u001a:eKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u001a?%z\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"\u0001B+oSRDQ\u0001\t\u0002A\u0002\u0005\nab]3tg&|gnQ1uC2|w\r\u0005\u0002#O5\t1E\u0003\u0002%K\u000591-\u0019;bY><'B\u0001\u0014\u0007\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0015$\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQA\u000b\u0002A\u0002-\n\u0001\u0002^1cY\u0016LE\r\u001e\t\u0003Y5j\u0011!J\u0005\u0003]\u0015\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\u0006a\t\u0001\r!M\u0001\u000e]\u0016<\bK]8qKJ$\u0018.Z:\u0011\tIJD\b\u0010\b\u0003g]\u0002\"\u0001N\u000e\u000e\u0003UR!A\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\tA4$\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u00121!T1q\u0015\tA4\u0004\u0005\u00023{%\u0011ah\u000f\u0002\u0007'R\u0014\u0018N\\4")
public class TestDropTable
extends HoodieSparkSqlTestBase {
    private void alterSerdeProperties(SessionCatalog sessionCatalog, TableIdentifier tableIdt, Map<String, String> newProperties) {
        Map storageProperties;
        CatalogTable catalogTable = this.spark().sessionState().catalog().getTableMetadata(tableIdt);
        CatalogStorageFormat storage = catalogTable.storage();
        Map x$1 = storageProperties = storage.properties().$plus$plus(newProperties);
        Option x$2 = storage.copy$default$1();
        Option x$3 = storage.copy$default$2();
        Option x$4 = storage.copy$default$3();
        Option x$5 = storage.copy$default$4();
        boolean x$6 = storage.copy$default$5();
        CatalogStorageFormat x$7 = storage.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        TableIdentifier x$8 = catalogTable.copy$default$1();
        CatalogTableType x$9 = catalogTable.copy$default$2();
        StructType x$10 = catalogTable.copy$default$4();
        Option x$11 = catalogTable.copy$default$5();
        Seq x$12 = catalogTable.copy$default$6();
        Option x$13 = catalogTable.copy$default$7();
        String x$14 = catalogTable.copy$default$8();
        long x$15 = catalogTable.copy$default$9();
        long x$16 = catalogTable.copy$default$10();
        String x$17 = catalogTable.copy$default$11();
        Map x$18 = catalogTable.copy$default$12();
        Option x$19 = catalogTable.copy$default$13();
        Option x$20 = catalogTable.copy$default$14();
        Option x$21 = catalogTable.copy$default$15();
        Seq x$22 = catalogTable.copy$default$16();
        boolean x$23 = catalogTable.copy$default$17();
        boolean x$24 = catalogTable.copy$default$18();
        Map x$25 = catalogTable.copy$default$19();
        Option x$26 = catalogTable.copy$default$20();
        CatalogTable newCatalogTable = catalogTable.copy(x$8, x$9, x$7, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
        sessionCatalog.alterTable(newCatalogTable);
    }

    public static final /* synthetic */ void $anonfun$new$2(TestDropTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(11).append("DROP TABLE ").append(tableName).toString());
            $this.checkAnswer(new StringBuilder(19).append("show tables like '").append(tableName).append("'").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
            return $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString())), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(TestDropTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(17).append("DROP TABLE ").append(tableName).append(" PURGE").toString());
            $this.checkAnswer(new StringBuilder(19).append("show tables like '").append(tableName).append("'").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
            return $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString())), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(17).append("drop table ").append(tableName).append(" purge").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$12(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_ro").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", tableName, BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", new StringBuilder(3).append(tableName).append("_rt").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_rt").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", tableName, BoxesRunTime.boxToBoolean((boolean)false)}))}));
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$14(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(20).append("drop table ").append(tableName).append("_ro purge").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$16(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        FileSystem filesystem = FSUtils.getFs((String)tablePath, (Configuration)$this.spark().sparkContext().hadoopConfiguration());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(269).append("\n           |create table ").append(tableName).append(" (\n           |id int,\n           |ts int,\n           |value string\n           |)using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           |").toString())).stripMargin());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(new Path(tablePath)), "filesystem.exists(new org.apache.hadoop.fs.Path(tablePath))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Table path doesn't exists (").append(tablePath).append(").").toString(), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        filesystem.delete(new Path(tablePath), true);
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$18(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        FileSystem filesystem = FSUtils.getFs((String)tablePath, (Configuration)$this.spark().sparkContext().hadoopConfiguration());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n           |create table ").append(tableName).append(" (\n           |id int,\n           |ts int,\n           |value string\n           |)using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'mor'\n           | )\n           |").toString())).stripMargin());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(new Path(tablePath)), "filesystem.exists(new org.apache.hadoop.fs.Path(tablePath))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(28).append("Table path doesn't exist (").append(tablePath).append(").").toString(), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        filesystem.delete(new Path(tablePath), true);
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_ro").toString());
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_rt").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public TestDropTable() {
        this.test("Test Drop Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("Test Drop Table with non existent table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("drop table if exists non_existent_table");
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("drop table non_existent_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Test Drop Table with purge", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Test Drop RO & RT table by purging base table.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Test Drop RO & RT table by one by one.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$12(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("Test Drop RO table with purge", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$14(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("Drop an EXTERNAL table which path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$16(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("Drop an MOR table and related RT & RO when path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("Drop an MANAGED table which path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(224).append("\n         |create table ").append(tableName).append(" (\n         |id int,\n         |ts int,\n         |value string\n         |)using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         | )\n         |").toString())).stripMargin());
            Path tablePath = new Path(this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).location());
            FileSystem filesystem = FSUtils.getFs((Path)tablePath, (Configuration)this.spark().sparkContext().hadoopConfiguration());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(tablePath), "filesystem.exists(tablePath)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Table path doesn't exists (").append(tablePath).append(").").toString(), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            filesystem.delete(tablePath, true);
            this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
            this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("Drop local temporary view should not fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String viewName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n         |create temporary view ").append(viewName).append(" as\n         | select 1\n         |").toString())).stripMargin());
            return this.spark().sql(new StringBuilder(10).append("drop view ").append(viewName).toString());
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        this.test("Drop global temporary view should not fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String viewName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n         |create global temporary view ").append(viewName).append(" as\n         | select 1\n         |").toString())).stripMargin());
            return this.spark().sql(new StringBuilder(22).append("drop view global_temp.").append(viewName).toString());
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
    }
}

