/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieDuplicateKeyException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.TestInsertTable$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00051\tyA+Z:u\u0013:\u001cXM\u001d;UC\ndWM\u0003\u0002\u0006\r\u0005!\u0001.\u001e3j\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002-A\u0011\u0011\u0003A\u0001(m\u0006d\u0017\u000eZ1uK\u0012KgMZ3sK:$H+\u001f9fg>3\u0007+\u0019:uSRLwN\\\"pYVlg\u000eF\u0003\u001a?%24\b\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0003V]&$\b\"\u0002\u0011\u0003\u0001\u0004\t\u0013a\u0001;naB\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0003S>T\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t!a)\u001b7f\u0011\u0015Q#\u00011\u0001,\u00035\u0001\u0018M\u001d;ji&|g\u000eV=qKB\u0011Af\r\b\u0003[E\u0002\"AL\u000e\u000e\u0003=R!\u0001\r\b\u0002\rq\u0012xn\u001c;?\u0013\t\u00114$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a\u001c\u0011\u00159$\u00011\u00019\u00039\u0001\u0018M\u001d;ji&|gNV1mk\u0016\u0004\"AG\u001d\n\u0005iZ\"aA!os\")AH\u0001a\u0001W\u0005IA/\u00192mK:\u000bW.\u001a")
public class TestInsertTable
extends HoodieSparkSqlTestBase {
    private void validateDifferentTypesOfPartitionColumn(File tmp, String partitionType, Object partitionValue, String tableName) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(244).append("\n         |create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  dt ").append(partitionType).append("\n         |) using hudi\n         | tblproperties (primaryKey = 'id')\n         | partitioned by (dt)\n         | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n       ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(48).append("insert into ").append(tableName).append(" partition(dt = ").append(this.dropTypeLiteralPrefix(partitionValue)).append(") select 1, 'a1', 10").toString());
        this.spark().sql(new StringBuilder(33).append("insert into ").append(tableName).append(" select 2, 'a2', 10, ").append(partitionValue).toString());
        this.checkAnswer(new StringBuilder(60).append("select id, name, price, cast(dt as string) from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), this.extractRawValue(partitionValue).toString()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), this.extractRawValue(partitionValue).toString()}))}));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  dt string,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (primaryKey = 'id')\n           | partitioned by (dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(191).append("\n           | insert into ").append(tableName).append(" values\n           | (1, 'a1', 10, 1000, \"2021-01-05\"),\n           | (2, 'a2', 20, 2000, \"2021-01-06\"),\n           | (3, 'a3', 30, 3000, \"2021-01-07\")\n              ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000), "2021-01-06"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)3000), "2021-01-07"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$4(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  dt string,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (primaryKey = 'id')\n           | partitioned by (dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n           | insert into ").append(tableName).append(" partition(dt = '2021-01-05')\n           | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n              ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n           | insert into ").append(tableName).append(" partition(dt = '2021-01-06')\n           | select 20 as price, 2000 as ts, 2 as id, 'a2' as name\n              ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tmp.getCanonicalPath()).setConf($this.spark().sessionState().newHadoopConf()).build();
        StructType schema = (StructType)HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(metaClient, HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema$default$2()).get();
        Option $org_scalatest_assert_macro_left = schema.getFieldIndex("id");
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        Option $org_scalatest_assert_macro_left2 = schema.getFieldIndex("price");
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n           | insert into ").append(tableName).append("\n           | select 3, 'a3', 30, 3000, '2021-01-07'\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000), "2021-01-06"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)3000), "2021-01-07"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$6(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  dt string,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (primaryKey = 'id')\n           | partitioned by (dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n           | insert into ").append(tableName).append(" partition(dt)\n           | select 1 as id, '2021-01-05' as dt, 'a1' as name, 10 as price, 1000 as ts\n        ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tmp.getCanonicalPath()).setConf($this.spark().sessionState().newHadoopConf()).build();
        StructType schema = (StructType)HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(metaClient, HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema$default$2()).get();
        Option $org_scalatest_assert_macro_left = schema.getFieldIndex("id");
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        Option $org_scalatest_assert_macro_left2 = schema.getFieldIndex("price");
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n           | insert into ").append(tableName).append("\n           | select 2 as id, 'a2' as name, 20 as price, 2000 as ts, '2021-01-06' as dt\n        ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n           | insert into ").append(tableName).append("\n           | select 3, 'a3', 30, 3000, '2021-01-07'\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000), "2021-01-06"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)3000), "2021-01-07"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  dt string,\n           |  name string,\n           |  price double,\n           |  ht string,\n           |  ts long\n           |) using hudi\n           | tblproperties (primaryKey = 'id')\n           | partitioned by (dt, ht)\n           | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n           | insert into ").append(tableName).append(" partition(dt, ht)\n           | select 1 as id, 'a1' as name, 10 as price,'20210101' as dt, 1000 as ts, '01' as ht\n              ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("\n           | insert into ").append(tableName).append(" partition(dt = '20210102', ht)\n           | select 2 as id, 'a2' as name, 20 as price, 2000 as ts, '02' as ht\n              ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("\n           | insert into ").append(tableName).append(" partition(dt, ht = '03')\n           | select 3 as id, 'a3' as name, 30 as price, 3000 as ts, '20210103' as dt\n              ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("\n           | insert into ").append(tableName).append("\n           | select 4, 'a4', 40, 4000, '20210104', '04'\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(40).append("select id, name, price, ts, dt, ht from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "20210101", "01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000), "20210102", "02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)3000), "20210103", "03"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToInteger((int)4000), "20210104", "04"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$10(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql("set hoodie.sql.insert.mode=strict");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName).append(" select 2, 'a2', 12, 1000").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            Dataset dataset;
            try {
                dataset = $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName).append(" select 1, 'a1', 10, 1000").toString());
            }
            catch (Exception e) {
                Throwable root = e;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                throw root;
            }
            return dataset;
        }, ClassTag$.MODULE$.apply(HoodieDuplicateKeyException.class), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        String tableName2 = $this.generateTableName();
        $this.spark().sql("set hoodie.datasource.write.insert.drop.duplicates = true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n           |create table ").append(tableName2).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName2).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName2).append(" select 1, 'a1', 10, 1000").toString());
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName2).append(" select 1, 'a1', 12, 1000").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql("set hoodie.datasource.write.insert.drop.duplicates = false");
        $this.spark().sql("set hoodie.sql.insert.mode=upsert");
    }

    public static final /* synthetic */ void $anonfun$new$13(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql("set hoodie.sql.insert.mode=strict");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(267).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(32).append("insert into ").append(tableName).append(" values(1, 'a1', 10)").toString());
        $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0)}))}));
        $this.spark().sql(new StringBuilder(31).append("insert into ").append(tableName).append(" select 2, 'a2', 12").toString());
        $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0)}))}));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            Dataset dataset;
            try {
                dataset = $this.spark().sql(new StringBuilder(31).append("insert into ").append(tableName).append(" select 1, 'a1', 10").toString());
            }
            catch (Exception e) {
                Throwable root = e;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                throw root;
            }
            return dataset;
        }, ClassTag$.MODULE$.apply(HoodieDuplicateKeyException.class), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        $this.spark().sql("set hoodie.sql.insert.mode=upsert");
    }

    public static final /* synthetic */ void $anonfun$new$16(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | tblproperties (primaryKey = 'id')\n           | partitioned by (dt)\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("\n           | insert overwrite table ").append(tableName).append("\n           | select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-01-05' as dt\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("\n           | insert overwrite table ").append(tableName).append("\n           | select 2 as id, 'a2' as name, 10 as price, 1000 as ts, '2021-01-06' as dt\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-06"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n           | insert overwrite table ").append(tableName).append(" partition(dt = '2021-01-05')\n           | select * from (select 2 , 'a2', 12, 1000) limit 10\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, ts, dt from ").append(tableName).append(" order by dt").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-06"}))}));
        String tblNonPartition = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(237).append("\n           | create table ").append(tblNonPartition).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           | ) using hudi\n           | tblproperties (primaryKey = 'id')\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tblNonPartition).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tblNonPartition).append(" select 1, 'a1', 10, 1000").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n           | insert overwrite table ").append(tableName).append(" partition(dt ='2021-01-04')\n           | select * from ").append(tblNonPartition).append(" limit 10\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(51).append("select id, name, price, ts, dt from ").append(tableName).append(" order by id,dt").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-04"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-06"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(120).append("\n           | insert overwrite table ").append(tableName).append("\n           | select id + 2, name, price, ts , '2021-01-04' from ").append(tblNonPartition).append(" limit 10\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(98).append("select id, name, price, ts, dt from ").append(tableName).append(" ").append("where dt >='2021-01-04' and dt <= '2021-01-06' order by id,dt").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-06"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-04"}))}));
        $this.spark().sql(new StringBuilder(48).append("insert overwrite table ").append(tblNonPartition).append(" select 2, 'a2', 10, 1000").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tblNonPartition).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$19(TestInsertTable $this, File tmp$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String partitionType = (String)tuple2._1();
        Object partitionValue = tuple2._2();
        String tableName = $this.generateTableName();
        $this.validateDifferentTypesOfPartitionColumn(tmp$1, partitionType, partitionValue, tableName);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$18(TestInsertTable $this, File tmp) {
        Seq typeAndValue = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"string", (Object)"'1000'"), new Tuple2((Object)"int", (Object)BoxesRunTime.boxToInteger((int)1000)), new Tuple2((Object)"bigint", (Object)BoxesRunTime.boxToInteger((int)10000)), new Tuple2((Object)"timestamp", (Object)"TIMESTAMP'2021-05-20 00:00:00'"), new Tuple2((Object)"date", (Object)"DATE'2021-05-20'")}));
        typeAndValue.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestInsertTable.$anonfun$new$19($this, tmp, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$22(TestInsertTable $this, File tmp$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String partitionType = (String)tuple2._1();
        String partitionValue = (String)tuple2._2();
        String tableName = $this.generateTableName();
        $this.spark().sql("set hoodie.datasource.write.keygenerator.consistent.logical.timestamp.enabled=true");
        $this.validateDifferentTypesOfPartitionColumn(tmp$2, partitionType, partitionValue, tableName);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$21(TestInsertTable $this, File tmp) {
        Seq typeAndValue = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"timestamp", (Object)"TIMESTAMP'2021-05-20 00:00:00'"), new Tuple2((Object)"date", (Object)"DATE'2021-05-20'")}));
        typeAndValue.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TestInsertTable.$anonfun$new$22($this, tmp, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$24(TestInsertTable $this, File tmp) {
        String tableName = new StringBuilder(2).append("H_").append($this.generateTableName()).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(209).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double\n           |) using hudi\n           | tblproperties (primaryKey = 'id')\n           | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(32).append("insert into ").append(tableName).append(" values(1, 'a1', 10)").toString());
        $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0)}))}));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tmp.getCanonicalPath()).setConf($this.spark().sessionState().newHadoopConf()).build();
        $this.assertResult(metaClient.getTableConfig().getTableName(), tableName, Prettifier$.MODULE$.default(), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
    }

    public static final /* synthetic */ void $anonfun$new$29(TestInsertTable $this, File tmp$3, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(346).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  dt string\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id'\n             | )\n             | partitioned by (dt)\n             | location '").append(tmp$3.getCanonicalPath()).append("/").append(tableName).append("'\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.datasource.write.insert.drop.duplicates = false");
        $this.spark().sql("set hoodie.sql.bulk.insert.enable = true");
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(1, 'a1', 10, '2021-07-18')").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18"}))}));
        $this.spark().sql("set hoodie.sql.bulk.insert.enable = false");
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(2, 'a2', 10, '2021-07-18')").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18"}))}));
        String tableMultiPartition = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(377).append("\n             |create table ").append(tableMultiPartition).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  dt string,\n             |  hh string\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id'\n             | )\n             | partitioned by (dt, hh)\n             | location '").append(tmp$3.getCanonicalPath()).append("/").append(tableMultiPartition).append("'\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.sql.bulk.insert.enable = true");
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableMultiPartition).append(" values(1, 'a1', 10, '2021-07-18', '12')").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, dt, hh from ").append(tableMultiPartition).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18", "12"}))}));
        $this.spark().sql("set hoodie.sql.bulk.insert.enable = false");
        $this.spark().sql(new StringBuilder(51).append("insert into ").append(tableMultiPartition).append(" ").append("values(2, 'a2', 10, '2021-07-18','12')").toString());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, dt, hh from ").append(tableMultiPartition).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18", "12"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18", "12"}))}));
        String nonPartitionedTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(284).append("\n             |create table ").append(nonPartitionedTable).append(" (\n             |  id int,\n             |  name string,\n             |  price double\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id'\n             | )\n             | location '").append(tmp$3.getCanonicalPath()).append("/").append(nonPartitionedTable).append("'\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.sql.bulk.insert.enable = true");
        $this.spark().sql(new StringBuilder(32).append("insert into ").append(nonPartitionedTable).append(" values(1, 'a1', 10)").toString());
        $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(nonPartitionedTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0)}))}));
        $this.spark().sql(new StringBuilder(43).append("insert overwrite table ").append(nonPartitionedTable).append(" values(2, 'a2', 10)").toString());
        $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(nonPartitionedTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0)}))}));
        $this.spark().sql("set hoodie.sql.bulk.insert.enable = false");
        String tableName2 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(248).append("\n             |create table ").append(tableName2).append("\n             |using hudi\n             |tblproperties(\n             | type = '").append(tableType).append("',\n             | primaryKey = 'id'\n             |)\n             | location '").append(tmp$3.getCanonicalPath()).append("/").append(tableName2).append("'\n             | as\n             | select * from ").append(tableName).append("\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, dt from ").append(tableName2).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), "2021-07-18"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$28(TestInsertTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestInsertTable.$anonfun$new$29($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$31(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(249).append("\n           |insert overwrite table ").append(tableName).append("\n           |select * from (\n           | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n           | union all\n           | select 1 as id, 'a1' as name, 11 as price, 1001 as ts\n           | )\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1001)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$33(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 11, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$35(TestInsertTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        String day = "2021-08-02";
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestInsertTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestInsertTable$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_TestInsertTable$$typecreator5$1(TestInsertTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)day, (Object)BoxesRunTime.boxToInteger((int)12))})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestInsertTable$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "day", "hh"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "day,hh").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD.key(), "true").mode(SaveMode.Overwrite).save(tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf($this.spark().sessionState().newHadoopConf()).build();
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)new TableSchemaResolver(metaClient).hasOperationField()), Prettifier$.MODULE$.default(), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(34).append("select id, _hoodie_operation from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null}))}));
    }

    public static final /* synthetic */ void $anonfun$new$38(TestInsertTable $this, String tableType$1, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(486).append("\n             | create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             | ) using hudi\n             | partitioned by (dt)\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  type = '").append(tableType$1).append("',\n             |  hoodie.datasource.write.drop.partition.columns = 'true'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(66).append("insert into ").append(tableName).append(" partition(dt='2021-12-25') values (1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(66).append("insert into ").append(tableName).append(" partition(dt='2021-12-25') values (2, 'a2', 20, 1000)").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-12-25"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)1000), "2021-12-25"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$41(TestInsertTable $this, File tmp$4, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(442).append("\n             |create table ").append(tableName).append(" (\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  nestedcol struct<a1:string, a2:struct<b1:string, b2:struct<c1:string, c2:int>>>\n             |) using hudi\n             | location '").append(tmp$4.getCanonicalPath()).append("/").append(tableName).append("'\n             | options (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'nestedcol.a1',\n             |  preCombineField = 'nestedcol.a2.b2.c2'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(193).append("insert into ").append(tableName).append(" values\n             |('name_1', 10, 1000, struct('a', struct('b', struct('c', 999)))),\n             |('name_2', 20, 2000, struct('a', struct('b', struct('c', 333))))\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(62).append("select name, price, ts, nestedcol.a1, nestedcol.a2.b2.c2 from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name_1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "a", BoxesRunTime.boxToInteger((int)999)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$40(TestInsertTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestInsertTable.$anonfun$new$41($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$44(TestInsertTable $this, String format$1, File tmp) {
        block0: {
            String tableName = new StringBuilder(22).append("spark_catalog.default.").append($this.generateTableName()).toString();
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_2()) break block0;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long,\n               |  dt string\n               |) using ").append(format$1).append("\n               | tblproperties (primaryKey = 'id')\n               | partitioned by (dt)\n               | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n               | insert into ").append(tableName).append("\n               | select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-01-05' as dt\n        ").toString())).stripMargin());
            $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"}))}));
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n               | insert into ").append(tableName).append(" partition(dt = '2021-01-05')\n               | select 2 as id, 'a2' as name, 10 as price, 1000 as ts\n        ").toString())).stripMargin());
            $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-01-05"}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$47(TestInsertTable $this, String tableType$2, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n             | create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             | ) using hudi\n             | partitioned by (dt)\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  type = '").append(tableType$2).append("'\n             | )\n        ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(66).append("insert into ").append(tableName).append(" partition(dt='2021-12-25') values (1, 'a1', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-12-25"}))}));
        $this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = false");
        $this.spark().sql(new StringBuilder(66).append("insert into ").append(tableName).append(" partition(dt='2021-12-25') values (1, 'a2', 20, 1001)").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)1001), "2021-12-25"}))}));
        $this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = true");
        $this.spark().sql(new StringBuilder(66).append("insert into ").append(tableName).append(" partition(dt='2021-12-25') values (1, 'a3', 30, 1002)").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)1001), "2021-12-25"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a3", BoxesRunTime.boxToInteger((int)30), BoxesRunTime.boxToInteger((int)1002), "2021-12-25"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$49(TestInsertTable $this, File basePath) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])BulkInsertSortMode.values())).foreach((Function1 & Serializable & scala.Serializable)sortMode -> {
            String tableName = $this.generateTableName();
            $this.spark().sessionState().conf().unsetConf("hoodie.datasource.write.operation");
            $this.spark().sessionState().conf().unsetConf("hoodie.datasource.write.insert.drop.duplicates");
            $this.spark().sessionState().conf().unsetConf("hoodie.merge.allow.duplicate.on.inserts");
            $this.spark().sessionState().conf().unsetConf("hoodie.datasource.write.keygenerator.consistent.logical.timestamp.enabled");
            String parallelism = sortMode.name().equals(BulkInsertSortMode.GLOBAL_SORT.name()) ? "hoodie.bulkinsert.shuffle.parallelism = 3," : "";
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(467).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  dt string\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'name',\n             |  type = 'cow',\n             |  ").append(parallelism).append("\n             |  hoodie.bulkinsert.sort.mode = '").append(sortMode.name()).append("'\n             | )\n             | partitioned by (dt)\n             | location '").append(basePath.getCanonicalPath()).append("/").append(tableName).append("'\n                ").toString())).stripMargin());
            $this.spark().sql("set hoodie.sql.bulk.insert.enable = true");
            $this.spark().sql("set hoodie.sql.insert.mode = non-strict");
            return $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(412).append("insert into ").append(tableName).append("  values\n             |(5, 'a', 35, '2021-05-21'),\n             |(1, 'a', 31, '2021-01-21'),\n             |(3, 'a', 33, '2021-03-21'),\n             |(4, 'b', 16, '2021-05-21'),\n             |(2, 'b', 18, '2021-01-21'),\n             |(6, 'b', 17, '2021-03-21'),\n             |(8, 'a', 21, '2021-05-21'),\n             |(9, 'a', 22, '2021-01-21'),\n             |(7, 'a', 23, '2021-03-21')\n             |").toString())).stripMargin());
        });
    }

    public TestInsertTable() {
        this.test("Test Insert Into with values", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("Test Insert Into with static partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("Test Insert Into with dynamic partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("Test Insert Into with multi partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("Test Insert Into None Partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("Test Insert Into None Partitioned Table strict mode with no preCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$13(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("Test Insert Overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$16(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("Test Different Type of Partition Column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        this.test("Test TimestampType Partition Column With Consistent Logical Timestamp Enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$21(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        this.test("Test insert for uppercase table name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$24(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
        this.test("Test Insert Exception", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n         |create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  dt string\n         |) using hudi\n         | tblproperties (primaryKey = 'id')\n         | partitioned by (dt)\n       ").toString())).stripMargin());
            this.checkExceptionContain(new StringBuilder(74).append("insert into ").append(tableName).append(" partition(dt = '2021-06-20') select 1, 'a1', 10, '2021-06-20'").toString(), new StringOps(Predef$.MODULE$.augmentString("\n        |too many data columns:\n        |Table columns: 'id', 'name', 'price'\n        |Data columns: '1', 'a1', '10', '2021-06-20'\n        |")).stripMargin());
            this.checkExceptionContain(new StringBuilder(31).append("insert into ").append(tableName).append(" select 1, 'a1', 10").toString(), new StringOps(Predef$.MODULE$.augmentString("\n        |not enough data columns:\n        |Table columns: 'id', 'name', 'price', 'dt'\n        |Data columns: '1', 'a1', '10'\n        |")).stripMargin());
            this.spark().sql("set hoodie.sql.bulk.insert.enable = true");
            this.spark().sql("set hoodie.sql.insert.mode = strict");
            String tableName2 = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(256).append("\n         |create table ").append(tableName2).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         |) using hudi\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkException(new StringBuilder(38).append("insert into ").append(tableName2).append(" values(1, 'a1', 10, 1000)").toString(), "Table with primaryKey can not use bulk insert in strict mode.");
            this.spark().sql("set hoodie.sql.insert.mode = non-strict");
            String tableName3 = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n         |create table ").append(tableName3).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  dt string\n         |) using hudi\n         | tblproperties (primaryKey = 'id')\n         | partitioned by (dt)\n       ").toString())).stripMargin());
            this.checkException(new StringBuilder(57).append("insert overwrite table ").append(tableName3).append(" values(1, 'a1', 10, '2021-07-18')").toString(), "Insert Overwrite Partition can not use bulk insert.");
            this.spark().sql("set hoodie.sql.bulk.insert.enable = false");
            return this.spark().sql("set hoodie.sql.insert.mode = upsert");
        }, new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        this.test("Test Insert timestamp when 'spark.sql.datetime.java8API.enabled' enables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            try {
                this.spark().conf().set("spark.sql.datetime.java8API.enabled", true);
                String tableName = this.generateTableName();
                this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(266).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  dt timestamp\n           |)\n           |using hudi\n           |partitioned by(dt)\n           |options(type = 'cow', primaryKey = 'id')\n           |").toString())).stripMargin());
                this.spark().sql(new StringBuilder(75).append("insert into ").append(tableName).append(" values (1, 'a1', 10, cast('2021-05-07 00:00:00' as timestamp))").toString());
                this.checkAnswer(new StringBuilder(48).append("select id, name, price, cast(dt as string) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-07 00:00:00"}))}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.spark().conf().set("spark.sql.datetime.java8API.enabled", false);
            }
            return boxedUnit;
        }, new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
        this.test("Test bulk insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("set hoodie.sql.insert.mode = non-strict");
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestInsertTable.$anonfun$new$28(this, tmp);
                return BoxedUnit.UNIT;
            });
            return this.spark().sql("set hoodie.sql.insert.mode = upsert");
        }, new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        this.test("Test combine before insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("set hoodie.sql.bulk.insert.enable = false");
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestInsertTable.$anonfun$new$31(this, tmp);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
        this.test("Test insert pk-table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("set hoodie.sql.bulk.insert.enable = false");
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestInsertTable.$anonfun$new$33(this, tmp);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        this.test("Test For read operation's field", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$35(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        this.test("Test enable hoodie.datasource.write.drop.partition.columns when write", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("set hoodie.sql.bulk.insert.enable = false");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mor", "cow"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                    TestInsertTable.$anonfun$new$38($this, tableType, tmp);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        this.test("Test nested field as primaryKey and preCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestInsertTable.$anonfun$new$40(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
        this.test("Test Insert Into With Catalog Identifier for spark >= 3.2.0", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hudi", "parquet"}))).foreach((Function1 & Serializable & scala.Serializable)format -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestInsertTable.$anonfun$new$44($this, format, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
        this.test("Test enable hoodie.merge.allow.duplicate.on.inserts when write", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("set hoodie.datasource.write.operation = insert");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mor", "cow"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                    TestInsertTable.$anonfun$new$47($this, tableType, tmp);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = false");
            return this.spark().sql("set hoodie.datasource.write.operation = upsert");
        }, new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
        this.test("Test Bulk Insert with all sort-modes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)basePath -> {
            TestInsertTable.$anonfun$new$49(this, basePath);
            return BoxedUnit.UNIT;
        }), new Position("TestInsertTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
    }
}

