/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0011B+Z:u\u001b\u0016\u0014x-Z%oi>$\u0016M\u00197f\u0015\t!Q!\u0001\u0003ik\u0012L'B\u0001\u0004\b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0011%\tQa\u001d9be.T!AC\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0011aA8sO\u000e\u00011C\u0001\u0001\u0010!\t\u0001\u0012#D\u0001\u0004\u0013\t\u00112A\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0011\u0001\u0001")
public class TestMergeIntoTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(367).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '1' as flag\n           | ) s0\n           | on s0.id = ").append(tableName).append(".id\n           | when matched and flag = '1' then update set\n           | id = s0.id, name = s0.name, price = s0.price, ts = s0.ts\n           | when not matched and flag = '1' then insert *\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(333).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1001 as ts\n           | ) s0\n           | on s0.id = ").append(tableName).append(".id\n           | when matched then update set\n           | id = s0.id, name = s0.name, price = s0.price + ").append(tableName).append(".price, ts = s0.ts\n           | when not matched then insert *\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(489).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select * from (\n           |  select 1 as id, 'a1' as name, 10 as price, 1002 as ts\n           |  union all\n           |  select 2 as id, 'a2' as name, 12 as price, 1001 as ts\n           |  )\n           | ) s0\n           | on s0.id = ").append(tableName).append(".id\n           | when matched then update set\n           | id = s0.id, name = s0.name, price = s0.price + ").append(tableName).append(".price, ts = s0.ts\n           | when not matched and s0.id % 2 = 0 then insert *\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(394).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1 as id, 'a1' as name, 12 as price, 1003 as ts\n           | ) s0\n           | on s0.id = ").append(tableName).append(".id\n           | when matched and s0.id != 1 then update set\n           |    id = s0.id, name = s0.name, price = s0.price, ts = s0.ts\n           | when matched and s0.id = 1 then delete\n           | when not matched then insert *\n       ").toString())).stripMargin());
        long cnt = $this.spark().sql(new StringBuilder(27).append("select * from ").append(tableName).append(" where id = 1").toString()).count();
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)cnt), Prettifier$.MODULE$.default(), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    public static final /* synthetic */ void $anonfun$new$4(TestMergeIntoTable $this, File tmp) {
        String sourceTable = $this.generateTableName();
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(193).append("\n           | create table ").append(sourceTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           | ) using parquet\n           | location '").append(tmp.getCanonicalPath()).append("/").append(sourceTable).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(targetTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(targetTable).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(2, 'a2', 11, 1000)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n           | merge into ").append(targetTable).append(" as t0\n           | using (select * from ").append(sourceTable).append(") as s0\n           | on t0.id = s0.id\n           | when matched then update set *\n           | when not matched and s0.name = 'a1' then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(targetTable).append(" select 3, 'a3', 12, 1000").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(557).append("\n           | merge into ").append(targetTable).append(" as t0\n           | using (\n           |  select * from (\n           |    select 1 as s_id, 'a1' as name, 20 as price, 1001 as ts\n           |    union all\n           |    select 3 as s_id, 'a3' as name, 20 as price, 1003 as ts\n           |    union all\n           |    select 4 as s_id, 'a4' as name, 10 as price, 1004 as ts\n           |  )\n           | ) s0\n           | on s0.s_id = t0.id\n           | when matched and s0.ts = 1001 then update set id = s0.s_id, name = t0.name, price =\n           | s0.price, ts = s0.ts\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$6(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 12 as price, 1001 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 0 then update set *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 12 as price, 1001 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 1 then update set *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 2 as id, 'a2' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 0 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(265).append("\n           | merge into ").append(tableName).append(" t0\n           | using (\n           |  select 2 as s_id, 'a2' as s_name, 15 as s_price, 1001 as s_ts, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id\n           | when matched and s_ts = 1001 then update set *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)15), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" t0\n           | using (\n           |  select 1 as s_id, 'a2' as s_name, 15 as s_price, 1001 as s_ts, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id + 1\n           | when matched and s_ts = 1001 then delete\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(330).append("\n           | create table ").append(tableName).append(" (\n           |  id bigint,\n           |  name string,\n           |  price double,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(45).append("insert into ").append(tableName).append(" select 1, 'a1', 10, '2021-03-21'").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 2 as id, 'a2' as name, 10 as price, 1000 as ts, '2021-03-20' as dt\n           | ) s0\n           | on s0.id = t0.id\n           | when not matched and s0.id % 2 = 0 then insert (id,name,price,dt)\n           | values(s0.id,s0.name,s0.price,s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), "2021-03-20"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 3 as id, 'a3' as name, 10 as price, 1000 as ts, '2021-03-20' as dt\n           | ) s0\n           | on s0.id = t0.id\n           | when not matched and s0.id % 2 = 0 then insert (id,name,price,dt)\n           | values(s0.id,s0.name,s0.price,s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), "2021-03-20"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$11(TestMergeIntoTable $this, File tmp$1, String tableType) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(521).append("\n             | create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  v long,\n             |  dt string\n             | ) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'v',\n             |  hoodie.compaction.payload.class = 'org.apache.hudi.common.model.DefaultHoodieRecordPayload'\n             | )\n             | partitioned by(dt)\n             | location '").append(tmp$1.getCanonicalPath()).append("/").append(tableName1).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 10 as price, 1001 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21", BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 11 as price, 1000 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when matched and s0.id % 2 = 1 then update set *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21", BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 12 as price, 1002 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when matched and s0.id % 2 = 1 then update set *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21", BoxesRunTime.boxToInteger((int)1002)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$10(TestMergeIntoTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable.$anonfun$new$11($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$14(TestMergeIntoTable $this, File tmp$2, String tableType) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(412).append("\n             | create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  v long,\n             |  dt string\n             | ) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'v'\n             | )\n             | partitioned by(dt)\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName1).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000, '2021-03-21')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 11 as price, 999 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when matched then update set id=s0.id, name=s0.name, price=s0.price*2, v=s0.v+2, dt=s0.dt\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)22), "2021-03-21", BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(333).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as s_id, 'a1' as s_name, 12 as s_price, 1000 as s_v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.s_id\n             | when matched then update set id=s0.s_id, name=s0.s_name, price=s0.s_price*2, v=s0.s_v+2, dt=s0.dt\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)24), "2021-03-21", BoxesRunTime.boxToInteger((int)1002)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$13(TestMergeIntoTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable.$anonfun$new$14($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$16(TestMergeIntoTable $this, File tmp) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(387).append("\n           | create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  v long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'v'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(3, 'a3', 30, 3000, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(2, 'a2', 20, 2000, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000, '2021-03-21')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(236).append("\n           | merge into ").append(tableName1).append(" t0\n           | using (\n           |  select 1 as id, 'a1' as name, 15 as price, 1001 as v, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.id + 1\n           | when matched then delete\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(43).append("select id,name,price,v,dt from ").append(tableName1).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToInteger((int)30), BoxesRunTime.boxToInteger((int)3000), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n           | merge into ").append(tableName1).append(" t0\n           | using (\n           |  select 2 as s_id, 'a1' as s_name, 15 as s_price, 1001 as s_v, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id + 1\n           | when matched then delete\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(43).append("select id,name,price,v,dt from ").append(tableName1).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$18(TestMergeIntoTable $this, File tmp) {
        String sourceTable = $this.generateTableName();
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(218).append("\n           | create table ").append(sourceTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using parquet\n           | location '").append(tmp.getCanonicalPath()).append("/").append(sourceTable).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(sourceTable).append(" values(8, 's8', 80, 2008, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(sourceTable).append(" values(9, 's9', 90, 2009, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(sourceTable).append(" values(10, 's10', 100, 2010, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(sourceTable).append(" values(11, 's11', 110, 2011, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(sourceTable).append(" values(12, 's12', 120, 2012, '2021-03-21')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("\n           |create table ").append(targetTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("/").append(targetTable).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(targetTable).append(" values(7, 'a7', 70, 1007, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(targetTable).append(" values(8, 'a8', 80, 1008, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(targetTable).append(" values(9, 'a9', 90, 1009, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(targetTable).append(" values(10, 'a10', 100, 1010, '2021-03-21')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(312).append("\n           | merge into ").append(targetTable).append(" as t0\n           | using ").append(sourceTable).append(" as s0\n           | on t0.id = s0.id\n           | when matched and id = 10 then delete\n           | when matched and id < 10 then update set name='sxx', price=s0.price*2, ts=s0.ts+10000, dt=s0.dt\n           | when not matched and id > 10 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(44).append("select id,name,price,ts,dt from ").append(targetTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", BoxesRunTime.boxToInteger((int)70), BoxesRunTime.boxToInteger((int)1007), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "sxx", BoxesRunTime.boxToInteger((int)160), BoxesRunTime.boxToInteger((int)12008), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "sxx", BoxesRunTime.boxToInteger((int)180), BoxesRunTime.boxToInteger((int)12009), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), "s11", BoxesRunTime.boxToInteger((int)110), BoxesRunTime.boxToInteger((int)2011), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), "s12", BoxesRunTime.boxToInteger((int)120), BoxesRunTime.boxToInteger((int)2012), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$21(TestMergeIntoTable $this, File tmp$3, String tableType) {
        String sourceTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(342).append("\n             |create table ").append(sourceTable).append(" (\n             | id int,\n             | name string,\n             | price double,\n             | _ts long\n             |) using hudi\n             |tblproperties(\n             | type ='").append(tableType).append("',\n             | primaryKey = 'id',\n             | preCombineField = '_ts'\n             |)\n             |location '").append(tmp$3.getCanonicalPath()).append("/").append(sourceTable).append("'\n          ").toString())).stripMargin());
        String targetTable = $this.generateTableName();
        String targetBasePath = new StringBuilder(1).append(tmp$3.getCanonicalPath()).append("/").append(targetTable).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n             |create table ").append(targetTable).append(" (\n             | id int,\n             | name string,\n             | price double,\n             | _ts long\n             |) using hudi\n             |tblproperties(\n             | type ='").append(tableType).append("',\n             | primaryKey = 'id',\n             | preCombineField = '_ts'\n             |)\n             |location '").append(targetBasePath).append("'\n          ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("\n             |merge into ").append(targetTable).append(" t0\n             |using ").append(sourceTable).append(" s0\n             |on t0.id = s0.id\n             |when not matched then insert *\n          ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(33).append("select id, name, price, _ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        FileSystem fs = FSUtils.getFs((String)targetBasePath, (Configuration)$this.spark().sessionState().newHadoopConf());
        String firstCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)targetBasePath);
        $this.spark().sql(new StringBuilder(47).append("update ").append(sourceTable).append(" set price = 12, _ts = 1001 where id = 1").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n             |merge into ").append(targetTable).append(" t0\n             |using ").append(sourceTable).append(" s0\n             |on t0.id = s0.id\n             |when matched and cast(s0._ts as string) > '1000' then update set *\n           ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(33).append("select id, name, price, _ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001)}))}));
        Dataset hudiIncDF1 = $this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), firstCommitTime).load(targetBasePath);
        hudiIncDF1.createOrReplaceTempView("inc1");
        $this.checkAnswer("select id, name, price, _ts from inc1", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        String secondCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)targetBasePath);
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("\n             |merge into ").append(targetTable).append(" t0\n             |using ").append(sourceTable).append(" s0\n             |on t0.id = s0.id\n             |when matched then update set *\n             |when not matched and s0.name = 'a2' then insert *\n           ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(45).append("select id, name, price, _ts from ").append(targetTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1001)}))}));
        Dataset hudiIncDF2 = $this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), secondCommitTime).load(targetBasePath);
        hudiIncDF2.createOrReplaceTempView("inc2");
        $this.checkAnswer("select id, name, price, _ts from inc2 order by id", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1001)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$20(TestMergeIntoTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable.$anonfun$new$21($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$24(TestMergeIntoTable $this, File tmp$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dataType = (String)tuple2._1();
        Object dataValue = tuple2._2();
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(315).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  c ").append(dataType).append("\n             |) using hudi\n             | location '").append(tmp$4.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey ='id',\n             |  preCombineField = 'c'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(378).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 1 as id, 'a1' as name, 10 as price, ").append(dataValue).append(" as c0, '1' as flag\n             | ) s0\n             | on s0.id = ").append(tableName).append(".id\n             | when matched and flag = '1' then update set\n             | id = s0.id, name = s0.name, price = s0.price, c = s0.c0\n             | when not matched and flag = '1' then insert *\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(342).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 1 as id, 'a1' as name, 10 as price, ").append(dataValue).append(" as c\n             | ) s0\n             | on s0.id = ").append(tableName).append(".id\n             | when matched then update set\n             | id = s0.id, name = s0.name, price = s0.price + ").append(tableName).append(".price, c = s0.c\n             | when not matched then insert *\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0)}))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$23(TestMergeIntoTable $this, File tmp) {
        Seq typeAndValue = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"string", (Object)"'1000'"), new Tuple2((Object)"int", (Object)BoxesRunTime.boxToInteger((int)1000)), new Tuple2((Object)"bigint", (Object)BoxesRunTime.boxToInteger((int)10000)), new Tuple2((Object)"timestamp", (Object)"'2021-05-20 00:00:00'"), new Tuple2((Object)"date", (Object)"'2021-05-20'")}));
        typeAndValue.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestMergeIntoTable.$anonfun$new$24($this, tmp, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$26(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(372).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts',\n           |  hoodie.compact.inline = 'true'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           | select 4 as id, 'a4' as name, 11 as price, 1000 as ts\n           | ) s0\n           | on h0.id = s0.id\n           | when matched then update set *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$29(TestMergeIntoTable $this, File tmp$5, String dataType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(315).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  value ").append(dataType).append(",\n             |  ts long\n             |) using hudi\n             | location '").append(tmp$5.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey ='id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(245).append("\n             |merge into ").append(tableName).append(" h0\n             |using (\n             | select 1 as id, 'a1' as name, cast(null as ").append(dataType).append(") as value, 1000 as ts\n             | ) s0\n             | on h0.id = s0.id\n             | when not matched then insert *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", null, BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$28(TestMergeIntoTable $this, File tmp) {
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "int", "bigint", "double", "float", "timestamp", "date", "decimal"}));
        types.foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            TestMergeIntoTable.$anonfun$new$29($this, tmp, dataType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$32(TestMergeIntoTable $this, File tmp$6, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dataType = (String)tuple2._1();
        String dataValue = (String)tuple2._2();
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(315).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  value ").append(dataType).append(",\n             |  ts long\n             |) using hudi\n             | location '").append(tmp$6.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey ='id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(241).append("\n             |merge into ").append(tableName).append(" h0\n             |using (\n             | select 1 as id, 'a1' as name, cast(").append(dataValue).append(" as ").append(dataType).append(") as value, 1000 as ts\n             | ) s0\n             | on h0.id = s0.id\n             | when not matched then insert *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, cast(value as string), ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", $this.extractRawValue(dataValue), BoxesRunTime.boxToInteger((int)1000)}))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$31(TestMergeIntoTable $this, File tmp) {
        Seq dataAndTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"string", (Object)"'a1'"), new Tuple2((Object)"int", (Object)"10"), new Tuple2((Object)"bigint", (Object)"10"), new Tuple2((Object)"double", (Object)"10.0"), new Tuple2((Object)"float", (Object)"10.0"), new Tuple2((Object)"decimal(5,2)", (Object)"10.11"), new Tuple2((Object)"decimal(5,0)", (Object)"10"), new Tuple2((Object)"timestamp", (Object)"'2021-05-20 00:00:00'"), new Tuple2((Object)"date", (Object)"'2021-05-20'")}));
        dataAndTypes.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TestMergeIntoTable.$anonfun$new$32($this, tmp, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$34(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(296).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  value int,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(204).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           | select 1 as id, 1001 as ts\n           | ) s0\n           | on h0.id = s0.id\n           | when matched then update set h0.ts = s0.ts\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1001)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$36(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(296).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  value int,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        String errorMsg = HoodieSparkUtils$.MODULE$.gteqSpark3_2() ? "Invalid MERGE INTO matching condition: s0.id: can't cast s0.id (of LongType) to IntegerType" : "Invalid MERGE INTO matching condition: s0.`id`: can't cast s0.`id` (of LongType) to IntegerType";
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(233).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |  select cast(1 as long) as id, 1001 as ts\n           | ) s0\n           | on cast(h0.id as long) = s0.id\n           | when matched then update set h0.ts = s0.ts\n           |").toString())).stripMargin(), errorMsg);
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |  select cast(1 as long) as id, 1002 as ts\n           | ) s0\n           | on h0.id = s0.id\n           | when matched then update set h0.ts = s0.ts\n           |").toString())).stripMargin(), errorMsg);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |  select cast(1 as short) as id, 1003 as ts\n           | ) s0\n           | on h0.id = s0.id\n           | when matched then update set h0.ts = s0.ts\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1003)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(250).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |  select cast(1 as int) as id, 1004 as ts\n           | ) s0\n           | on cast(h0.id as string) = cast(s0.id as string)\n           | when matched then update set h0.ts = s0.ts\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1004)}))}));
    }

    public TestMergeIntoTable() {
        this.test("Test MergeInto Basic", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("Test MergeInto with ignored record", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("Test MergeInto for MOR table ", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("Test MergeInto with insert only", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        this.test("Test MergeInto For PreCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("Test MergeInto with preCombine field expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$13(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        this.test("Test MergeInto with primaryKey expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$16(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("Test MergeInto with combination of delete update insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        this.test("Merge Hudi to Hudi", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$20(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        this.test("Test Different Type of PreCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$23(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        this.test("Test MergeInto For MOR With Compaction On", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$26(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        this.test("Test MereInto With Null Fields", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$28(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
        this.test("Test MergeInto With All Kinds Of DataType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$31(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
        this.test("Test MergeInto with no-full fields source", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$34(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
        this.test("Test Merge Into with target matched columns cast-ed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$36(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 953));
    }
}

