/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0019B+Z:u\u001b\u0016\u0014x-Z%oi>$\u0016M\u00197fe)\u0011A!B\u0001\u0005QV$\u0017N\u0003\u0002\u0007\u000f\u0005\u00191/\u001d7\u000b\u0005!I\u0011!B:qCJ\\'B\u0001\u0006\f\u0003\u0019\t\u0007/Y2iK*\tA\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001#E\u0007\u0002\u0007%\u0011!c\u0001\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0006\t\u0003!\u0001\u0001")
public class TestMergeIntoTable2
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 2 as id, 'a2' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 0 then update set *\n           | when matched and s0.id % 3 = 2 then delete\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(459).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 1 then update set id = s0.id, name = s0.name,\n           |  price = s0.price * 2, ts = s0.ts, dt = s0.dt\n           | when not matched then insert (id,name,price,ts,dt) values(s0.id, s0.name, s0.price, s0.ts, s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)22), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(515).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 0 then update set id = s0.id, name = s0.name,\n           |  price = s0.price * 2, ts = s0.ts, dt = s0.dt\n           | when matched and s0.id % 2 = 1 then delete\n           | when not matched then insert (id,name,price,ts,dt) values(s0.id, s0.name, s0.price, s0.ts, s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(21).append("select count(1) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(355).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 1 then update set id = s0.id, name = s0.name,\n           |  price = s0.price + t0.price, ts = s0.ts, dt = s0.dt\n         ").toString())).stripMargin(), "assertion failed: Target table's field(price) cannot be the right-value of the update clause for MOR table.");
    }

    public static final /* synthetic */ void $anonfun$new$4(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(175).append("\n           |create table ").append(tableName).append(" using hudi\n           |tblproperties(primaryKey = 'id')\n           |location '").append(tmp.getCanonicalPath()).append("'\n           |as\n           |select 1 as id, 'a1' as name\n           |").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tmp.getCanonicalPath()).setConf($this.spark().sessionState().newHadoopConf()).build();
        $this.assertResult("id", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metaClient.getTableConfig().getRecordKeyFields().get())).mkString(","), Prettifier$.MODULE$.default(), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           | select 1 as s_id, 'a1_1' as name\n           |) s0\n           |on h0.id = s0.s_id\n           |when matched then update set *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(21).append("select id, name from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_1"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$6(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(434).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  s_value struct<f0: int, f1: string>,\n           |  a_value array<string>,\n           |  m_value map<string, string>,\n           |  ts long\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(374).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |select\n           |  1 as id,\n           |  'a1' as name,\n           |  struct(1, '10') as s_value,\n           |  split('a0,a1', ',') as a_value,\n           |  map('k0', 'v0') as m_value,\n           |  1000 as ts\n           |) s0\n           |on h0.id = s0.id\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(52).append("select id, name, s_value, a_value, m_value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "10"})), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a0", "a1"})), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k0"), (Object)"v0")})), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(420).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |select\n           |  1 as id,\n           |  'a1' as name,\n           |  struct(1, '12') as s_value,\n           |  split('a0,a1,a2', ',') as a_value,\n           |  map('k1', 'v1') as m_value,\n           |  1000 as ts\n           |) s0\n           |on h0.id = s0.id\n           |when matched then update set *\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(52).append("select id, name, s_value, a_value, m_value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "12"})), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a0", "a1", "a2"})), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)"v1")})), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(324).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(48).append("insert into ").append(tableName).append(" select 1, 'a1', 1, 10, '2021-03-21'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(483).append("\n           |merge into ").append(tableName).append(" as t0\n           |using (\n           |  select 1 as id, '2021-05-05' as dt, 1002 as ts, 97 as price, 'a1' as name union all\n           |  select 1 as id, '2021-05-05' as dt, 1003 as ts, 98 as price, 'a2' as name union all\n           |  select 2 as id, '2021-05-05' as dt, 1001 as ts, 99 as price, 'a3' as name\n           | ) as s0\n           |on t0.id = s0.id\n           |when matched then update set *\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)98.0), BoxesRunTime.boxToInteger((int)1003), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a3", BoxesRunTime.boxToDouble((double)99.0), BoxesRunTime.boxToInteger((int)1001), "2021-05-05"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(486).append("\n           |merge into ").append(tableName).append(" as t0\n           |using (\n           |  select 1 as id, 'a1' as name, 1004 as ts, '2021-05-05' as dt, 100 as price union all\n           |  select 2 as id, 'a5' as name, 1000 as ts, '2021-05-05' as dt, 101 as price union all\n           |  select 3 as id, 'a3' as name, 1000 as ts, '2021-05-05' as dt, 102 as price\n           | ) as s0\n           |on t0.id = s0.id\n           |when matched then update set *\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)100.0), BoxesRunTime.boxToInteger((int)1004), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a3", BoxesRunTime.boxToDouble((double)99.0), BoxesRunTime.boxToInteger((int)1001), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)102.0), BoxesRunTime.boxToInteger((int)1000), "2021-05-05"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(443).append("\n           |merge into ").append(tableName).append(" as t0\n           |using (\n           |  select 1 as id, 'a6' as name, 1006 as ts, '2021-05-05' as dt, 106 as price, '0' as flag union all\n           |  select 4 as id, 'a4' as name, 1000 as ts, '2021-05-06' as dt, 100 as price, '1' as flag\n           | ) as s0\n           |on t0.id = s0.id\n           |when matched and flag = '1' then update set *\n           |when not matched and flag = '1' then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)100.0), BoxesRunTime.boxToInteger((int)1004), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a3", BoxesRunTime.boxToDouble((double)99.0), BoxesRunTime.boxToInteger((int)1001), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)102.0), BoxesRunTime.boxToInteger((int)1000), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)100.0), BoxesRunTime.boxToInteger((int)1000), "2021-05-06"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$10(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        String mergeSql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1, 'a1', 10, 1000, '1'\n           | ) s0(id,name,price,ts,flag)\n           | on s0.id = ").append(tableName).append(".id\n           | when matched and flag = '1' then update set\n           | id = s0.id, name = s0.name, price = s0.price, ts = s0.ts\n           | when not matched and flag = '1' then insert *\n           |").toString())).stripMargin();
        if (HoodieSparkUtils$.MODULE$.isSpark3()) {
            $this.checkExceptionContain(mergeSql, "Columns aliases are not allowed in MERGE");
        } else {
            $this.spark().sql(mergeSql);
            $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$12(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(372).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1 as ID, 'a1' as NAME, 10 as PRICE, 1000 as TS, '1' as FLAG\n           | ) s0\n           | on s0.ID = ").append(tableName).append(".id\n           | when matched and FLAG = '1' then update set\n           | id = s0.ID, name = s0.NAME, price = s0.PRICE, ts = s0.TS\n           | when not matched and FLAG = '1' then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(372).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1 as ID, 'a1' as NAME, 11 as PRICE, 1001 as TS, '1' as FLAG\n           | ) s0\n           | on s0.id = ").append(tableName).append(".id\n           | when matched and FLAG = '1' then update set\n           | id = s0.id, name = s0.NAME, price = s0.PRICE, ts = s0.ts\n           | when not matched and FLAG = '1' then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(385).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 2 as ID, 'a2' as NAME, 12 as PRICE, 1002 as TS, '1' as FLAG\n           | ) s0\n           | on cast(s0.id as int) = ").append(tableName).append(".id\n           | when matched and FLAG = '1' then update set\n           | id = s0.id, name = s0.NAME, price = s0.PRICE, ts = s0.ts\n           | when not matched and FLAG = '1' then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1002)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$14(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(318).append("\n           |create table ").append(tableName).append(" (\n           |  ID int,\n           |  name string,\n           |  price double,\n           |  TS long,\n           |  DT string\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | options (\n           |  primaryKey ='ID',\n           |  preCombineField = 'TS'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(399).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as PRICE, 1000 as ts, '2021-05-05' as dt, '1' as flag\n           | ) s0\n           | on s0.id = ").append(tableName).append(".id\n           | when matched and flag = '1' then update set\n           | id = s0.id, name = s0.name, PRICE = s0.price, ts = s0.ts, dt = s0.dt\n           | when not matched and flag = '1' then insert *\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-05-05"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1 as id, 'a1' as name, 20 as PRICE, '2021-05-05' as dt, 1001 as ts\n           | ) s0\n           | on s0.id = ").append(tableName).append(".id\n           | when matched then update set\n           | id = s0.id, name = s0.name, PRICE = s0.price, ts = s0.ts, dt = s0.dt\n           | when not matched then insert *\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1001), "2021-05-05"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(392).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 1111 as ts, '2021-05-05' as dt, 111 as PRICE union all\n           |  select 2 as id, 'a2' as name, 1112 as ts, '2021-05-05' as dt, 112 as PRICE\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched then update set *\n           | when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)111.0), BoxesRunTime.boxToInteger((int)1111), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)112.0), BoxesRunTime.boxToInteger((int)1112), "2021-05-05"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$16(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(383).append("\n           | create table ").append(tableName).append(" (\n           |  ID int,\n           |  NAME string,\n           |  price double,\n           |  TS long,\n           |  dt string\n           | ) using hudi\n           | options (\n           |  type = 'mor',\n           |  primaryKey = 'ID',\n           |  preCombineField = 'TS'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as NAME, 1111 as ts, '2021-05-05' as DT, 111 as price\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched then update set *\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)111.0), BoxesRunTime.boxToInteger((int)1111), "2021-05-05"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$18(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(324).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(48).append("insert into ").append(tableName).append(" select 1, 'a1', 1, 10, '2022-08-18'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 110 as ts, '2022-08-19' as dt union all\n           |  select 2 as id, 'a2' as name, 10 as price, 100 as ts, '2022-08-18' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)100), "2022-08-18"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$20(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(353).append("\n           |create table ").append(tableName).append(" (\n           |  id1 int,\n           |  id2 int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id1,id2',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(51).append("insert into ").append(tableName).append(" select 1, 1, 'a1', 1, 10, '2022-08-18'").toString());
        $this.checkAnswer(new StringBuilder(42).append("select id1, id2, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(365).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id1, 1 as id2, 'a1' as name, 11 as price, 110 as ts, '2022-08-19' as dt union all\n           |  select 1 as id1, 2 as id2, 'a2' as name, 10 as price, 100 as ts, '2022-08-18' as dt\n           | ) as s0\n           | on t0.id1 = s0.id1\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(42).append("select id1, id2, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)100), "2022-08-18"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$22(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 'a1' as name, 1 as id, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$24(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(68).append("insert into ").append(tableName).append(" select 1, 'a1', cast(10.0 as double), 999, '2021-03-21'").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 'a1' as name, 1 as id, '10.1' as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched then update set t0.price = s0.price, t0.ts = s0.ts\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.1), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$26(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(403).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           | ) using hudi\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  hoodie.datasource.write.payload.class = 'org.apache.hudi.common.model.DefaultHoodieRecordPayload'\n           | ) location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(32).append("insert into ").append(tableName).append(" select 1, 'a1', 999").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 'a2' as name, 1 as id, 1000 as ts\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched then update set t0.name = s0.name, t0.ts = s0.ts\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(23).append("select id,name,ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$29(TestMergeIntoTable2 $this, String tableType$1, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(441).append("\n               | create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long,\n               |  dt string\n               | ) using hudi\n               | tblproperties (\n               |  type = '").append(tableType$1).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n               | partitioned by(dt)\n               | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(393).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 1 as id, 'a1' as name, 10.1 as price, 1000 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 1 as id, 'a2' as name, 10.2 as price, 1002 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.2), BoxesRunTime.boxToInteger((int)1002), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(567).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 1 as id, 'a1_new' as name, 10.1 as price, 1003 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 3 as id, 'a3' as name, 10.3 as price, 1003 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 3 as id, 'a3' as name, 10.3 as price, 1003 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when matched then update set *\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_new", BoxesRunTime.boxToDouble((double)10.1), BoxesRunTime.boxToInteger((int)1003), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.3), BoxesRunTime.boxToInteger((int)1003), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$32(TestMergeIntoTable2 $this, String tableType$2, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(399).append("\n               | create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long,\n               |  dt string\n               | ) using hudi\n               | tblproperties (\n               |  type = '").append(tableType$2).append("',\n               |  primaryKey = 'id'\n               | )\n               | partitioned by(dt)\n               | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(393).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 1 as id, 'a1' as name, 10.1 as price, 1000 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 1 as id, 'a2' as name, 10.2 as price, 1002 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.1), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.2), BoxesRunTime.boxToInteger((int)1002), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(441).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 3 as id, 'a3' as name, 10.3 as price, 1003 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 1 as id, 'a2' as name, 10.2 as price, 1002 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when matched then update set *\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.1), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.2), BoxesRunTime.boxToInteger((int)1002), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.3), BoxesRunTime.boxToInteger((int)1003), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.2), BoxesRunTime.boxToInteger((int)1002), "2021-03-21"}))}));
    }

    public TestMergeIntoTable2() {
        this.test("Test MergeInto for MOR table 2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("Test Merge Into CTAS Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("Test Merge With Complex Data Type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("Test column name matching for insert * and update set *", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("Test MergeInto For Source Table With Column Aliases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("Test MergeInto When PrimaryKey And PreCombineField Of Source Table And Target Table Differ In Case Only", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$12(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        this.test("Test ignoring case", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$14(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        this.test("Test ignoring case for MOR table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$16(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        this.test("Test only insert when source table contains history", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
        this.test("Test only insert when source table contains history and target table has multiple keys", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$20(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
        this.test("Test Merge Into For Source Table With Different Column Order", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        this.test("Test Merge into with String cast to Double", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$24(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        this.test("Test Merge into where manually set DefaultHoodieRecordPayload", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$26(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        this.test("Test only insert for source table in dup key with preCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable2.$anonfun$new$29($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        this.test("Test only insert for source table in dup key without preCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable2.$anonfun$new$32($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
    }
}

