/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.RowDataSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00014AAB\u0004\u0001%!)A\u0004\u0001C\u0001;!)q\u0004\u0001C\u0005A!)!\b\u0001C\u0005w!)1\t\u0001C\u0005\t\"9A\u000bAI\u0001\n\u0013)&a\t+fgRtUm\u001d;fIN\u001b\u0007.Z7b!J,h.\u001b8h\u001fB$\u0018.\\5{CRLwN\u001c\u0006\u0003\u0011%\tA\u0001[;eS*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\f\u0011\u0005Q)R\"A\u0004\n\u0005Y9!A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0011\u0005aQR\"A\r\u000b\u0005!i\u0011BA\u000e\u001a\u0005M\u0019\u0006/\u0019:l\u0003\u0012\f\u0007\u000f^3s'V\u0004\bo\u001c:u\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u0015\u0001\u00059Q\r\u001f9mC&tGCA\u0011/!\t\u00113F\u0004\u0002$SA\u0011AeJ\u0007\u0002K)\u0011a%E\u0001\u0007yI|w\u000e\u001e \u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003U\u001dBQa\f\u0002A\u0002A\nA\u0001\u001d7b]B\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\bY><\u0017nY1m\u0015\t)d'A\u0003qY\u0006t7O\u0003\u00028\u0013\u0005A1-\u0019;bYf\u001cH/\u0003\u0002:e\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0003-)\u00070Z2vi\u0016\u0004F.\u00198\u0015\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$BA \n\u0003%)\u00070Z2vi&|g.\u0003\u0002B}\tI1\u000b]1sWBc\u0017M\u001c\u0005\u0006_\r\u0001\r\u0001M\u0001\"GJ,\u0017\r^3UC\ndWmV5uQ:+7\u000f^3e'R\u0014Xo\u0019;TG\",W.\u0019\u000b\u0006\u000b&[Uj\u0014\t\u0003\r\u001ek\u0011aJ\u0005\u0003\u0011\u001e\u0012A!\u00168ji\")!\n\u0002a\u0001C\u0005IA/\u00192mKRK\b/\u001a\u0005\u0006\u0019\u0012\u0001\r!I\u0001\ni\u0006\u0014G.\u001a(b[\u0016DQA\u0014\u0003A\u0002\u0005\n\u0011\u0002^1cY\u0016\u0004\u0016\r\u001e5\t\u000fA#\u0001\u0013!a\u0001#\u0006!q\u000e\u001d;t!\u0011\u0011#+I\u0011\n\u0005Mk#aA'ba\u0006Y3M]3bi\u0016$\u0016M\u00197f/&$\bNT3ti\u0016$7\u000b\u001e:vGR\u001c6\r[3nC\u0012\"WMZ1vYR$C'F\u0001WU\t\tvkK\u0001Y!\tIf,D\u0001[\u0015\tYF,A\u0005v]\u000eDWmY6fI*\u0011QlJ\u0001\u000bC:tw\u000e^1uS>t\u0017BA0[\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TestNestedSchemaPruningOptimization
extends HoodieSparkSqlTestBase
implements SparkAdapterSupport {
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    private SparkAdapter sparkAdapter$lzycompute() {
        TestNestedSchemaPruningOptimization testNestedSchemaPruningOptimization = this;
        synchronized (testNestedSchemaPruningOptimization) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private String explain(LogicalPlan plan) {
        LogicalPlan explainCommand = this.sparkAdapter().getCatalystPlanUtils().createExplainCommand(plan, true);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.executePlan(explainCommand).executeCollect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    private SparkPlan executePlan(LogicalPlan plan) {
        return this.spark().sessionState().executePlan(plan).executedPlan();
    }

    private void createTableWithNestedStructSchema(String tableType, String tableName, String tablePath, Map<String, String> opts) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(342).append("\n         |CREATE TABLE ").append(tableName).append(" USING HUDI TBLPROPERTIES (\n         |  type = '").append(tableType).append("',\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts',\n         |  hoodie.populate.meta.fields = 'true'\n         |  ").append((Object)(opts.nonEmpty() ? new StringBuilder(1).append(",").append(((TraversableOnce)opts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(7).append("'").append(k).append("' = '").append(v).append("'").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).toString() : "")).append("\n         |)\n         |LOCATION '").append(tablePath).append("'\n         |AS SELECT 1 AS id, named_struct('name', 'a1', 'price', 10) AS item, 123456 AS ts\n             ").toString())).stripMargin());
    }

    private Map<String, String> createTableWithNestedStructSchema$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ long $anonfun$new$3(TestNestedSchemaPruningOptimization $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString();
        $this.createTableWithNestedStructSchema(tableType, tableName, tablePath, $this.createTableWithNestedStructSchema$default$4());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set ts = 234567 where id = 1").toString());
        Dataset selectDF = $this.spark().sql(new StringBuilder(26).append("SELECT id, item.name FROM ").append(tableName).toString());
        StructType expectedSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("item", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false, StructField$.MODULE$.apply$default$4())})));
        String expectedReadSchemaClause = "ReadSchema: struct<id:int,item:struct<name:string>>";
        String hint = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(615).append("\n               |Following is expected to be present in the plan (where ReadSchema has properly pruned nested structs, which\n               |is an optimization performed by NestedSchemaPruning rule):\n               |\n               |== Physical Plan ==\n               |*(1) Project [id#45, item#46.name AS name#55]\n               |+- FileScan parquet default.h0[id#45,item#46] Batched: false, DataFilters: [], Format: Parquet, Location: HoodieFileIndex(1 paths)[file:/private/var/folders/kb/cnff55vj041g2nnlzs5ylqk00000gn/T/spark-7137..., PartitionFilters: [], PushedFilters: [], ").append(expectedReadSchemaClause).append("\n               |]\n               |").toString())).stripMargin();
        $this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        boolean bl = false;
        ProjectExec projectExec = null;
        SparkPlan sparkPlan = selectDF.queryExecution().executedPlan();
        if (sparkPlan instanceof ProjectExec) {
            bl = true;
            projectExec = (ProjectExec)sparkPlan;
            SparkPlan fileScan = projectExec.child();
            if (fileScan instanceof FileSourceScanExec) {
                FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)fileScan;
                Option tableIdentifier = fileSourceScanExec.tableIdentifier();
                StructType requiredSchema = fileSourceScanExec.requiredSchema();
                Assertions.assertEquals((Object)tableName, (Object)((TableIdentifier)tableIdentifier.get()).table());
                Assertions.assertEquals((Object)expectedSchema, (Object)requiredSchema, (String)hint);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return selectDF.count();
            }
        }
        if (!bl) throw new MatchError((Object)sparkPlan);
        SparkPlan dataScan = projectExec.child();
        if (!(dataScan instanceof RowDataSourceScanExec)) throw new MatchError((Object)sparkPlan);
        String explainedPlan = $this.explain(selectDF.queryExecution().logical());
        Assertions.assertTrue((boolean)explainedPlan.contains(expectedReadSchemaClause));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return selectDF.count();
    }

    public static final /* synthetic */ void $anonfun$new$2(TestNestedSchemaPruningOptimization $this, File tmp) {
        block0: {
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> BoxesRunTime.boxToLong((long)TestNestedSchemaPruningOptimization.$anonfun$new$3($this, tmp, tableType)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ long $anonfun$new$6(TestNestedSchemaPruningOptimization $this, File tmp$2, String tableType) {
        Tuple2 tuple2;
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString();
        String string = tableType;
        if ("cow".equals(string)) {
            tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()), (Object)"true")})), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()), (Object)"true")})));
        } else {
            if (!"mor".equals(string)) throw new MatchError((Object)string);
            tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)"org.apache.hudi.common.model.DefaultHoodieRecordPayload")})), (Object)Predef$.MODULE$.Map().empty());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Map writeOpts = (Map)tuple22._1();
        Map readOpts = (Map)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)writeOpts, (Object)readOpts);
        Tuple2 tuple24 = tuple23;
        Map writeOpts2 = (Map)tuple24._1();
        Map readOpts2 = (Map)tuple24._2();
        $this.createTableWithNestedStructSchema(tableType, tableName, tablePath, (Map<String, String>)writeOpts2);
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set ts = 234567 where id = 1").toString());
        Dataset selectDF = (Dataset)$this.withSQLConf((Seq<Tuple2<String, String>>)readOpts2.toSeq(), (Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(26).append("SELECT id, item.name FROM ").append(tableName).toString()));
        StructType expectedSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("item", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false, StructField$.MODULE$.apply$default$4())})));
        String expectedReadSchemaClause = "ReadSchema: struct<id:int,item:struct<name:string,price:int>>";
        $this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        boolean bl = false;
        ProjectExec projectExec = null;
        SparkPlan sparkPlan = selectDF.queryExecution().executedPlan();
        if (sparkPlan instanceof ProjectExec) {
            bl = true;
            projectExec = (ProjectExec)sparkPlan;
            SparkPlan fileScan = projectExec.child();
            if (fileScan instanceof FileSourceScanExec) {
                FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)fileScan;
                Option tableIdentifier = fileSourceScanExec.tableIdentifier();
                StructType requiredSchema = fileSourceScanExec.requiredSchema();
                Assertions.assertEquals((Object)tableName, (Object)((TableIdentifier)tableIdentifier.get()).table());
                Assertions.assertEquals((Object)expectedSchema, (Object)requiredSchema);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return selectDF.count();
            }
        }
        if (!bl) throw new MatchError((Object)sparkPlan);
        SparkPlan dataScan = projectExec.child();
        if (!(dataScan instanceof RowDataSourceScanExec)) throw new MatchError((Object)sparkPlan);
        String explainedPlan = $this.explain(selectDF.queryExecution().logical());
        Assertions.assertTrue((boolean)explainedPlan.contains(expectedReadSchemaClause));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return selectDF.count();
    }

    public static final /* synthetic */ void $anonfun$new$5(TestNestedSchemaPruningOptimization $this, File tmp) {
        block0: {
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> BoxesRunTime.boxToLong((long)TestNestedSchemaPruningOptimization.$anonfun$new$6($this, tmp, tableType)));
        }
    }

    public TestNestedSchemaPruningOptimization() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        this.test("Test NestedSchemaPruning optimization successful", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestNestedSchemaPruningOptimization.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestNestedSchemaPruningOptimization.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Test NestedSchemaPruning optimization unsuccessful", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestNestedSchemaPruningOptimization.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestNestedSchemaPruningOptimization.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }
}

