/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00011\t\u0011C+Z:u#V,'/_'fe\u001e,wJ\u001c*fC\u0012|\u0005\u000f^5nSj,G\rV1cY\u0016T!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\u0011I!a\u0005\u0003\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\f\u0011\u0005E\u0001\u0011!E1tg\u0016\u0014H/U;fef\u0014Vm];miR\u0019\u0011d\b\u0013\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\t\u0001\r!I\u0001\tKb\u0004Xm\u0019;fIB\u0011!DI\u0005\u0003Gm\u00111!\u00118z\u0011\u0015)#\u00011\u0001'\u0003%!\u0018M\u00197f!\u0006$\b\u000e\u0005\u0002(]9\u0011\u0001\u0006\f\t\u0003Smi\u0011A\u000b\u0006\u0003W9\ta\u0001\u0010:p_Rt\u0014BA\u0017\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055Z\u0002")
public class TestQueryMergeOnReadOptimizedTable
extends HoodieSparkSqlTestBase {
    public void assertQueryResult(Object expected, String tablePath) {
        long actual = this.spark().read().format("org.apache.hudi").option("hoodie.datasource.query.type", "read_optimized").load(tablePath).count();
        this.assertResult(expected, BoxesRunTime.boxToLong((long)actual), Prettifier$.MODULE$.default(), new Position("TestQueryMergeOnReadOptimizedTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestQueryMergeOnReadOptimizedTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(360).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | partitioned by (ts)\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 21 where id = 2").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 31 where id = 3").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 41 where id = 4").toString());
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)4), tablePath);
        $this.spark().sql(new StringBuilder(50).append("call run_compaction(op => 'schedule', table => '").append(tableName).append("')").toString()).collect();
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)4), tablePath);
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1000)").toString());
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)5), tablePath);
        $this.spark().sql(new StringBuilder(45).append("call run_compaction(op => 'run', table => '").append(tableName).append("')").toString()).collect();
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)5), tablePath);
    }

    public TestQueryMergeOnReadOptimizedTable() {
        this.test("Test Query Merge_On_Read Read_Optimized table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
            TestQueryMergeOnReadOptimizedTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestQueryMergeOnReadOptimizedTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 21));
    }
}

