/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import org.apache.hudi.HoodieSparkUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0011B+Z:u'\"|w\u000fU1si&$\u0018n\u001c8t\u0015\t!Q!\u0001\u0003ik\u0012L'B\u0001\u0004\b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0011%\tQa\u001d9be.T!AC\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0011aA8sO\u000e\u00011C\u0001\u0001\u0010!\t\u0001\u0012#D\u0001\u0004\u0013\t\u00112A\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0011\u0001\u0001")
public class TestShowPartitions
extends HoodieSparkSqlTestBase {
    public TestShowPartitions() {
        this.test("Test Show Non Partitioned Table's Partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(252).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         |) using hudi\n         |tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         )\n       ").toString())).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n         | insert into ").append(tableName).append("\n         | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Seq$.MODULE$.empty()));
        }, new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("Test Show Partitioned Table's Partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(309).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         | price double,\n         |  ts long,\n         |  dt string\n         ) using hudi\n         | partitioned by (dt)\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Seq$.MODULE$.empty()));
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n         | insert into ").append(tableName).append("\n         | values (1, 'a1', 10, 1000, '2021-01-01')\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt=2021-01-01"}))}));
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("\n         | insert into ").append(tableName).append(" partition(dt = '2021-01-02')\n         | select 2 as id, 'a2' as name, 10 as price, 1000 as ts\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(43).append("show partitions ").append(tableName).append(" partition(dt='2021-01-02')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt=2021-01-02"}))}));
            Dataset dataset = HoodieSparkUtils$.MODULE$.isSpark2() ? this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n           | insert into ").append(tableName).append("\n           | select 3 as id, 'a3' as name, 10 as price, 1000 as ts, cast(null as string) as dt\n        ").toString())).stripMargin()) : this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           | insert into ").append(tableName).append("\n           | select 3 as id, 'a3' as name, 10 as price, 1000 as ts, null as dt\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt=2021-01-01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt=2021-01-02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("dt=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"}))}))}));
        }, new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("Test Show Table's Partitions with MultiLevel Partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(385).append("\n         | create table ").append(tableName).append(" (\n         |   id int,\n         |   name string,\n         |   price double,\n         |   ts long,\n         |   year string,\n         |   month string,\n         |   day string\n         | ) using hudi\n         | partitioned by (year, month, day)\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Seq$.MODULE$.empty()));
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(530).append("\n         | insert into ").append(tableName).append("\n         | values\n         |   (1, 'a1', 10, 1000, '2021', '01', '01'),\n         |   (2, 'a2', 10, 1000, '2021', '01', '02'),\n         |   (3, 'a3', 10, 1000, '2021', '02', '01'),\n         |   (4, 'a4', 10, 1000, '2021', '02', null),\n         |   (5, 'a5', 10, 1000, '2021', null, '01'),\n         |   (6, 'a6', 10, 1000, null, '01', '02'),\n         |   (7, 'a6', 10, 1000, '2022', null, null),\n         |   (8, 'a6', 10, 1000, null, '01', null),\n         |   (9, 'a6', 10, 1000, null, null, '01')\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=01/day=01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=01/day=02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=02/day=01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=2021/month=02/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"}))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=2021/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"}))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=%s/month=01/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"}))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=%s/month=01/day=02")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"}))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=%s/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"}))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=2022/month=%s/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"}))}))}));
            this.checkAnswer(new StringBuilder(61).append("show partitions ").append(tableName).append(" partition(year='2021', month='01', day='01')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=01/day=01"}))}));
            this.checkAnswer(new StringBuilder(51).append("show partitions ").append(tableName).append(" partition(year='2021', month='02')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=2021/month=02/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"}))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=02/day=01"}))}));
            this.checkAnswer(new StringBuilder(36).append("show partitions ").append(tableName).append(" partition(day='01')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=02/day=01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=2021/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"}))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year=2021/month=01/day=01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("year=%s/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"}))}))}));
        }, new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }
}

