/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}2A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C\u00013!)\u0011\u0007\u0001C\u0001e\tiA+Z:u'B\f'o[\u001aE\t2S!AB\u0004\u0002\t!,H-\u001b\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\n\u000e\u0003\u0015I!\u0001F\u0003\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0011\u0001E2sK\u0006$X\rV3tiJ+7/\u001e7u)\tQB\u0005E\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003C\tj\u0011aB\u0005\u0003G\u001d\u00111AU8x\u0011\u0015)#\u00011\u0001'\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0002(]9\u0011\u0001\u0006\f\t\u0003Sqi\u0011A\u000b\u0006\u0003W=\ta\u0001\u0010:p_Rt\u0014BA\u0017\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055b\u0012AH2sK\u0006$X-\u00118e!J,\u0007/\u0019:f!\u0006\u0014H/\u001b;j_:$\u0016M\u00197f)\u0015\u0019dGO\u001e>!\tYB'\u0003\u000269\t!QK\\5u\u0011\u0015Q1\u00011\u00018!\t\t\u0003(\u0003\u0002:\u000f\ta1\u000b]1sWN+7o]5p]\")Qe\u0001a\u0001M!)Ah\u0001a\u0001M\u0005IA/\u00192mKB\u000bG\u000f\u001b\u0005\u0006}\r\u0001\rAJ\u0001\ni\u0006\u0014G.\u001a+za\u0016\u0004")
public class TestSpark3DDL
extends HoodieSparkSqlTestBase {
    public Row[] createTestResult(String tableName) {
        return (Row[])this.spark().sql(new StringBuilder(26).append("select * from ").append(tableName).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
    }

    public void createAndPreparePartitionTable(SparkSession spark, String tableName, String tablePath, String tableType) {
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(417).append("\n         |create table ").append(tableName).append(" (\n         |  id int, comb int, col0 int, col1 bigint, col2 float, col3 double, col4 decimal(10,4), col5 string, col6 date, col7 timestamp, col8 boolean, col9 binary, par date\n         |) using hudi\n         | location '").append(tablePath).append("'\n         | options (\n         |  type = '").append(tableType).append("',\n         |  primaryKey = 'id',\n         |  preCombineField = 'comb'\n         | )\n         | partitioned by (par)\n             ").toString())).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(788).append("\n         | insert into ").append(tableName).append(" values\n         | (1,1,11,100001,101.01,1001.0001,100001.0001,'a000001',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:01:01',true,X'a01',TIMESTAMP'2021-12-25'),\n         | (2,2,12,100002,102.02,1002.0002,100002.0002,'a000002',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:02:02',true,X'a02',TIMESTAMP'2021-12-25'),\n         | (3,3,13,100003,103.03,1003.0003,100003.0003,'a000003',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:03:03',false,X'a03',TIMESTAMP'2021-12-25'),\n         | (4,4,14,100004,104.04,1004.0004,100004.0004,'a000004',DATE'2021-12-26',TIMESTAMP'2021-12-26 12:04:04',true,X'a04',TIMESTAMP'2021-12-26'),\n         | (5,5,15,100005,105.05,1005.0005,100005.0005,'a000005',DATE'2021-12-26',TIMESTAMP'2021-12-26 12:05:05',false,X'a05',TIMESTAMP'2021-12-26')\n         |").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$new$3(TestSpark3DDL $this, File tmp$1, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$1.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
            $this.createAndPreparePartitionTable($this.spark(), tableName, tablePath, tableType);
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col6 type String").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col6 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-12-25"}))}));
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(187).append("\n               | insert into ").append(tableName).append(" values\n               | (1,1,13.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-26','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(40).append("alter table ").append(tableName).append(" alter column col6 type date").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(52).append("select col6 from ").append(tableName).append(" where id = 1 or id = 5 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{Date.valueOf("2021-12-26")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{Date.valueOf("2021-12-26")}))}));
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col0 type double").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n               | insert into ").append(tableName).append(" values\n               | (1,1,13.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,1,14.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col0 type decimal(16, 4)").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(52).append("select col0 from ").append(tableName).append(" where id = 1 or id = 6 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("13.0000")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("14.0000")}))}));
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type double").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n               | insert into ").append(tableName).append(" values\n               | (1,1,13.0,100001,901.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,1,14.0,100001,601.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col2 type decimal(16, 4)").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(58).append("select col0, col2 from ").append(tableName).append(" where id = 1 or id = 6 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("13.0000"), new BigDecimal("901.0100")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("14.0000"), new BigDecimal("601.0100")}))}));
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col1 type double").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n               | insert into ").append(tableName).append(" values\n               | (1,1,13.0,700001.0,901.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col1 type decimal(16, 4)").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(64).append("select col0, col2, col1 from ").append(tableName).append(" where id = 1 or id = 6 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("13.0000"), new BigDecimal("901.0100"), new BigDecimal("700001.0000")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("14.0000"), new BigDecimal("601.0100"), new BigDecimal("100001.0000")}))}));
            $this.spark().sessionState().catalog().dropTable(TableIdentifier$.MODULE$.apply(tableName), true, true);
            $this.spark().sessionState().catalog().refreshTable(TableIdentifier$.MODULE$.apply(tableName));
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$3($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$6(TestSpark3DDL $this, File tmp$2, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$2.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
            $this.createAndPreparePartitionTable($this.spark(), tableName, tablePath, tableType);
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type double").toString());
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col2 type decimal(16, 4)").toString());
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type String").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col2 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"101.01"}))}));
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col1 type double").toString());
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col1 type decimal(16, 4)").toString());
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col1 type String").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col1 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"100001"}))}));
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col0 type double").toString());
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col0 type decimal(16, 4)").toString());
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col0 type String").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col0 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"11"}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$5(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$6($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$8(TestSpark3DDL $this, File tmp) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = 'cow',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
            $this.spark().sql(new StringBuilder(40).append("alter table ").append(tableName).append(" add columns(new_col string)").toString());
            CatalogTable catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
            $this.assertResult(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "ts", "new_col"})), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieSqlCommonUtils$.MODULE$.removeMetaFields(catalogTable.schema()).fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            $this.checkAnswer(new StringBuilder(41).append("select id, name, price, ts, new_col from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
            $this.spark().sql("set hoodie.schema.on.read.enable=false");
            $this.spark().sql(new StringBuilder(14).append("refresh table ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 12, 2000, 'e0')").toString());
            $this.checkAnswer(new StringBuilder(41).append("select id, name, price, ts, new_col from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)2000), "e0"}))}));
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$13(CatalogTable meta$1, String x$2) {
        return meta$1.properties().contains((Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$14(CatalogTable unsetMeta$1, String x$3) {
        return unsetMeta$1.properties().contains((Object)x$3);
    }

    public static final /* synthetic */ void $anonfun$new$16(TestSpark3DDL $this, String tableName$1, String col) {
        $this.checkException(new StringBuilder(25).append("alter table ").append(tableName$1).append(" drop column ").append(col).toString(), "cannot support apply changes for primaryKey/CombineKey/partitionKey");
        $this.checkException(new StringBuilder(31).append("alter table ").append(tableName$1).append(" rename column ").append(col).append(" to ").append(col).append(col).toString(), "cannot support apply changes for primaryKey/CombineKey/partitionKey");
    }

    public static final /* synthetic */ boolean $anonfun$new$17(StructField p) {
        return p.name().equals("col1_new");
    }

    public static final /* synthetic */ boolean $anonfun$new$18(StructField p) {
        return p.name().equals("col9");
    }

    public static final /* synthetic */ void $anonfun$new$12(TestSpark3DDL $this, File tmp$3, String tableType) {
        block2: {
            BoxedUnit boxedUnit;
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$3.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block2;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
            $this.createAndPreparePartitionTable($this.spark(), tableName, tablePath, tableType);
            $this.spark().sql(new StringBuilder(94).append("alter table ").append(tableName).append(" set tblproperties(comment='it is a hudi table', 'key1'='value1', 'key2'='value2')").toString());
            CatalogTable meta = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((String)meta.comment().get()).equals("it is a hudi table"), "meta.comment.get.equals(\"it is a hudi table\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            Seq $org_scalatest_assert_macro_left = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "key2"}))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$13(meta, x$2)));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" unset tblproperties(comment, 'key1', 'key2')").toString());
            CatalogTable unsetMeta = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            Seq $org_scalatest_assert_macro_left2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "key2"}))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$14(unsetMeta, x$3)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            Option $org_scalatest_assert_macro_left3 = unsetMeta.comment();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            $this.checkException(new StringBuilder(44).append("Alter table ").append(tableName).append(" add columns(col_new1 int first)").toString(), "forbid adjust top-level columns position by using through first syntax");
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS.subList(0, HoodieRecord.HOODIE_META_COLUMNS.size() - 2)).asScala()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                $this.checkException(new StringBuilder(45).append("Alter table ").append(tableName).append(" add columns(col_new1 int after ").append(f).append(")").toString(), "forbid adjust the position of ordinary columns between meta columns");
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "comb", "par"}))).foreach((Function1 & Serializable & scala.Serializable)col -> {
                TestSpark3DDL.$anonfun$new$16($this, tableName, col);
                return BoxedUnit.UNIT;
            });
            $this.checkExceptions(new StringBuilder(39).append("alter table ").append(tableName).append(" rename column col0 to col9").toString(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot rename column: col0 to a existing name", "Cannot rename column, because col9 already exists in root"}))));
            $this.checkExceptions(new StringBuilder(39).append("alter table ").append(tableName).append(" rename column col0 to COL9").toString(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot rename column: col0 to a existing name", "Cannot rename column, because COL9 already exists in root"}))));
            $this.checkExceptions(new StringBuilder(40).append("alter table ").append(tableName).append(" add columns(col9 int first)").toString(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot add column: col9 which already exist", "Cannot add column, because col9 already exists in root"}))));
            $this.checkExceptions(new StringBuilder(40).append("alter table ").append(tableName).append(" add columns(COL9 int first)").toString(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot add column: COL9 which already exist", "Cannot add column, because COL9 already exists in root"}))));
            $this.spark().sql(new StringBuilder(91).append("alter table ").append(tableName).append(" add columns(col1_new int comment 'add new columns col1_new after id' after id)").toString());
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col9 comment 'col9 desc'").toString());
            StructType schema = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).schema();
            String $org_scalatest_assert_macro_left4 = (String)((StructField)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)schema.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$17(p)))).get(0)).getComment().get();
            String $org_scalatest_assert_macro_right3 = "add new columns col1_new after id";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            String $org_scalatest_assert_macro_left5 = (String)((StructField)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)schema.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$18(p)))).get(0)).getComment().get();
            String $org_scalatest_assert_macro_right4 = "col9 desc";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type double").toString());
            $this.spark().sql(new StringBuilder(66).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 2 order by id").toString()).show(false);
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(322).append("\n               | insert into ").append(tableName).append(" values\n               | (1,3,1,11,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,6,5,15,100005,105.05,1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(76).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 6 or id = 2 order by id").toString()).show(false);
            String string5 = tableType;
            String string6 = "mor";
            Object object = !(string5 != null ? !string5.equals(string6) : string6 != null) ? $this.spark().sql(new StringBuilder(24).append("schedule compaction  on ").append(tableName).toString()) : BoxedUnit.UNIT;
            $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col4 type decimal(18, 8)").toString());
            $this.spark().sql(new StringBuilder(66).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 2 order by id").toString()).show(false);
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(188).append("\n               | insert into ").append(tableName).append(" values\n               | (5,6,5,15,100005,105.05,1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(76).append("select id, col1_new, col4 from ").append(tableName).append(" where id = 1 or id = 6 or id = 2 order by id").toString()).show(false);
            $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type string").toString());
            $this.spark().sql(new StringBuilder(66).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 2 order by id").toString()).show(false);
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n               | insert into ").append(tableName).append(" values\n               | (1,3,1,11,100001,'101.01',1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,6,5,15,100005,'105.05',1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(76).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 6 or id = 2 order by id").toString()).show(false);
            String string7 = tableType;
            String string8 = "mor";
            Object object2 = !(string7 != null ? !string7.equals(string8) : string8 != null) ? $this.spark().sql(new StringBuilder(24).append("schedule compaction  on ").append(tableName).toString()) : BoxedUnit.UNIT;
            String string9 = tableType;
            String string10 = "mor";
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                Row[] compactionRows = (Row[])$this.spark().sql(new StringBuilder(28).append("show compaction on ").append(tableName).append(" limit 10").toString()).collect();
                String[] timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
                $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[1]).toString());
                boxedUnit = $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[0]).toString());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n               | insert into ").append(tableName).append(" values\n               | (1,3,1,11,100001,'101.01',1001.0001,100009.0001,'a000008','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (11,3,1,11,100001,'101.01',1001.0001,100011.0001,'a000008','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,6,5,15,100005,'105.05',1005.0005,100007.0005,'a000009','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(87).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 6 or id = 2 or id = 11 order by id").toString()).show(false);
        }
    }

    public static final /* synthetic */ void $anonfun$new$11(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$12($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$22(TestSpark3DDL $this, File tmp$4, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$4.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(418).append("\n               |create table ").append(tableName).append(" (\n               |  id int, comb int, `\u540d\u5b57` string, col9 string, `\u6210\u7ee9` int, `\u8eab\u9ad8` float, `\u4f53\u91cd` double, `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` date, par date\n               |) using hudi\n               | location '").append(tablePath).append("'\n               | options (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'comb'\n               | )\n               | partitioned by (par)\n             ").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n               | insert into ").append(tableName).append(" values\n               | (1,3,'\u674e\u660e', '\u8bfb\u4e66', 100,180.0001,99.0001,'2021-12-25', '2021-12-26')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" rename column col9 to `\u7231\u597d_Best`").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n               | insert into ").append(tableName).append(" values\n               | (1,3,'\u674e\u660e', '\u8bfb\u4e66', 100,180.0001,99.0001,'2021-12-26', '2021-12-26')\n               |").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(47).append("alter table ").append(tableName).append(" alter column `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` type string ").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(21).append("select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-12-26"}))}));
            $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" alter column `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` type date ").toString());
            $this.spark().sql(new StringBuilder(21).append("select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ").append(tableName).toString()).collect();
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(21).append("select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{Date.valueOf("2021-12-26")}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$21(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$22($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$25(TestSpark3DDL $this, File tmp$5, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$5.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(372).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | location '").append(tablePath).append("'\n               | options (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n             ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(18).append("show create table ").append(tableName).toString()).show(false);
            $this.spark().sql(new StringBuilder(42).append("insert into ").append(tableName).append(" values (1, 'jack', 0.9, 1000)").toString());
            $this.spark().sql(new StringBuilder(38).append("update ").append(tableName).append(" set price = 1.9  where id =  1").toString());
            $this.spark().sql(new StringBuilder(38).append("alter table ").append(tableName).append(" alter column id type long").toString());
            $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)}))}));
            $this.spark().sql(new StringBuilder(67).append("alter table ").append(tableName).append(" add columns(ext1 string comment 'add ext1' after name)").toString());
            $this.spark().sql(new StringBuilder(50).append("insert into ").append(tableName).append(" values (2, 'jack', 'exx1', 0.9, 1000)").toString());
            $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", null, BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
            $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" rename column price to newprice").toString());
            $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", null, BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
            $this.spark().sql(new StringBuilder(41).append("update ").append(tableName).append(" set ext1 =  'haha' where id =  1 ").toString());
            $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
            $this.spark().sql(new StringBuilder(33).append("alter table ").append(tableName).append(" drop column newprice").toString());
            $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToInteger((int)1000)}))}));
            $this.spark().sql(new StringBuilder(80).append("alter table ").append(tableName).append(" add columns(newprice string comment 'add newprice back' after ext1)").toString());
            $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", null, BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", null, BoxesRunTime.boxToInteger((int)1000)}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$24(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$25($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$28(TestSpark3DDL $this, File tmp$6, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$6.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string not null,\n               |  ts long\n               |) using hudi\n               | location '").append(tablePath).append("'\n               | options (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n             ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" alter column name drop not null").toString());
            $this.spark().sql(new StringBuilder(34).append("insert into ").append(tableName).append(" values(1, null, 1000)").toString());
            $this.checkAnswer(new StringBuilder(25).append("select id, name, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)1000)}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$27(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$28($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$31(TestSpark3DDL $this, File tmp$7, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$7.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(371).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  col1 string,\n               |  col2 string,\n               |  ts long\n               |) using hudi\n               | location '").append(tablePath).append("'\n               | options (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n             ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(18).append("show create table ").append(tableName).toString()).show(false);
            $this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values (1, 'aaa', 'bbb', 1000)").toString());
            $this.spark().sql(new StringBuilder(29).append("alter table ").append(tableName).append(" drop column col1").toString());
            $this.spark().sql(new StringBuilder(39).append("alter table ").append(tableName).append(" rename column col2 to col1").toString());
            $this.spark().sql(new StringBuilder(36).append("insert into ").append(tableName).append(" values (2, 'aaa', 1000)").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(29).append("select col1 from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bbb"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aaa"}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$30(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$31($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$34(TestSpark3DDL $this, File tmp$8, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$8.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(469).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  members map<String, struct<n:string, a:int>>,\n               |  user struct<name:string, age:int, score: int>,\n               |  ts long\n               |) using hudi\n               | location '").append(tablePath).append("'\n               | options (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n             ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(47).append("alter table ").append(tableName).append(" alter column members.value.a first").toString());
            $this.spark().sql(new StringBuilder(122).append("insert into ").append(tableName).append(" values(1, 'jack', map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStruct', 29, 100), 1000)").toString());
            $this.spark().sql(new StringBuilder(40).append("alter table ").append(tableName).append(" rename column user to userx").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(49).append("select ts, userx.score, id, userx.age, name from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)29), "jack"}))}));
            $this.spark().sql(new StringBuilder(56).append("alter table ").append(tableName).append(" drop columns(name, userx.name, userx.score)").toString());
            $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).show(false);
            $this.spark().sql(new StringBuilder(186).append("alter table ").append(tableName).append(" add columns(name string comment 'add name back' after userx,").append(" userx.name string comment 'add userx.name back' first, userx.score int comment 'add userx.score back' after age)").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(42).append("select name, userx.name, userx.score from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null}))}));
            $this.spark().sql(new StringBuilder(131).append("insert into ").append(tableName).append(" values(2 , map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000)").toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(71).append("select name, userx.name as uxname, userx.score as uxs from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jacknew", "jackStructNew", BoxesRunTime.boxToInteger((int)101)}))}));
            $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" alter column userx.age type long").toString());
            $this.spark().sql(new StringBuilder(32).append("select userx.age, id, name from ").append(tableName).toString());
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(44).append("select userx.age, id, name from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)29), BoxesRunTime.boxToInteger((int)1), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)291), BoxesRunTime.boxToInteger((int)2), "jacknew"}))}));
            $this.spark().sql(new StringBuilder(46).append("alter table ").append(tableName).append(" add columns(mxp map<String, int>)").toString());
            $this.spark().sql(new StringBuilder(144).append("insert into ").append(tableName).append(" values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 9))").toString());
            $this.spark().sql(new StringBuilder(47).append("alter table ").append(tableName).append(" alter column mxp.value type double").toString());
            $this.spark().sql(new StringBuilder(145).append("insert into ").append(tableName).append(" values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 10))").toString());
            $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).show(false);
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(28).append("select mxp from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t1"), (Object)BoxesRunTime.boxToDouble((double)10.0))}))}))}));
            $this.spark().sql(new StringBuilder(41).append("alter table ").append(tableName).append(" rename column members to mem").toString());
            $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" rename column mem.value.n to nn").toString());
            $this.spark().sql(new StringBuilder(38).append("alter table ").append(tableName).append(" rename column userx to us").toString());
            $this.spark().sql(new StringBuilder(41).append("alter table ").append(tableName).append(" rename column us.age to age1").toString());
            $this.spark().sql(new StringBuilder(145).append("insert into ").append(tableName).append(" values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 10))").toString());
            $this.spark().sql(new StringBuilder(46).append("select mem.value.nn, us.age1 from ").append(tableName).append(" order by id").toString()).show();
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(46).append("select mem.value.nn, us.age1 from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)29)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)291)}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$33(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$34($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$37(TestSpark3DDL $this, File tmp$9, String tableType) {
        block0: {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp$9.getCanonicalPath(), tableName).toUri().toString());
            if (!HoodieSparkUtils$.MODULE$.gteqSpark3_1()) break block0;
            HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
            String schema = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
            List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInsertsAsPerSchema("001", Predef$.MODULE$.int2Integer(1000), schema))).toList();
            Dataset inputDF1 = $this.spark().read().json($this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
            Dataset orgStringDf = inputDF1.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"city_to_state", "distance_in_meters", "drivers"})).withColumn("tip_history", functions$.MODULE$.arrays_zip((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("tip_history.currency")})));
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            scala.collection.immutable.Map hudiOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TABLE_NAME), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.schema.on.read.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.reconcile.schema"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING_OPT_KEY()), (Object)"true")}));
            orgStringDf.write().format("org.apache.hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).options((Map)hudiOptions).mode(SaveMode.Overwrite).save(tablePath);
            Dataset oldView = $this.spark().read().format("hudi").load(tablePath);
            oldView.show(false);
            List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdatesAsPerSchema("002", Predef$.MODULE$.int2Integer(100), schema))).toList();
            Dataset inputD2 = $this.spark().read().json($this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
            Dataset updatedStringDf = inputD2.drop("fare").drop("height");
            String checkRowKey = (String)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inputD2.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collectAsList()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getString(0), Buffer$.MODULE$.canBuildFrom())).get(0);
            updatedStringDf.write().format("org.apache.hudi").options((Map)hudiOptions).option(DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option("hoodie.datasource.write.reconcile.schema", "true").mode(SaveMode.Append).save(tablePath);
            $this.spark().read().format("hudi").load(tablePath).registerTempTable("newView");
            Tuple5[] checkResult = (Tuple5[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(102).append("select tip_history.amount,city_to_state,distance_in_meters,fare,height from newView where _row_key='").append(checkRowKey).append("' ").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(0)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(1)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(2)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(3)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(4))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple5.class)));
            $this.assertResult(new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)true)), checkResult[0], Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
            $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(49).append("select fare,height from newView where _row_key='").append(checkRowKey).append("'").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null}))}));
        }
    }

    public static final /* synthetic */ void $anonfun$new$36(TestSpark3DDL $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY_ON_WRITE", "MERGE_ON_READ"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$37($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestSpark3DDL() {
        this.test("Test alter column types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("Test alter column types 2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Test Enable and Disable Schema on read", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("Test alter table properties and add rename drop column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$11(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("Test Chinese table ", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$21(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("Test alter column by add rename and drop", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$24(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        this.test("Test alter column nullability", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$27(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        this.test("Test alter column multiple times", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$30(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("Test alter column with complex schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$33(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        this.test("Test schema auto evolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$36(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
    }
}

