/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001A2Aa\u0001\u0003\u0001\u001f!)!\u0004\u0001C\u00017!)Q\u0004\u0001C\u0001=\tYA+Z:u'Fd7i\u001c8g\u0015\t)a!\u0001\u0003ik\u0012L'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011)A\u0011\u0011CE\u0007\u0002\t%\u00111\u0003\u0002\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003D\u0001\ng\u000e\fG.\u0019;fgRL!!\u0007\f\u0003\u001d\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003#\u0001\taa]3u\u000b:4HcA\u0010-]A\u0011\u0001%\u000b\b\u0003C\u001d\u0002\"AI\u0013\u000e\u0003\rR!\u0001\n\b\u0002\rq\u0012xn\u001c;?\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0003\u0019\u0001&/\u001a3fM&\u0011!f\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!*\u0003\"B\u0017\u0003\u0001\u0004y\u0012aA6fs\")qF\u0001a\u0001?\u0005)a/\u00197vK\u0002")
public class TestSqlConf
extends HoodieSparkSqlTestBase
implements BeforeAndAfter {
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    @Override
    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public String setEnv(String key, String value) {
        Field field = System.getenv().getClass().getDeclaredField("m");
        field.setAccessible(true);
        Map map = (Map)field.get(System.getenv());
        return map.put(key, value);
    }

    public static final /* synthetic */ void $anonfun$new$2(TestSqlConf $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = tmp.getCanonicalPath();
        String partitionVal = "2021";
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  year string\n           |) using hudi\n           | partitioned by (year)\n           | location '").append(tablePath).append("'\n           | options (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(40).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, ").append(partitionVal).append(")").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf($this.spark().sessionState().newHadoopConf()).build();
        String firstCommit = ((HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).getTimestamp();
        $this.spark().sql(new StringBuilder(40).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, ").append(partitionVal).append(")").toString());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, year from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal}))}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)Files.exists(Paths.get(new StringBuilder(1).append(tablePath).append("/").append(partitionVal).toString(), new String[0]), new LinkOption[0])), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        $this.assertResult(HoodieTableType.MERGE_ON_READ, new HoodieTableConfig(new Path(tablePath).getFileSystem(new Configuration()), new StringBuilder(8).append(tablePath).append("/").append(".hoodie").toString(), (String)HoodieTableConfig.PAYLOAD_CLASS_NAME.defaultValue()).getTableType(), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        DFSPropertiesConfiguration.addToGlobalProps((String)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), (String)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL());
        DFSPropertiesConfiguration.addToGlobalProps((String)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), (String)firstCommit);
        $this.spark().catalog().refreshTable(tableName);
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, year from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal}))}));
        $this.spark().sql(new StringBuilder(26).append("delete from ").append(tableName).append(" where year = ").append(partitionVal).toString());
        long cnt = $this.spark().sql(new StringBuilder(28).append("select * from ").append(tableName).append(" where year = ").append(partitionVal).toString()).count();
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)cnt), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    public TestSqlConf() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.test("Test Hudi Conf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSqlConf.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testPropsFilePath = new File("src/test/resources/external-config").getAbsolutePath();
            this.setEnv("HUDI_CONF_DIR", testPropsFilePath);
            DFSPropertiesConfiguration.refreshGlobalProps();
        }, new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DFSPropertiesConfiguration.clearGlobalProps(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }
}

