/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0019B+Z:u)&lW\r\u0016:bm\u0016dG+\u00192mK*\u0011A!B\u0001\u0005QV$\u0017N\u0003\u0002\u0007\u000f\u0005\u00191/\u001d7\u000b\u0005!I\u0011!B:qCJ\\'B\u0001\u0006\f\u0003\u0019\t\u0007/Y2iK*\tA\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001#E\u0007\u0002\u0007%\u0011!c\u0001\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0006\t\u0003!\u0001\u0001")
public class TestTimeTravelTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestTimeTravelTable $this, File tmp) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = 'cow',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.builder().setBasePath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName1).toString()).setConf($this.spark().sessionState().newHadoopConf()).build();
        String instant1 = ((HoodieInstant)metaClient1.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).getTimestamp();
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a2', 20, 2000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000)}))}));
        $this.checkAnswer(new StringBuilder(51).append("select id, name, price, ts from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$4(TestTimeTravelTable $this, File tmp) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = 'cow',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.builder().setBasePath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName1).toString()).setConf($this.spark().sessionState().newHadoopConf()).build();
        String instant1 = ((HoodieInstant)metaClient1.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).getTimestamp();
        String tableName2 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(311).append("\n             |create table ").append(tableName2).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             |) using hudi\n             | tblproperties (primaryKey = 'id')\n             | partitioned by (dt)\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName2).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n             | insert into ").append(tableName2).append("\n             | select id, name, price, ts, '2022-02-14' as dt\n             | from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("'\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2022-02-14"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(161).append("\n             | insert into ").append(tableName2).append(" partition(dt = '2022-02-15')\n             | select 2 as id, 'a2' as name, price, ts\n             | from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("'\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2022-02-14"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2022-02-15"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$7(TestTimeTravelTable $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = tmp$1.getCanonicalPath();
        String tableName1 = new StringBuilder(2).append(tableName).append("_1").toString();
        String tableName2 = new StringBuilder(2).append(tableName).append("_2").toString();
        String path1 = new StringBuilder(1).append(basePath).append("/").append(tableName1).toString();
        String path2 = new StringBuilder(1).append(basePath).append("/").append(tableName2).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(372).append("\n               |create table ").append(tableName1).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | tblproperties (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n               | location '").append(path1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(372).append("\n               |create table ").append(tableName2).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | tblproperties (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n               | location '").append(path2).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(2, 'a2', 20, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName2).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName2).append(" values(4, 'a4', 20, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.builder().setBasePath(path1).setConf($this.spark().sessionState().newHadoopConf()).build();
        HoodieTableMetaClient metaClient2 = HoodieTableMetaClient.builder().setBasePath(path2).setConf($this.spark().sessionState().newHadoopConf()).build();
        String instant1 = ((HoodieInstant)metaClient1.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).getTimestamp();
        String instant2 = ((HoodieInstant)metaClient2.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).getTimestamp();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("\n               |select id, name, price, ts from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("' where id=1\n               |union\n               |select id, name, price, ts from ").append(tableName2).append(" TIMESTAMP AS OF '").append(instant2).append("' where id>1\n               |").toString())).stripMargin();
        $this.checkAnswer(sql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$6(TestTimeTravelTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & java.io.Serializable & Serializable)tableType -> {
            TestTimeTravelTable.$anonfun$new$7($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$9(TestTimeTravelTable $this, File dir) {
        String path = dir.toURI().getPath();
        $this.spark().sql(new StringBuilder(58).append("insert overwrite local directory '").append(path).append("' using parquet select 1").toString());
    }

    public static final /* synthetic */ void $anonfun$new$11(TestTimeTravelTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = 'cow',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString()).setConf($this.spark().sessionState().newHadoopConf()).build();
        String instant = ((HoodieInstant)metaClient.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).getTimestamp();
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a2', 20, 2000)").toString());
        $this.checkAnswer(new StringBuilder(70).append("select id, name, price, ts from ").append(tableName).append(" distribute by cast(rand() * 2 as int)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000)}))}));
        $this.checkAnswer(new StringBuilder(89).append("select id, name, price, ts from ").append(tableName).append(" TIMESTAMP AS OF '").append(instant).append("' distribute by cast(rand() * 2 as int)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$13(TestTimeTravelTable $this, File tmp) {
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(322).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString()).setConf($this.spark().sessionState().newHadoopConf()).build();
        String instant1 = ((HoodieInstant)metaClient.reloadActiveTimeline().getAllCommitsTimeline().lastInstant().get()).getTimestamp();
        $this.spark().sql(new StringBuilder(41).append("alter table ").append(tableName).append(" add columns (company string)").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(2, 'a2', 11, 1100, 'hudi')").toString());
        String instant2 = ((HoodieInstant)metaClient.reloadActiveTimeline().getAllCommitsTimeline().lastInstant().get()).getTimestamp();
        $this.spark().sql(new StringBuilder(30).append("alter table ").append(tableName).append(" drop column price").toString());
        Row[] result1 = (Row[])$this.spark().sql(new StringBuilder(43).append("select * from ").append(tableName).append(" timestamp as of ").append(instant1).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
        $this.checkAnswer(result1, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        Row[] result2 = (Row[])$this.spark().sql(new StringBuilder(43).append("select * from ").append(tableName).append(" timestamp as of ").append(instant2).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
        $this.checkAnswer(result2, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1100), "hudi"}))}));
        Row[] result3 = (Row[])$this.spark().sql(new StringBuilder(26).append("select * from ").append(tableName).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
        $this.checkAnswer(result3, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)1100), "hudi"}))}));
    }

    public TestTimeTravelTable() {
        this.test("Test Insert and Update Record with time travel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
                    TestTimeTravelTable.$anonfun$new$2(this, tmp);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
        this.test("Test Insert Into Records with time travel To new Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
                    TestTimeTravelTable.$anonfun$new$4(this, tmp);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Test Two Table's Union Join with time travel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
                    TestTimeTravelTable.$anonfun$new$6(this, tmp);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("Test Unsupported syntax can be parsed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
                this.checkAnswer("select 1 distribute by 1", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))}));
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)dir -> {
                    TestTimeTravelTable.$anonfun$new$9(this, dir);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("Test Select Record with time travel and Repartition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
                    TestTimeTravelTable.$anonfun$new$11(this, tmp);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("Test Time Travel With Schema Evolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
                    TestTimeTravelTable.$anonfun$new$13(this, tmp);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
    }
}

