/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.TestTruncateTable$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\tB+Z:u)J,hnY1uKR\u000b'\r\\3\u000b\u0005\u0011)\u0011\u0001\u00025vI&T!AB\u0004\u0002\u0007M\fHN\u0003\u0002\t\u0013\u0005)1\u000f]1sW*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\tR\"A\u0002\n\u0005I\u0019!A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\t\u0001\u0001")
public class TestTruncateTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestTruncateTable $this, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(304).append("\n            |create table ").append(tableName).append(" (\n            |  id int,\n            |  name string,\n            |  price double,\n            |  ts long\n            |) using hudi\n            | options (\n            |  type = '").append(tableType).append("',\n            |  primaryKey = 'id',\n            |  preCombineField = 'ts'\n            | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(15).append("truncate table ").append(tableName).toString());
        $this.checkAnswer(new StringBuilder(21).append("select count(1) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$5(TestTruncateTable $this, boolean urlencode$1, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestTruncateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestTruncateTable$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_hudi_TestTruncateTable$$typecreator5$1(TestTruncateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021/10/01"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"l4", (Object)"v1", (Object)"2021/10/02")})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestTruncateTable$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "dt"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), urlencode$1).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), SimpleKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(43).append("truncate table ").append(tableName).append(" partition (dt='2021/10/01')").toString());
        $this.checkAnswer(new StringBuilder(15).append("select dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/10/02"}))}));
        $this.spark().sql(new StringBuilder(15).append("truncate table ").append(tableName).toString());
        $this.checkAnswer(new StringBuilder(21).append("select count(1) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestTruncateTable $this, boolean hiveStyle$1, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestTruncateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_TestTruncateTable$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_TestTruncateTable$$typecreator13$1(TestTruncateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021", (Object)"10", (Object)"01"), new Tuple6((Object)BoxesRunTime.boxToInteger((int)2), (Object)"l4", (Object)"v1", (Object)"2021", (Object)"10", (Object)"02")})), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestTruncateTable$$typecreator13$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "year", "month", "day"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "year,month,day").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStyle$1).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkExceptionContain(new StringBuilder(51).append("truncate table ").append(tableName).append(" partition (year='2021', month='10')").toString(), "All partition columns need to be specified for Hoodie's partition");
        $this.spark().sql(new StringBuilder(61).append("truncate table ").append(tableName).append(" partition (year='2021', month='10', day='01')").toString());
        $this.checkAnswer(new StringBuilder(43).append("select id, name, ts, year, month, day from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "l4", "v1", "2021", "10", "02"}))}));
        $this.spark().sql(new StringBuilder(15).append("truncate table ").append(tableName).toString());
        $this.checkAnswer(new StringBuilder(21).append("select count(1) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
    }

    public TestTruncateTable() {
        this.test("Test Truncate non-partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestTruncateTable.$anonfun$new$2(this, tableType);
            return BoxedUnit.UNIT;
        }), new Position("TestTruncateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)urlencode -> {
            this.test(new StringBuilder(61).append("Test Truncate single-partition table' partitions, urlencode: ").append(BoxesRunTime.unboxToBoolean((Object)urlencode)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestTruncateTable.$anonfun$new$5($this, urlencode, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestTruncateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)hiveStyle -> {
            this.test(new StringBuilder(83).append("Test Truncate multi-level partitioned table's partitions, isHiveStylePartitioning: ").append(BoxesRunTime.unboxToBoolean((Object)hiveStyle)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestTruncateTable.$anonfun$new$8($this, hiveStyle, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestTruncateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            return BoxedUnit.UNIT;
        });
    }
}

