/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.index;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.command.CreateIndexCommand;
import org.apache.spark.sql.hudi.command.DropIndexCommand;
import org.apache.spark.sql.hudi.command.ShowIndexesCommand;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001%!)q\u0003\u0001C\u00011\tyA+Z:u\u0013:$W\r_*z]R\f\u0007P\u0003\u0002\u0005\u000b\u0005)\u0011N\u001c3fq*\u0011aaB\u0001\bG>lW.\u00198e\u0015\tA\u0011\"\u0001\u0003ik\u0012L'B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\b\u0013\t1rA\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\u0001")
public class TestIndexSyntax
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestIndexSyntax $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append((String)tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
            ParserInterface sqlParser = $this.spark().sessionState().sqlParser();
            Analyzer analyzer = $this.spark().sessionState().analyzer();
            LogicalPlan logicalPlan = sqlParser.parsePlan(new StringBuilder(26).append("show indexes from default.").append(tableName).toString());
            LogicalPlan resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertResult(new StringBuilder(12).append("`default`.`").append(tableName).append("`").toString(), ((ShowIndexesCommand)resolvedLogicalPlan).tableId().toString(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            logicalPlan = sqlParser.parsePlan(new StringBuilder(70).append("create index idx_name on ").append(tableName).append(" using lucene (name) options(block_size=1024)").toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertResult(new StringBuilder(12).append("`default`.`").append(tableName).append("`").toString(), ((CreateIndexCommand)resolvedLogicalPlan).tableId().toString(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            $this.assertResult("idx_name", ((CreateIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            $this.assertResult("lucene", ((CreateIndexCommand)resolvedLogicalPlan).indexType(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)((CreateIndexCommand)resolvedLogicalPlan).ignoreIfExists()), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_size"), (Object)"1024")})), ((CreateIndexCommand)resolvedLogicalPlan).properties(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            logicalPlan = sqlParser.parsePlan(new StringBuilder(107).append("create index if not exists idx_price on ").append(tableName).append(" using lucene (price options(order='desc')) options(block_size=512)").toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertResult(new StringBuilder(12).append("`default`.`").append(tableName).append("`").toString(), ((CreateIndexCommand)resolvedLogicalPlan).tableId().toString(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            $this.assertResult("idx_price", ((CreateIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            $this.assertResult("lucene", ((CreateIndexCommand)resolvedLogicalPlan).indexType(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"order"), (Object)"desc")})), ((Tuple2)((CreateIndexCommand)resolvedLogicalPlan).columns().head())._2(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_size"), (Object)"512")})), ((CreateIndexCommand)resolvedLogicalPlan).properties(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            logicalPlan = sqlParser.parsePlan(new StringBuilder(33).append("drop index if exists idx_name on ").append(tableName).toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertResult(new StringBuilder(12).append("`default`.`").append(tableName).append("`").toString(), ((DropIndexCommand)resolvedLogicalPlan).tableId().toString(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            $this.assertResult("idx_name", ((DropIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            return $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)((DropIndexCommand)resolvedLogicalPlan).ignoreIfNotExists()), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        });
    }

    public TestIndexSyntax() {
        this.test("Test Create/Drop/Show/Refresh Index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestIndexSyntax.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
    }
}

