/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.functional.TestBootstrap;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001a1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\t1B+Z:u\u0005>|Go\u001d;sCB\u0004&o\\2fIV\u0014XM\u0003\u0002\u0005\u000b\u0005I\u0001O]8dK\u0012,(/\u001a\u0006\u0003\r\u001d\tA\u0001[;eS*\u0011\u0001\"C\u0001\u0004gFd'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011aA\u0005\u0003)\r\u0011A\u0004S8pI&,7\u000b]1sWB\u0013xnY3ekJ,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011!\u0003\u0001")
public class TestBootstrapProcedure
extends HoodieSparkProcedureTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestBootstrapProcedure $this, File tmp) {
        int NUM_OF_RECORDS = 100;
        String PARTITION_FIELD = "datestr";
        String RECORD_KEY_FIELD = "_row_key";
        String tableName = $this.generateTableName();
        String basePath = String.valueOf(tmp.getCanonicalPath());
        String srcName = "source";
        String sourcePath = new StringBuilder(1).append(basePath).append("/").append(srcName).toString();
        String tablePath = new StringBuilder(1).append(basePath).append("/").append(tableName).toString();
        JavaSparkContext jsc = new JavaSparkContext($this.spark().sparkContext());
        List<Object> partitions = Arrays.asList((Object[])new String[]{"2018", "2019", "2020"});
        long timestamp = Instant.now().toEpochMilli();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Dataset<Row> df = TestBootstrap.generateTestRawTripDataset(timestamp, i * NUM_OF_RECORDS, i * NUM_OF_RECORDS + NUM_OF_RECORDS, null, jsc, $this.spark().sqlContext());
            df.write().parquet(new StringBuilder(2).append(sourcePath).append("/").append(PARTITION_FIELD).append("=").append(partitions.get(i)).toString());
        });
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(250).append("call run_bootstrap(\n           |table => '").append(tableName).append("',\n           |base_path => '").append(tablePath).append("',\n           |table_type => '").append(HoodieTableType.COPY_ON_WRITE.name()).append("',\n           |bootstrap_path => '").append(sourcePath).append("',\n           |rowKey_field => '").append(RECORD_KEY_FIELD).append("',\n           |partition_path_field => '").append(PARTITION_FIELD).append("',\n           |bootstrap_overwrite => true)").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("\n           |create table ").append(tableName).append(" using hudi\n           |location '").append(tablePath).append("'\n           |tblproperties(primaryKey = '").append(RECORD_KEY_FIELD).append("')\n           |").toString())).stripMargin());
        Row[] result = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("call show_bootstrap_partitions(table => '").append(tableName).append("')").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestBootstrapProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        result = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(40).append("call show_bootstrap_mapping(table => '").append(tableName).append("')").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestBootstrapProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
    }

    public TestBootstrapProcedure() {
        this.test("Test Call run_bootstrap Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestBootstrapProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestBootstrapProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
    }
}

