/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.CallArgument;
import org.apache.spark.sql.catalyst.plans.logical.CallCommand;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NamedArgument;
import org.apache.spark.sql.catalyst.plans.logical.PositionalArgument;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0005\u000b\u0001]AQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013%\u0011\u0005\u0003\u0004*\u0001\u0001\u0006IA\t\u0005\u0006U\u0001!\tb\u000b\u0005\u0006\u0003\u0002!IA\u0011\u0005\u0006\u0003\u0002!Ia\u0018\u0005\u0006M\u0002!Ia\u001a\u0005\u0006e\u0002!Ia\u001d\u0002\u0016)\u0016\u001cHoQ1mY\u000e{W.\\1oIB\u000b'o]3s\u0015\tYA\"A\u0005qe>\u001cW\rZ;sK*\u0011QBD\u0001\u0005QV$\u0017N\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011DG\u0007\u0002\u0019%\u00111\u0004\u0004\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011AC\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0003\t\u0002\"aI\u0014\u000e\u0003\u0011R!\u0001I\u0013\u000b\u0005\u0019r\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005!\"#a\u0004)beN,'/\u00138uKJ4\u0017mY3\u0002\u000fA\f'o]3sA\u0005Q2\r[3dWB\u000b'o]3Fq\u000e,\u0007\u000f^5p]\u000e{g\u000e^1j]R\u0011A\u0006\u0011\u000b\u0003[M\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012A!\u00168ji\")A\u0007\u0002a\u0001k\u0005AQM\u001d:pe6\u001bx\r\u0005\u00027{9\u0011qg\u000f\t\u0003q=j\u0011!\u000f\u0006\u0003uY\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f0\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qz\u0003\"B\b\u0005\u0001\u0004)\u0014\u0001C2iK\u000e\\\u0017I]4\u0015\u000b5\u001aUJU,\t\u000b\u0011+\u0001\u0019A#\u0002\t\r\fG\u000e\u001c\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002KK\u0005)\u0001\u000f\\1og&\u0011Aj\u0012\u0002\f\u0007\u0006dGnQ8n[\u0006tG\rC\u0003O\u000b\u0001\u0007q*A\u0003j]\u0012,\u0007\u0010\u0005\u0002/!&\u0011\u0011k\f\u0002\u0004\u0013:$\b\"B*\u0006\u0001\u0004!\u0016!D3ya\u0016\u001cG/\u001a3WC2,X\r\u0005\u0002/+&\u0011ak\f\u0002\u0004\u0003:L\b\"\u0002-\u0006\u0001\u0004I\u0016\u0001D3ya\u0016\u001cG/\u001a3UsB,\u0007C\u0001.^\u001b\u0005Y&B\u0001/\u000f\u0003\u0015!\u0018\u0010]3t\u0013\tq6L\u0001\u0005ECR\fG+\u001f9f)\u0019i\u0003-\u00192eK\")AI\u0002a\u0001\u000b\")aJ\u0002a\u0001\u001f\")1M\u0002a\u0001k\u0005aQ\r\u001f9fGR,GMT1nK\")1K\u0002a\u0001)\")\u0001L\u0002a\u00013\u0006qAo\\*qCJ\\G*\u001b;fe\u0006dGc\u00015oaB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.J\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002nU\n9A*\u001b;fe\u0006d\u0007\"B8\b\u0001\u0004!\u0016!\u0002<bYV,\u0007\"B9\b\u0001\u0004I\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u0013\rDWmY6DCN$XC\u0001;x)\r)XP \t\u0003m^d\u0001\u0001B\u0003y\u0011\t\u0007\u0011PA\u0001U#\tQH\u000b\u0005\u0002/w&\u0011Ap\f\u0002\b\u001d>$\b.\u001b8h\u0011\u0015y\u0007\u00021\u0001U\u0011\u0019y\b\u00021\u0001\u0002\u0002\u0005iQ\r\u001f9fGR,Gm\u00117bgN\u0004BANA\u0002k&\u0019\u0011QA \u0003\u000b\rc\u0017m]:")
public class TestCallCommandParser
extends HoodieSparkSqlTestBase {
    private final ParserInterface parser = this.spark().sessionState().sqlParser();

    private ParserInterface parser() {
        return this.parser;
    }

    public void checkParseExceptionContain(String sql, String errorMsg) {
        LogicalPlan logicalPlan;
        boolean hasException = false;
        try {
            logicalPlan = this.parser().parsePlan(sql);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 == null || !(throwable2 = throwable3).getMessage().contains(errorMsg)) {
                if (throwable3 != null) {
                    Throwable throwable4 = throwable3;
                    throw this.fail(new StringBuilder(43).append("Exception should contain: ").append(errorMsg).append(", error message: ").append(throwable4.getMessage()).toString(), throwable4, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                }
                throw throwable;
            }
            hasException = true;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            logicalPlan = boxedUnit;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    private void checkArg(CallCommand call, int index, Object expectedValue, DataType expectedType) {
        this.checkArg(call, index, null, expectedValue, expectedType);
    }

    private void checkArg(CallCommand call, int index, String expectedName, Object expectedValue, DataType expectedType) {
        PositionalArgument positionalArgument;
        if (expectedName != null) {
            NamedArgument arg = this.checkCast(call.args().apply(index), NamedArgument.class);
            positionalArgument = this.assertResult(expectedName, arg.name(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        } else {
            CallArgument arg = (CallArgument)call.args().apply(index);
            positionalArgument = this.checkCast(arg, PositionalArgument.class);
        }
        Literal expectedExpr = this.toSparkLiteral(expectedValue, expectedType);
        Expression actualExpr = ((CallArgument)call.args().apply(index)).expr();
        this.assertResult(expectedExpr.dataType(), actualExpr.dataType(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
    }

    private Literal toSparkLiteral(Object value, DataType dataType) {
        return Literal$.MODULE$.create(value, dataType);
    }

    private <T> T checkCast(Object value, Class<T> expectedClass) {
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)expectedClass.isInstance(value)), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        return expectedClass.cast(value);
    }

    public TestCallCommandParser() {
        this.test("Test Call Produce with Positional Arguments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan("CALL c.n.func(1, '2', 3L, true, 1.0D, 9.0e1, 900e-1BD)");
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"c", "n", "func"}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
            this.assertResult(BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            this.checkArg(call, 0, BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "2", DataTypes.StringType);
            this.checkArg(call, 2, BoxesRunTime.boxToLong((long)3L), DataTypes.LongType);
            this.checkArg(call, 3, BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
            this.checkArg(call, 4, BoxesRunTime.boxToDouble((double)1.0), DataTypes.DoubleType);
            if (HoodieSparkUtils$.MODULE$.isSpark2()) {
                this.checkArg(call, 5, BoxesRunTime.boxToDouble((double)90.0), (DataType)DataTypes.createDecimalType((int)2, (int)0));
            } else {
                this.checkArg(call, 5, BoxesRunTime.boxToDouble((double)90.0), DataTypes.DoubleType);
            }
            this.checkArg(call, 6, new BigDecimal("900e-1"), (DataType)DataTypes.createDecimalType((int)3, (int)1));
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("Test Call Produce with Named Arguments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan("CALL system.func(c1 => 1, c2 => '2', c3 => true)");
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", "func"}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            this.checkArg(call, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "c2", "2", DataTypes.StringType);
            this.checkArg(call, 2, "c3", BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("Test Call Produce with Var Substitution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan("CALL system.func('${spark.extra.prop}')");
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", "func"}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            this.checkArg(call, 0, "value", DataTypes.StringType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Test Call Produce with Mixed Arguments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan("CALL system.func(c1 => 1, '2')");
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", "func"}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            this.checkArg(call, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "2", DataTypes.StringType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("Test Call Parse Error", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_3()) {
                this.checkParseExceptionContain("CALL cat.system radish kebab", "Syntax error at or near 'CALL'");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.checkParseExceptionContain("CALL cat.system radish kebab", "mismatched input 'CALL' expecting");
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("Test Call Produce with semicolon", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan("CALL system.func(c1 => 1, c2 => '2', c3 => true)");
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", "func"}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            this.checkArg(call, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "c2", "2", DataTypes.StringType);
            this.checkArg(call, 2, "c3", BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
            CallCommand call2 = (CallCommand)this.parser().parsePlan("CALL system.func2(c1 => 1, c2 => '2', c3 => true);");
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", "func2"}), JavaConverters$.MODULE$.seqAsJavaListConverter(call2.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)call2.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            this.checkArg(call2, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call2, 1, "c2", "2", DataTypes.StringType);
            this.checkArg(call2, 2, "c3", BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
    }
}

