/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019!)\u0001\u0007\u0001C\u0001c!)\u0001\u000b\u0001C\u0001#\n9B+Z:u\u00072,8\u000f^3sS:<\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u000f!\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005%Q\u0011\u0001\u00025vI&T!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!\u0001\b%p_\u0012LWm\u00159be.\u0004&o\\2fIV\u0014X\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"!\u0006\u0001\u0002\u0013\u00054xMU3d_J$GCA\u000f$!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0011auN\\4\t\u000b\u0011\u0012\u0001\u0019A\u0013\u0002\u001d\r|W.\\5u)&lW\r\\5oKB\u0011aEL\u0007\u0002O)\u0011\u0001&K\u0001\ti&lW\r\\5oK*\u0011!fK\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003Y5\naaY8n[>t'BA\u0005\u000f\u0013\tysE\u0001\bI_>$\u0017.\u001a+j[\u0016d\u0017N\\3\u0002\u0019]\u0014\u0018\u000e^3SK\u000e|'\u000fZ:\u0015\rI*$\b\u0010 L!\tq2'\u0003\u00025?\t!QK\\5u\u0011\u001514\u00011\u00018\u0003\u00151\u0017\u000e\\3t!\tq\u0002(\u0003\u0002:?\t\u0019\u0011J\u001c;\t\u000bm\u001a\u0001\u0019A\u001c\u0002\u00159,XNU3d_J$7\u000fC\u0003>\u0007\u0001\u0007q'\u0001\u0006qCJ$\u0018\u000e^5p]NDQaP\u0002A\u0002\u0001\u000b\u0001\u0002\\8dCRLwN\u001c\t\u0003\u0003\"s!A\u0011$\u0011\u0005\r{R\"\u0001#\u000b\u0005\u0015\u0013\u0012A\u0002\u001fs_>$h(\u0003\u0002H?\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9u\u0004C\u0003M\u0007\u0001\u0007Q*A\u0004paRLwN\\:\u0011\t\u0005s\u0005\tQ\u0005\u0003\u001f*\u00131!T1q\u0003\u001d9(/\u001b;f\t\u001a#BA\r*\\9\")1\u000b\u0002a\u0001)\u0006\u0011AM\u001a\t\u0004+ZCV\"\u0001\u0006\n\u0005]S!a\u0002#bi\u0006\u001cX\r\u001e\t\u0003+fK!A\u0017\u0006\u0003\u0007I{w\u000fC\u0003@\t\u0001\u0007\u0001\tC\u0003M\t\u0001\u0007Q\n")
public class TestClusteringProcedure
extends HoodieSparkProcedureTestBase {
    public long avgRecord(HoodieTimeline commitTimeline) {
        LongRef totalByteSize = LongRef.create((long)0L);
        LongRef totalRecordsCount = LongRef.create((long)0L);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(commitTimeline.getReverseOrderedInstants().toArray())).foreach((Function1 & Serializable & scala.Serializable)instant -> {
            TestClusteringProcedure.$anonfun$avgRecord$1(commitTimeline, totalByteSize, totalRecordsCount, instant);
            return BoxedUnit.UNIT;
        });
        return (long)Math.ceil(1.0 * (double)totalByteSize.elem / (double)totalRecordsCount.elem);
    }

    public void writeRecords(int files, int numRecords, int partitions, String location, Map<String, String> options) {
        ArrayList records = new ArrayList(numRecords);
        int rowDimension = (int)Math.ceil(Math.sqrt(numRecords));
        Stream data = (Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)rowDimension), (Object)BoxesRunTime.boxToInteger((int)1), (Integral)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)x -> TestClusteringProcedure.$anonfun$writeRecords$1(rowDimension, BoxesRunTime.unboxToInt((Object)x)), Stream$.MODULE$.canBuildFrom());
        if (partitions > 0) {
            data.foreach((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)records.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)i.getLeft()) % partitions)), new StringBuilder(3).append("foo").append(i.getLeft()).toString(), new StringBuilder(3).append("bar").append(i.getRight()).toString()})))));
        } else {
            data.foreach((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)records.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i.getLeft(), new StringBuilder(3).append("foo").append(i.getLeft()).toString(), new StringBuilder(3).append("bar").append(i.getRight()).toString()})))));
        }
        StructType struct = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("c2", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("c3", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
        Dataset df = this.spark().createDataFrame(records, struct).repartition(files);
        this.writeDF((Dataset<Row>)df, location, options);
    }

    public void writeDF(Dataset<Row> df, String location, Map<String, String> options) {
        df.select("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c3"})).sortWithinPartitions("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2"})).write().format("hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), WriteOperationType.INSERT.value()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "c1").options(options).mode("append").save(location);
    }

    public static final /* synthetic */ boolean $anonfun$new$4(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$5(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$3(TestClusteringProcedure $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieClientFromPath($this.spark(), basePath, Predef$.MODULE$.Map().empty());
        String firstScheduleInstant = HoodieActiveTimeline.createNewInstantTime();
        client.scheduleClusteringAtInstant(firstScheduleInstant, Option.empty());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003)").toString());
        String secondScheduleInstant = HoodieActiveTimeline.createNewInstantTime();
        client.scheduleClusteringAtInstant(secondScheduleInstant, Option.empty());
        $this.checkAnswer(new StringBuilder(24).append("call show_clustering('").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secondScheduleInstant, BoxesRunTime.boxToInteger((int)1), HoodieInstant.State.REQUESTED.name(), "*"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.REQUESTED.name(), "*"}))}));
        $this.checkAnswer(new StringBuilder(80).append("call run_clustering(table => '").append(tableName).append("', order => 'ts', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secondScheduleInstant, BoxesRunTime.boxToInteger((int)1), HoodieInstant.State.COMPLETED.name(), "ts=1003"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.COMPLETED.name(), "ts=1000,ts=1001,ts=1002"}))}));
        FileSystem fs = new Path(basePath).getFileSystem($this.spark().sessionState().newHadoopConf());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)basePath, (String)secondScheduleInstant)), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        Seq finishedClustering = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$4(p))).toSeq();
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)finishedClustering.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003)}))}));
        $this.checkAnswer(new StringBuilder(33).append("call show_clustering(table => '").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secondScheduleInstant, BoxesRunTime.boxToInteger((int)1), HoodieInstant.State.COMPLETED.name(), "*"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.COMPLETED.name(), "*"}))}));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(6, 'a6', 10, 1005)").toString());
        $this.spark().sql(new StringBuilder(80).append("call run_clustering(table => '").append(tableName).append("', order => 'ts', show_involved_partition => true)").toString()).show();
        Seq thirdClusteringInstant = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).findInstantsAfter(secondScheduleInstant).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$5(p))).toSeq();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)thirdClusteringInstant.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1005)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestClusteringProcedure $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestClusteringProcedure.$anonfun$new$3($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$9(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$11(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$7(TestClusteringProcedure $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append((String)tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(31).append("call run_clustering(path => '").append(basePath).append("')").toString()).show();
            $this.checkAnswer(new StringBuilder(32).append("call show_clustering(path => '").append(basePath).append("')").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
            SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieClientFromPath($this.spark(), basePath, Predef$.MODULE$.Map().empty());
            String firstScheduleInstant = HoodieActiveTimeline.createNewInstantTime();
            client.scheduleClusteringAtInstant(firstScheduleInstant, Option.empty());
            $this.checkAnswer(new StringBuilder(65).append("call show_clustering(path => '").append(basePath).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.REQUESTED.name(), "ts=1000,ts=1001,ts=1002"}))}));
            $this.checkAnswer(new StringBuilder(46).append("call run_clustering(path => '").append(basePath).append("', order => 'ts')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.COMPLETED.name(), "*"}))}));
            $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002)}))}));
            FileSystem fs = new Path(basePath).getFileSystem($this.spark().sessionState().newHadoopConf());
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)basePath, (String)firstScheduleInstant)), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            Seq finishedClustering = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$9(p))).toSeq();
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)finishedClustering.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004)").toString());
            Seq[] resultA = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(93).append("call run_clustering(table => '").append(tableName).append("', predicate => 'ts >= 1003L', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultA.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            $this.assertResult("ts=1003,ts=1004", resultA[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004)}))}));
            finishedClustering = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$11(p))).toSeq();
            return $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)finishedClustering.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$16(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$18(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$20(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$14(TestClusteringProcedure $this, File tmp$3, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$3.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        FileSystem fs = new Path(basePath).getFileSystem($this.spark().sessionState().newHadoopConf());
        Seq[] resultA = (Seq[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Seq.class));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.checkException(new StringBuilder(87).append("call run_clustering(table => '").append(tableName).append("', predicate => 'ts <= 1001L and id = 10', order => 'ts')").toString(), "Only partition predicates are allowed");
        resultA = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(108).append("call run_clustering(table => '").append(tableName).append("', predicate => 'ts <= 1001L', order => 'ts', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultA.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        $this.assertResult("ts=1000,ts=1001", resultA[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        Seq clusteringInstants = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$16(p))).toSeq();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)clusteringInstants.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        HoodieInstant clusteringInstant = (HoodieInstant)clusteringInstants.last();
        Option clusteringPlan = HoodieDataSourceHelpers.getClusteringPlan((FileSystem)fs, (String)basePath, (String)clusteringInstant.getTimestamp());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)clusteringPlan.isPresent()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        $this.assertResult(resultA[0].apply(1), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        $this.checkAnswer(new StringBuilder(66).append("call show_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name(), "ts=1000,ts=1001"}))}));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002)}))}));
        Seq[] resultB = (Seq[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Seq.class));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(6, 'a6', 10, 1005)").toString());
        $this.checkException(new StringBuilder(102).append("call run_clustering(table => '").append(tableName).append("', predicate => 'ts > 1001L and ts <= 1005L and id = 10', order => 'ts')").toString(), "Only partition predicates are allowed");
        resultB = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(123).append("call run_clustering(table => '").append(tableName).append("', predicate => 'ts > 1001L and ts <= 1005L', order => 'ts', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultB.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        $this.assertResult("ts=1002,ts=1003,ts=1004,ts=1005", resultB[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        Seq clusteringInstants2 = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$18(p))).toSeq();
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)clusteringInstants2.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        HoodieInstant clusteringInstant2 = (HoodieInstant)clusteringInstants2.last();
        Option clusteringPlan2 = HoodieDataSourceHelpers.getClusteringPlan((FileSystem)fs, (String)basePath, (String)clusteringInstant2.getTimestamp());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)clusteringPlan2.isPresent()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        $this.assertResult(BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan2.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        $this.checkAnswer(new StringBuilder(66).append("call show_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name(), "ts=1000,ts=1001"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultB[0].head(), resultB[0].apply(1), HoodieInstant.State.COMPLETED.name(), "ts=1002,ts=1003,ts=1004,ts=1005"}))}));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1005)}))}));
        Seq[] resultC = (Seq[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Seq.class));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(7, 'a7', 10, 1006)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(8, 'a8', 10, 1007)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(9, 'a9', 10, 1008)").toString());
        $this.spark().sql(new StringBuilder(40).append("insert into ").append(tableName).append(" values(10, 'a10', 10, 1009)").toString());
        $this.checkException(new StringBuilder(100).append("call run_clustering(table => '").append(tableName).append("', predicate => 'ts < 1007L or ts >= 1008L or id = 10', order => 'ts')").toString(), "Only partition predicates are allowed");
        resultC = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(140).append("call run_clustering(table => '").append(tableName).append("', predicate => '(ts >= 1006L and ts < 1008L) or ts >= 1009L', order => 'ts', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultC.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        $this.assertResult("ts=1006,ts=1007,ts=1009", resultC[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        Seq clusteringInstants3 = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$20(p))).toSeq();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)clusteringInstants3.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        HoodieInstant clusteringInstant3 = (HoodieInstant)clusteringInstants3.last();
        Option clusteringPlan3 = HoodieDataSourceHelpers.getClusteringPlan((FileSystem)fs, (String)basePath, (String)clusteringInstant3.getTimestamp());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)clusteringPlan3.isPresent()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan3.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        $this.checkAnswer(new StringBuilder(66).append("call show_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name(), "ts=1000,ts=1001"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultB[0].head(), resultB[0].apply(1), HoodieInstant.State.COMPLETED.name(), "ts=1002,ts=1003,ts=1004,ts=1005"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultC[0].head(), resultC[0].apply(1), HoodieInstant.State.COMPLETED.name(), "ts=1006,ts=1007,ts=1009"}))}));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1005)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1006)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1007)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1008)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), "a10", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1009)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$13(TestClusteringProcedure $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestClusteringProcedure.$anonfun$new$14($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$22(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(ts)\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1010)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1010)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1011)").toString());
        $this.spark().sql(new StringBuilder(12).append("set ").append(HoodieClusteringConfig.PARTITION_SELECTED.key()).append("=ts=1010").toString());
        Seq[] result = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(65).append("call run_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        $this.assertResult("ts=1010", result[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1011)}))}));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1010)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1011)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(6, 'a6', 10, 1012)").toString());
        $this.spark().sql(new StringBuilder(28).append("set ").append(HoodieClusteringConfig.PARTITION_SELECTED.key()).append("=ts=1010,ts=1011,ts=1012").toString());
        Seq[] result2 = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(65).append("call run_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result2.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        $this.assertResult("ts=1010,ts=1011,ts=1012", result2[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1011)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1011)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1012)}))}));
    }

    public static final /* synthetic */ void $anonfun$avgRecord$1(HoodieTimeline commitTimeline$1, LongRef totalByteSize$1, LongRef totalRecordsCount$1, Object instant) {
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])commitTimeline$1.getInstantDetails((HoodieInstant)instant).get()), HoodieCommitMetadata.class);
        totalByteSize$1.elem += commitMetadata.fetchTotalBytesWritten();
        totalRecordsCount$1.elem += commitMetadata.fetchTotalRecordsWritten();
    }

    public static final /* synthetic */ Pair $anonfun$writeRecords$2(int x$1, int y) {
        return Pair.of((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)BoxesRunTime.boxToInteger((int)y));
    }

    public static final /* synthetic */ Stream $anonfun$writeRecords$1(int rowDimension$1, int x) {
        return (Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)rowDimension$1), (Object)BoxesRunTime.boxToInteger((int)1), (Integral)Numeric.IntIsIntegral$.MODULE$).map((Function1 & Serializable & scala.Serializable)y -> TestClusteringProcedure.$anonfun$writeRecords$2(x, BoxesRunTime.unboxToInt((Object)y)), Stream$.MODULE$.canBuildFrom());
    }

    public TestClusteringProcedure() {
        this.test("Test Call run_clustering Procedure By Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Test Call run_clustering Procedure By Path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("Test Call run_clustering Procedure With Partition Pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$13(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("Test Call run_clustering with partition selected config", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
    }
}

