/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple8;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0011#\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBQa\u000e\u0001\u0005\u0002aBq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002J\u0001!I!a\u0013\u0007\r\u0005\r\u0004\u0001AA3\u0011)\ti'\u0002BA\u0002\u0013\u0005\u0011q\u000e\u0005\u000b\u0003o*!\u00111A\u0005\u0002\u0005e\u0004BCA@\u000b\t\u0005\t\u0015)\u0003\u0002r!I\u0011\u0011Q\u0003\u0003\u0002\u0004%\tA\u001c\u0005\u000b\u0003\u0007+!\u00111A\u0005\u0002\u0005\u0015\u0005\"CAE\u000b\t\u0005\t\u0015)\u0003b\u0011%\tY)\u0002BA\u0002\u0013\u0005a\u000e\u0003\u0006\u0002\u000e\u0016\u0011\t\u0019!C\u0001\u0003\u001fC\u0011\"a%\u0006\u0005\u0003\u0005\u000b\u0015B1\t\u0013\u0005UUA!a\u0001\n\u0003q\u0007BCAL\u000b\t\u0005\r\u0011\"\u0001\u0002\u001a\"I\u0011QT\u0003\u0003\u0002\u0003\u0006K!\u0019\u0005\u000b\u0003?+!\u00111A\u0005\u0002\u0005\u0005\u0006BCAU\u000b\t\u0005\r\u0011\"\u0001\u0002,\"Q\u0011qV\u0003\u0003\u0002\u0003\u0006K!a)\t\u0015\u0005EVA!a\u0001\n\u0003\t\t\u000b\u0003\u0006\u00024\u0016\u0011\t\u0019!C\u0001\u0003kC!\"!/\u0006\u0005\u0003\u0005\u000b\u0015BAR\u0011)\tY,\u0002BA\u0002\u0013\u0005\u0011\u0011\u0015\u0005\u000b\u0003{+!\u00111A\u0005\u0002\u0005}\u0006BCAb\u000b\t\u0005\t\u0015)\u0003\u0002$\"Q\u0011QY\u0003\u0003\u0002\u0004%\t!!)\t\u0015\u0005\u001dWA!a\u0001\n\u0003\tI\r\u0003\u0006\u0002N\u0016\u0011\t\u0011)Q\u0005\u0003GCa\u0001N\u0003\u0005\u0002\u0005=\u0007bBAs\u000b\u0011\u0005\u0013q\u001d\u0005\b\u0003s,A\u0011IA~\u0005y!Vm\u001d;II\u001a\u001c\b+\u0019:rk\u0016$\u0018*\u001c9peR\u0004&o\\2fIV\u0014XM\u0003\u0002$I\u0005I\u0001O]8dK\u0012,(/\u001a\u0006\u0003K\u0019\nA\u0001[;eS*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011AI\u0005\u0003g\t\u0012A\u0004S8pI&,7\u000b]1sWB\u0013xnY3ekJ,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002mA\u0011\u0011\u0007A\u0001\u0014GJ,\u0017\r^3J]N,'\u000f\u001e*fG>\u0014Hm\u001d\u000b\u0003s%\u00032AO B\u001b\u0005Y$B\u0001\u001f>\u0003\u0011)H/\u001b7\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u00069q-\u001a8fe&\u001c'B\u0001$+\u0003\u0011\tgO]8\n\u0005!\u001b%!D$f]\u0016\u0014\u0018n\u0019*fG>\u0014H\rC\u0003K\u0005\u0001\u00071*A\u0005te\u000e4u\u000e\u001c3feB\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0003MNT!\u0001\u0015\u0016\u0002\r!\fGm\\8q\u0013\t\u0011VJ\u0001\u0003QCRD\u0007f\u0001\u0002UAB\u0019Q\u000b\u0017.\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a\u0001\u001e5s_^\u001c\bCA._\u001b\u0005a&BA/>\u0003\tIw.\u0003\u0002`9\nY\u0011jT#yG\u0016\u0004H/[8oc\u0015q\u0012\r\\A\u0006!\t\u0011\u0017N\u0004\u0002dOB\u0011AMV\u0007\u0002K*\u0011aML\u0001\u0007yI|w\u000e\u001e \n\u0005!4\u0016A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001\u001b,2\r\rj\u0017/!\u0001s+\tqw.F\u0001b\t\u0015\u0001hF1\u0001v\u0005\u0005!\u0016B\u0001:t\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0011AOV\u0001\u0007i\"\u0014xn^:\u0012\u0005YL\bCA+x\u0013\tAhKA\u0004O_RD\u0017N\\4\u0011\u0005ilhBA+|\u0013\tah+A\u0004qC\u000e\\\u0017mZ3\n\u0005y|(!\u0003+ie><\u0018M\u00197f\u0015\tah+\r\u0005$\u0003\u0007\t)!a\u0002u\u001d\r)\u0016QA\u0005\u0003iZ\u000bTAI+W\u0003\u0013\u0011Qa]2bY\u0006\f$A\n.)\u000b\t\ty!!\t\u0011\tUC\u0016\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0019\u0001\u0018M]:fe*\u0019\u00111\u0004\u0014\u0002\u0011\r\fG/\u00197zgRLA!a\b\u0002\u0016\tq\u0001+\u0019:tK\u0016C8-\u001a9uS>t\u0017G\u0002\u0010b\u0003G\tI#\r\u0004$[F\f)C]\u0019\tG\u0005\r\u0011QAA\u0014iF*!%\u0016,\u0002\nE\u001aa%!\u0005\u0002'\r\u0014X-\u0019;f+B\u001cXM\u001d;SK\u000e|'\u000fZ:\u0015\u0007e\ny\u0003C\u0003K\u0007\u0001\u00071\n\u000b\u0003\u0004)\u0006M\u0012G\u0002\u0010b\u0003k\tY$\r\u0004$[F\f9D]\u0019\tG\u0005\r\u0011QAA\u001diF*!%\u0016,\u0002\nE\u0012aE\u0017\u0015\u0006\u0007\u0005=\u0011qH\u0019\u0007=\u0005\f\t%a\u00122\r\rj\u0017/a\u0011sc!\u0019\u00131AA\u0003\u0003\u000b\"\u0018'\u0002\u0012V-\u0006%\u0011g\u0001\u0014\u0002\u0012\u0005\u0001b/\u001a:jMf\u0014Vm];mi\u0012\u000bG/\u0019\u000b\t\u0003\u001b\n\u0019&a\u0016\u0002`A\u0019Q+a\u0014\n\u0007\u0005EcK\u0001\u0003V]&$\bBBA+\t\u0001\u0007\u0011(\u0001\u0006fqB,7\r\u001e#bi\u0006DaA\u0014\u0003A\u0002\u0005e\u0003c\u0001'\u0002\\%\u0019\u0011QL'\u0003\u0015\u0019KG.Z*zgR,W\u000e\u0003\u0004\u0002b\u0011\u0001\r!Y\u0001\ni\u0006\u0014G.\u001a)bi\"\u0014q\u0002S8pI&,GK]5q\u001b>$W\r\\\n\u0004\u000b\u0005\u001d\u0004cA+\u0002j%\u0019\u00111\u000e,\u0003\r\u0005s\u0017PU3g\u0003%!\u0018.\\3ti\u0006l\u0007/\u0006\u0002\u0002rA\u0019Q+a\u001d\n\u0007\u0005UdK\u0001\u0003M_:<\u0017!\u0004;j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005m\u0004\"CA?\u000f\u0005\u0005\t\u0019AA9\u0003\rAH%M\u0001\u000bi&lWm\u001d;b[B\u0004\u0013A\u0002:po.+\u00170\u0001\u0006s_^\\U-_0%KF$B!!\u0014\u0002\b\"A\u0011Q\u0010\u0006\u0002\u0002\u0003\u0007\u0011-A\u0004s_^\\U-\u001f\u0011\u0002\u000bILG-\u001a:\u0002\u0013ILG-\u001a:`I\u0015\fH\u0003BA'\u0003#C\u0001\"! \u000e\u0003\u0003\u0005\r!Y\u0001\u0007e&$WM\u001d\u0011\u0002\r\u0011\u0014\u0018N^3s\u0003)!'/\u001b<fe~#S-\u001d\u000b\u0005\u0003\u001b\nY\n\u0003\u0005\u0002~A\t\t\u00111\u0001b\u0003\u001d!'/\u001b<fe\u0002\n\u0001BY3hS:d\u0015\r^\u000b\u0003\u0003G\u00032!VAS\u0013\r\t9K\u0016\u0002\u0007\t>,(\r\\3\u0002\u0019\t,w-\u001b8MCR|F%Z9\u0015\t\u00055\u0013Q\u0016\u0005\n\u0003{\u001a\u0012\u0011!a\u0001\u0003G\u000b\u0011BY3hS:d\u0015\r\u001e\u0011\u0002\u0011\t,w-\u001b8M_:\fABY3hS:duN\\0%KF$B!!\u0014\u00028\"I\u0011Q\u0010\f\u0002\u0002\u0003\u0007\u00111U\u0001\nE\u0016<\u0017N\u001c'p]\u0002\na!\u001a8e\u0019\u0006$\u0018AC3oI2\u000bGo\u0018\u0013fcR!\u0011QJAa\u0011%\ti(GA\u0001\u0002\u0004\t\u0019+A\u0004f]\u0012d\u0015\r\u001e\u0011\u0002\r\u0015tG\rT8o\u0003))g\u000e\u001a'p]~#S-\u001d\u000b\u0005\u0003\u001b\nY\rC\u0005\u0002~q\t\t\u00111\u0001\u0002$\u00069QM\u001c3M_:\u0004CCEAi\u0003+\f9.!7\u0002\\\u0006u\u0017q\\Aq\u0003G\u00042!a5\u0006\u001b\u0005\u0001\u0001bBA7=\u0001\u0007\u0011\u0011\u000f\u0005\u0007\u0003\u0003s\u0002\u0019A1\t\r\u0005-e\u00041\u0001b\u0011\u0019\t)J\ba\u0001C\"9\u0011q\u0014\u0010A\u0002\u0005\r\u0006bBAY=\u0001\u0007\u00111\u0015\u0005\b\u0003ws\u0002\u0019AAR\u0011\u001d\t)M\ba\u0001\u0003G\u000ba!Z9vC2\u001cH\u0003BAu\u0003_\u00042!VAv\u0013\r\tiO\u0016\u0002\b\u0005>|G.Z1o\u0011\u001d\t\tp\ba\u0001\u0003g\f\u0011a\u001c\t\u0004+\u0006U\u0018bAA|-\n\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!@\u0011\u0007U\u000by0C\u0002\u0003\u0002Y\u00131!\u00138u\u0001")
public class TestHdfsParquetImportProcedure
extends HoodieSparkProcedureTestBase {
    public java.util.List<GenericRecord> createInsertRecords(Path srcFolder) throws ParseException, IOException {
        Path srcFile = new Path(srcFolder.toString(), "file1.parquet");
        long startTime = HoodieActiveTimeline.parseDateFromInstantTime((String)"20170203000000").getTime() / 1000L;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 96).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)recordNum -> records.add(new HoodieTestDataGenerator().generateGenericRecord(((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), "0", new StringBuilder(6).append("rider-").append(recordNum).toString(), new StringBuilder(7).append("driver-").append(recordNum).toString(), startTime + TimeUnit.HOURS.toSeconds(recordNum))));
        try (ParquetWriter writer = AvroParquetWriter.builder((Path)srcFile).withSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withConf(HoodieTestUtils.getDefaultHadoopConf()).build();){
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(records).foreach((Function1 & Serializable & scala.Serializable)record -> {
                writer.write((Object)record);
                return BoxedUnit.UNIT;
            });
        }
        return records;
    }

    public java.util.List<GenericRecord> createUpsertRecords(Path srcFolder) throws ParseException, IOException {
        Path srcFile = new Path(srcFolder.toString(), "file1.parquet");
        long startTime = HoodieActiveTimeline.parseDateFromInstantTime((String)"20170203000000").getTime() / 1000L;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)recordNum -> records.add(dataGen.generateGenericRecord(((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), "0", new StringBuilder(13).append("rider-upsert-").append(recordNum).toString(), new StringBuilder(13).append("driver-upsert").append(recordNum).toString(), startTime + TimeUnit.HOURS.toSeconds(recordNum))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(96), 100).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)recordNum -> records.add(dataGen.generateGenericRecord(((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), "0", new StringBuilder(13).append("rider-upsert-").append(recordNum).toString(), new StringBuilder(13).append("driver-upsert").append(recordNum).toString(), startTime + TimeUnit.HOURS.toSeconds(recordNum))));
        try (ParquetWriter writer = AvroParquetWriter.builder((Path)srcFile).withSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withConf(HoodieTestUtils.getDefaultHadoopConf()).build();){
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(records).foreach((Function1 & Serializable & scala.Serializable)record -> {
                writer.write((Object)record);
                return BoxedUnit.UNIT;
            });
        }
        return records;
    }

    private void verifyResultData(java.util.List<GenericRecord> expectData, FileSystem fs, String tablePath) {
        JavaSparkContext jsc = new JavaSparkContext(this.spark().sparkContext());
        Dataset ds = HoodieClientTestUtils.read((JavaSparkContext)jsc, (String)tablePath, (SQLContext)this.spark().sqlContext(), (FileSystem)fs, (String[])new String[]{new StringBuilder(8).append(tablePath).append("/*/*/*/*").toString()});
        java.util.List readData = ds.select("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "rider", "driver", "begin_lat", "begin_lon", "end_lat", "end_lon"})).collectAsList();
        List result = (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(readData).toList().map((Function1 & Serializable & scala.Serializable)row -> new HoodieTripModel(this, row.getLong(0), row.getString(1), row.getString(2), row.getString(3), row.getDouble(4), row.getDouble(5), row.getDouble(6), row.getDouble(7)), List$.MODULE$.canBuildFrom());
        List expected = (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(expectData).toList().map((Function1 & Serializable & scala.Serializable)g -> new HoodieTripModel(this, BoxesRunTime.unboxToLong((Object)g.get("timestamp")), g.get("_row_key").toString(), g.get("rider").toString(), g.get("driver").toString(), new StringOps(Predef$.MODULE$.augmentString(g.get("begin_lat").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("begin_lon").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("end_lat").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("end_lon").toString())).toDouble()), List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((expected.size() == result.size() || JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result).containsAll(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)expected)) && JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)expected).containsAll(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result)) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$new$2(TestHdfsParquetImportProcedure $this, File tmp) {
        FileSystem fs = FSUtils.getFs((String)tmp.getCanonicalPath(), (Configuration)$this.spark().sparkContext().hadoopConfiguration());
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        Path sourcePath = new Path(tmp.getCanonicalPath(), "source");
        Path targetPath = new Path(tablePath);
        String schemaFile = new Path(tmp.getCanonicalPath(), "file.schema").toString();
        try (FSDataOutputStream schemaFileOS = fs.create(new Path(schemaFile));){
            schemaFileOS.write("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}".getBytes());
        }
        java.util.List<GenericRecord> insertData = $this.createInsertRecords(sourcePath);
        $this.checkExceptionContain("call hdfs_parquet_import(table_type => 'mor')", "Argument: table is required");
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("call hdfs_parquet_import(\n           |table => '").append(tableName).append("', table_type => '").append(HoodieTableType.COPY_ON_WRITE.name()).append("',\n           |src_path => '").append(sourcePath).append("', target_path => '").append(targetPath).append("',\n           |row_key => '_row_key', partition_key => 'timestamp',\n           |schema_file_path => '").append(schemaFile).append("')").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.verifyResultData(insertData, fs, tablePath);
    }

    public static final /* synthetic */ void $anonfun$new$4(TestHdfsParquetImportProcedure $this, File tmp) {
        FileSystem fs = FSUtils.getFs((String)tmp.getCanonicalPath(), (Configuration)$this.spark().sparkContext().hadoopConfiguration());
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        Path sourcePath = new Path(tmp.getCanonicalPath(), "source");
        Path targetPath = new Path(tablePath);
        String schemaFile = new Path(tmp.getCanonicalPath(), "file.schema").toString();
        try (FSDataOutputStream schemaFileOS = fs.create(new Path(schemaFile));){
            schemaFileOS.write("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}".getBytes());
        }
        java.util.List<GenericRecord> insertData = $this.createUpsertRecords(sourcePath);
        $this.checkExceptionContain("call hdfs_parquet_import(table_type => 'mor')", "Argument: table is required");
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(237).append("call hdfs_parquet_import(\n           |table => '").append(tableName).append("', table_type => '").append(HoodieTableType.COPY_ON_WRITE.name()).append("',\n           |src_path => '").append(sourcePath).append("', target_path => '").append(targetPath).append("',\n           |row_key => '_row_key', partition_key => 'timestamp',\n           |schema_file_path => '").append(schemaFile).append("', command => 'upsert')").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.verifyResultData(insertData, fs, tablePath);
    }

    public TestHdfsParquetImportProcedure() {
        this.test("Test Call hdfs_parquet_import Procedure with insert operation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHdfsParquetImportProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHdfsParquetImportProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Test Call hdfs_parquet_import Procedure with upsert operation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHdfsParquetImportProcedure.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHdfsParquetImportProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    public class HoodieTripModel {
        private long timestamp;
        private String rowKey;
        private String rider;
        private String driver;
        private double beginLat;
        private double beginLon;
        private double endLat;
        private double endLon;
        public final /* synthetic */ TestHdfsParquetImportProcedure $outer;

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public String rowKey() {
            return this.rowKey;
        }

        public void rowKey_$eq(String x$1) {
            this.rowKey = x$1;
        }

        public String rider() {
            return this.rider;
        }

        public void rider_$eq(String x$1) {
            this.rider = x$1;
        }

        public String driver() {
            return this.driver;
        }

        public void driver_$eq(String x$1) {
            this.driver = x$1;
        }

        public double beginLat() {
            return this.beginLat;
        }

        public void beginLat_$eq(double x$1) {
            this.beginLat = x$1;
        }

        public double beginLon() {
            return this.beginLon;
        }

        public void beginLon_$eq(double x$1) {
            this.beginLon = x$1;
        }

        public double endLat() {
            return this.endLat;
        }

        public void endLat_$eq(double x$1) {
            this.endLat = x$1;
        }

        public double endLon() {
            return this.endLon;
        }

        public void endLon_$eq(double x$1) {
            this.endLon = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            HoodieTripModel hoodieTripModel = this;
            Object object = o;
            if (hoodieTripModel == null) {
                if (object == null) return true;
            } else if (((Object)hoodieTripModel).equals(object)) {
                return true;
            }
            if (o == null) return false;
            if (this.getClass() != o.getClass()) {
                return false;
            }
            HoodieTripModel other = (HoodieTripModel)o;
            if (this.timestamp() != other.timestamp()) return false;
            String string = this.rowKey();
            String string2 = other.rowKey();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.rider();
            String string4 = other.rider();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.driver();
            String string6 = other.driver();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (this.beginLat() != other.beginLat()) return false;
            if (this.beginLon() != other.beginLon()) return false;
            if (this.endLat() != other.endLat()) return false;
            if (this.endLon() != other.endLon()) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(new Tuple8((Object)BoxesRunTime.boxToLong((long)this.timestamp()), (Object)this.rowKey(), (Object)this.rider(), (Object)this.driver(), (Object)BoxesRunTime.boxToDouble((double)this.beginLat()), (Object)BoxesRunTime.boxToDouble((double)this.beginLon()), (Object)BoxesRunTime.boxToDouble((double)this.endLat()), (Object)BoxesRunTime.boxToDouble((double)this.endLon())));
        }

        public /* synthetic */ TestHdfsParquetImportProcedure org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$HoodieTripModel$$$outer() {
            return this.$outer;
        }

        public HoodieTripModel(TestHdfsParquetImportProcedure $outer, long timestamp, String rowKey, String rider, String driver, double beginLat, double beginLon, double endLat, double endLon) {
            this.timestamp = timestamp;
            this.rowKey = rowKey;
            this.rider = rider;
            this.driver = driver;
            this.beginLat = beginLat;
            this.beginLon = beginLon;
            this.endLat = endLat;
            this.endLon = endLon;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

