/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\u000b\u0016\u0001\tBQa\n\u0001\u0005\u0002!BqA\u000b\u0001A\u0002\u0013%1\u0006C\u0004:\u0001\u0001\u0007I\u0011\u0002\u001e\t\r\u0005\u0003\u0001\u0015)\u0003-\u0011\u001d\u0011\u0005\u00011A\u0005\n-Bqa\u0011\u0001A\u0002\u0013%A\t\u0003\u0004G\u0001\u0001\u0006K\u0001\f\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003,\u0011\u001dA\u0005\u00011A\u0005\n%Caa\u0013\u0001!B\u0013a\u0003b\u0002'\u0001\u0001\u0004%Ia\u000b\u0005\b\u001b\u0002\u0001\r\u0011\"\u0003O\u0011\u0019\u0001\u0006\u0001)Q\u0005Y!9\u0011\u000b\u0001a\u0001\n\u0013\u0011\u0006b\u0002/\u0001\u0001\u0004%I!\u0018\u0005\u0007?\u0002\u0001\u000b\u0015B*\t\u000b\u0001\u0004A\u0011B1\t\u000b9\u0004A\u0011B8\t\u000ba\u0004A\u0011A=\u0003)Q+7\u000f\u001e*fa\u0006L'o\u001d)s_\u000e,G-\u001e:f\u0015\t1r#A\u0005qe>\u001cW\rZ;sK*\u0011\u0001$G\u0001\u0005QV$\u0017N\u0003\u0002\u001b7\u0005\u00191/\u001d7\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001GA\u0011A%J\u0007\u0002+%\u0011a%\u0006\u0002\u001d\u0011>|G-[3Ta\u0006\u00148\u000e\u0015:pG\u0016$WO]3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002%\u0001\u00059B-\u001e9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]B\u000bG\u000f[\u000b\u0002YA\u0011QF\u000e\b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR!!M\u0011\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0012\u0014a\u00073va2L7-\u0019;fIB\u000b'\u000f^5uS>t\u0007+\u0019;i?\u0012*\u0017\u000f\u0006\u0002<\u007fA\u0011A(P\u0007\u0002e%\u0011aH\r\u0002\u0005+:LG\u000fC\u0004A\u0007\u0005\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0013'\u0001\rekBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|g\u000eU1uQ\u0002\n!\u0005Z;qY&\u001c\u0017\r^3e!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5XSRDW\u000b\u001d3bi\u0016\u001c\u0018A\n3va2L7-\u0019;fIB\u000b'\u000f^5uS>t\u0007+\u0019;i/&$\b.\u00169eCR,7o\u0018\u0013fcR\u00111(\u0012\u0005\b\u0001\u001a\t\t\u00111\u0001-\u0003\r\"W\u000f\u001d7jG\u0006$X\r\u001a)beRLG/[8o!\u0006$\bnV5uQV\u0003H-\u0019;fg\u0002\n!\u0005Z;qY&\u001c\u0017\r^3e!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5XSRDW\u000b]:feR\u001c\u0018A\n3va2L7-\u0019;fIB\u000b'\u000f^5uS>t\u0007+\u0019;i/&$\b.\u00169tKJ$8o\u0018\u0013fcR\u00111H\u0013\u0005\b\u0001&\t\t\u00111\u0001-\u0003\r\"W\u000f\u001d7jG\u0006$X\r\u001a)beRLG/[8o!\u0006$\bnV5uQV\u00038/\u001a:ug\u0002\n!C]3qC&\u0014X\rZ(viB,H\u000fU1uQ\u00061\"/\u001a9bSJ,GmT;uaV$\b+\u0019;i?\u0012*\u0017\u000f\u0006\u0002<\u001f\"9\u0001\tDA\u0001\u0002\u0004a\u0013a\u0005:fa\u0006L'/\u001a3PkR\u0004X\u000f\u001e)bi\"\u0004\u0013A\u00034jY\u00164uN]7biV\t1\u000b\u0005\u0002U56\tQK\u0003\u0002W/\u0006)Qn\u001c3fY*\u0011\u0001,W\u0001\u0007G>lWn\u001c8\u000b\u0005ai\u0012BA.V\u0005AAun\u001c3jK\u001aKG.\u001a$pe6\fG/\u0001\bgS2,gi\u001c:nCR|F%Z9\u0015\u0005mr\u0006b\u0002!\u0010\u0003\u0003\u0005\raU\u0001\fM&dWMR8s[\u0006$\b%A\bhK:,'/\u0019;f%\u0016\u001cwN\u001d3t)\u0011Y$\r\u001a4\t\u000b\r\f\u0002\u0019\u0001\u0017\u0002\u0013Q\f'\r\\3QCRD\u0007\"B3\u0012\u0001\u0004a\u0013\u0001\u00032bg\"\u0004\u0018\r\u001e5\t\u000b\u001d\f\u0002\u0019\u00015\u0002\u00155,G/Y\"mS\u0016tG\u000f\u0005\u0002jY6\t!N\u0003\u0002l/\u0006)A/\u00192mK&\u0011QN\u001b\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u000399W\r\u001e*fG>\u0014HmQ8v]R$\"\u0001]:\u0011\u0005q\n\u0018B\u0001:3\u0005\u0011auN\\4\t\u000bQ\u0014\u0002\u0019A;\u0002\u000b\u0019LG.Z:\u0011\u0007q2H&\u0003\u0002xe\t)\u0011I\u001d:bs\u0006i2M]3bi\u0016,U\u000e\u001d;z\u00072,\u0017M\u001c*fcV,7\u000f^3e\r&dW\r\u0006\u0003<urt\b\"B>\u0014\u0001\u0004a\u0013\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\t\u000bu\u001c\u0002\u0019\u0001\u0017\u0002\u0017%t7\u000f^1oiRKW.\u001a\u0005\u0007\u007fN\u0001\r!!\u0001\u0002\u001b\r|gNZ5hkJ\fG/[8o!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tAaY8oM*\u0019\u00111B\u000f\u0002\r!\fGm\\8q\u0013\u0011\ty!!\u0002\u0003\u001b\r{gNZ5hkJ\fG/[8oQ\u0015\u0019\u00121CA\u0015!\u0015a\u0014QCA\r\u0013\r\t9B\r\u0002\u0007i\"\u0014xn^:\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005\u0011\u0011n\u001c\u0006\u0003\u0003G\tAA[1wC&!\u0011qEA\u000f\u0005-Iu*\u0012=dKB$\u0018n\u001c82\rya\u00131FA.c%\u0019\u0013QFA\u001a\u0003#\n)$F\u0002,\u0003_!q!!\r\"\u0005\u0004\tYDA\u0001U\u0013\u0011\t)$a\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tIDM\u0001\u0007i\"\u0014xn^:\u0012\t\u0005u\u00121\t\t\u0004y\u0005}\u0012bAA!e\t9aj\u001c;iS:<\u0007\u0003BA#\u0003\u0017r1\u0001PA$\u0013\r\tIEM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti%a\u0014\u0003\u0013QC'o\\<bE2,'bAA%eEJ1%a\u0015\u0002V\u0005]\u0013\u0011\b\b\u0004y\u0005U\u0013bAA\u001deE*!\u0005\u0010\u001a\u0002Z\t)1oY1mCF\u001aa%!\u0007")
public class TestRepairsProcedure
extends HoodieSparkProcedureTestBase {
    private String duplicatedPartitionPath;
    private String duplicatedPartitionPathWithUpdates;
    private String duplicatedPartitionPathWithUpserts;
    private String repairedOutputPath;
    private HoodieFileFormat fileFormat;

    private String duplicatedPartitionPath() {
        return this.duplicatedPartitionPath;
    }

    private void duplicatedPartitionPath_$eq(String x$1) {
        this.duplicatedPartitionPath = x$1;
    }

    private String duplicatedPartitionPathWithUpdates() {
        return this.duplicatedPartitionPathWithUpdates;
    }

    private void duplicatedPartitionPathWithUpdates_$eq(String x$1) {
        this.duplicatedPartitionPathWithUpdates = x$1;
    }

    private String duplicatedPartitionPathWithUpserts() {
        return this.duplicatedPartitionPathWithUpserts;
    }

    private void duplicatedPartitionPathWithUpserts_$eq(String x$1) {
        this.duplicatedPartitionPathWithUpserts = x$1;
    }

    private String repairedOutputPath() {
        return this.repairedOutputPath;
    }

    private void repairedOutputPath_$eq(String x$1) {
        this.repairedOutputPath = x$1;
    }

    private HoodieFileFormat fileFormat() {
        return this.fileFormat;
    }

    private void fileFormat_$eq(HoodieFileFormat x$1) {
        this.fileFormat = x$1;
    }

    private void generateRecords(String tablePath, String bashpath, HoodieTableMetaClient metaClient) {
        this.duplicatedPartitionPath_$eq(((Object)Paths.get(tablePath, "2016/03/15")).toString());
        this.duplicatedPartitionPathWithUpdates_$eq(((Object)Paths.get(tablePath, "2015/03/16")).toString());
        this.duplicatedPartitionPathWithUpserts_$eq(((Object)Paths.get(tablePath, "2015/03/17")).toString());
        this.repairedOutputPath_$eq(((Object)Paths.get(bashpath, "tmp")).toString());
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of((HoodieTableMetaClient)metaClient, (Schema)schema);
        java.util.List hoodieRecords1 = SchemaTestUtil.generateHoodieTestRecords((int)0, (int)100, (Schema)schema);
        java.util.List hoodieRecords2 = SchemaTestUtil.generateHoodieTestRecords((int)100, (int)100, (Schema)schema);
        testTable.addCommit("20160401010101").withInserts("2016/03/15", "1", hoodieRecords1);
        testTable.withInserts("2016/03/15", "2", hoodieRecords2);
        testTable.getFileIdWithLogFile("2016/03/15");
        testTable.withInserts("2015/03/16", "4", hoodieRecords1);
        testTable.withInserts("2015/03/17", "6", hoodieRecords1);
        java.util.List dupRecords = hoodieRecords1.subList(0, 10);
        testTable.withInserts("2015/03/16", "5", dupRecords);
        testTable.addCommit("20160401010202").withInserts("2016/03/15", "3", dupRecords);
        testTable.withInserts("2015/03/17", "7", dupRecords);
        testTable.withInserts("2015/03/17", "8", dupRecords);
        this.fileFormat_$eq(metaClient.getTableConfig().getBaseFileFormat());
    }

    private long getRecordCount(String[] files) {
        LongRef recordCount = LongRef.create((long)0L);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            TestRepairsProcedure.$anonfun$getRecordCount$1(this, recordCount, file);
            return BoxedUnit.UNIT;
        });
        return recordCount.elem;
    }

    public void createEmptyCleanRequestedFile(String basePath, String instantTime, Configuration configuration) throws IOException {
        Path commitFilePath = new Path(new StringBuilder(9).append(basePath).append("/").append(".hoodie").append("/").append(HoodieTimeline.makeRequestedCleanerFileName((String)instantTime)).toString());
        FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)configuration);
        FSDataOutputStream os = fs.create(commitFilePath, true);
        os.close();
    }

    public static final /* synthetic */ void $anonfun$new$2(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        Files.createFile(Paths.get(tablePath, ".hoodie", "100.commit"), new FileAttribute[0]);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext($this.spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
        String partition1 = ((Object)Paths.get(tablePath, "2016/03/15")).toString();
        String partition2 = ((Object)Paths.get(tablePath, "2015/03/16")).toString();
        String partition3 = ((Object)Paths.get(tablePath, "2015/03/17")).toString();
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)metaClient.getFs().mkdirs(new Path(partition1))), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)metaClient.getFs().mkdirs(new Path(partition2))), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)metaClient.getFs().mkdirs(new Path(partition3))), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        Row[] dryResult = (Row[])$this.spark().sql(new StringBuilder(43).append("call repair_add_partition_meta(table => '").append(tableName).append("')").toString()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)dryResult.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        Row[] realRunResult = (Row[])$this.spark().sql(new StringBuilder(61).append("call repair_add_partition_meta(table => '").append(tableName).append("', dry_run => false)").toString()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)realRunResult.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public static final /* synthetic */ void $anonfun$new$4(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        URL newProps = $this.getClass().getClassLoader().getResource("table-config.properties");
        String expectedOutput = new StringOps(Predef$.MODULE$.augmentString("\n          |[hoodie.archivelog.folder,archived,archive]\n          |[hoodie.database.name,default,null]\n          |[hoodie.datasource.write.drop.partition.columns,false,false]\n          |[hoodie.datasource.write.hive_style_partitioning,true,null]\n          |[hoodie.datasource.write.partitionpath.urlencode,false,null]\n          |[hoodie.table.checksum,,]\n          |[hoodie.table.create.schema,,]\n          |[hoodie.table.keygenerator.class,org.apache.hudi.keygen.NonpartitionedKeyGenerator,null]\n          |[hoodie.table.name,,]\n          |[hoodie.table.precombine.field,ts,null]\n          |[hoodie.table.recordkey.fields,id,null]\n          |[hoodie.table.type,COPY_ON_WRITE,COPY_ON_WRITE]\n          |[hoodie.table.version,,]\n          |[hoodie.timeline.layout.version,,]")).stripMargin().trim();
        String actual = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(74).append("call repair_overwrite_hoodie_props(table => '").append(tableName).append("', new_props_file_path => '").append(newProps.getPath()).append("')").toString()).collect())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Row row = x0$1;
            String string = row.getString(0).equals("hoodie.table.checksum") ? "[hoodie.table.checksum,,]" : (row.getString(0).equals("hoodie.table.create.schema") ? "[hoodie.table.create.schema,,]" : (row.getString(0).equals("hoodie.table.name") ? "[hoodie.table.name,,]" : (row.getString(0).equals("hoodie.table.version") ? "[hoodie.table.version,,]" : (row.getString(0).equals("hoodie.timeline.layout.version") ? "[hoodie.timeline.layout.version,,]" : row.toString()))));
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
        Assertions.assertEquals((Object)expectedOutput, (Object)actual);
    }

    public static final /* synthetic */ void $anonfun$new$7(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        ObjectRef metaClient = ObjectRef.create((Object)HoodieTableMetaClient.builder().setConf(new JavaSparkContext($this.spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(100), 104).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String timestamp = String.valueOf(i);
            $this.createEmptyCleanRequestedFile(tablePath, timestamp, ((HoodieTableMetaClient)metaClient$1.elem).getHadoopConf());
        });
        metaClient.elem = HoodieTableMetaClient.reload((HoodieTableMetaClient)((HoodieTableMetaClient)metaClient.elem));
        $this.assertResult(BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)((HoodieTableMetaClient)metaClient.elem).getActiveTimeline().filterInflightsAndRequested().getInstants().count()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        $this.checkAnswer(new StringBuilder(46).append("call repair_corrupted_clean_files(table => '").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
        metaClient.elem = HoodieTableMetaClient.reload((HoodieTableMetaClient)((HoodieTableMetaClient)metaClient.elem));
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)((HoodieTableMetaClient)metaClient.elem).getActiveTimeline().filterInflightsAndRequested().getInstants().count()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
    }

    public static final /* synthetic */ void $anonfun$new$10(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String bashPath = tmp.getCanonicalPath();
        String tablePath = new StringBuilder(1).append(bashPath).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           |create table ").append(tableName).append(" (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext($this.spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
        $this.generateRecords(tablePath, bashPath, metaClient);
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path($this.duplicatedPartitionPath())));
        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)value -> value.getPath()).toList();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
        long recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)210), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        String partitionPath = "2016/03/15";
        Row[] result = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("call repair_deduplicate(table => '").append(tableName).append("',\n           | duplicated_partition_path => '").append(partitionPath).append("',\n           | repaired_output_path => '").append($this.repairedOutputPath()).append("')").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path($this.repairedOutputPath()));
        files = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatus)).map((Function1 & Serializable & scala.Serializable)status -> status.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)200), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
    }

    public static final /* synthetic */ void $anonfun$new$14(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String bashPath = tmp.getCanonicalPath();
        String tablePath = new StringBuilder(1).append(bashPath).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           |create table ").append(tableName).append(" (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext($this.spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
        $this.generateRecords(tablePath, bashPath, metaClient);
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path($this.duplicatedPartitionPathWithUpdates())));
        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)value -> value.getPath()).toList();
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
        long recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)110), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        String partitionPath = "2015/03/16";
        Row[] result = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(166).append("call repair_deduplicate(table => '").append(tableName).append("',\n           | duplicated_partition_path => '").append(partitionPath).append("',\n           | repaired_output_path => '").append($this.repairedOutputPath()).append("',\n           | dedupe_type => 'update_type')").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path($this.repairedOutputPath()));
        files = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatus)).map((Function1 & Serializable & scala.Serializable)status -> status.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
    }

    public static final /* synthetic */ void $anonfun$new$18(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String bashPath = tmp.getCanonicalPath();
        String tablePath = new StringBuilder(1).append(bashPath).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           |create table ").append(tableName).append(" (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext($this.spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
        $this.generateRecords(tablePath, bashPath, metaClient);
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path($this.duplicatedPartitionPathWithUpserts())));
        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)value -> value.getPath()).toList();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
        long recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)120), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        String partitionPath = "2015/03/17";
        Row[] result = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(166).append("call repair_deduplicate(table => '").append(tableName).append("',\n           | duplicated_partition_path => '").append(partitionPath).append("',\n           | repaired_output_path => '").append($this.repairedOutputPath()).append("',\n           | dedupe_type => 'upsert_type')").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path($this.repairedOutputPath()));
        files = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatus)).map((Function1 & Serializable & scala.Serializable)status -> status.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
    }

    public static final /* synthetic */ void $anonfun$new$22(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String bashPath = tmp.getCanonicalPath();
        String tablePath = new StringBuilder(1).append(bashPath).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n           |create table ").append(tableName).append(" (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext($this.spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
        $this.generateRecords(tablePath, bashPath, metaClient);
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path($this.duplicatedPartitionPath())));
        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)value -> value.getPath()).toList();
        $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
        long recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)210), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        String partitionPath = "2016/03/15";
        Row[] result = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(154).append("call repair_deduplicate(table => '").append(tableName).append("',\n           | duplicated_partition_path => '").append(partitionPath).append("',\n           | repaired_output_path => '").append($this.repairedOutputPath()).append("',\n           | dry_run => false)").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path($this.duplicatedPartitionPath()));
        files = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatus)).map((Function1 & Serializable & scala.Serializable)status -> status.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.endsWith(".parquet")));
        recordCount = $this.getRecordCount(files);
        $this.assertResult(BoxesRunTime.boxToInteger((int)200), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
    }

    public static final /* synthetic */ void $anonfun$new$27(TestRepairsProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(333).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | partitioned by (ts)\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName).append(" select 1, 'a1', 10, 1000").toString());
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName).append(" select 2, 'a2', 20, 1500").toString());
        Row[] result = (Row[])$this.spark().sql(new StringBuilder(47).append("call repair_migrate_partition_meta(table => '").append(tableName).append("')").toString()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        result = (Row[])$this.spark().sql(new StringBuilder(65).append("call repair_migrate_partition_meta(table => '").append(tableName).append("', dry_run => false)").toString()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
    }

    public static final /* synthetic */ void $anonfun$getRecordCount$1(TestRepairsProcedure $this, LongRef recordCount$1, String file) {
        if (HoodieFileFormat.PARQUET.equals($this.fileFormat())) {
            recordCount$1.elem += $this.spark().sqlContext().read().parquet(file).count();
        } else if (HoodieFileFormat.ORC.equals($this.fileFormat())) {
            recordCount$1.elem += $this.spark().sqlContext().read().orc(file).count();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append($this.fileFormat().name()).append(" format not supported yet.").toString());
        }
    }

    public TestRepairsProcedure() {
        this.test("Test Call repair_add_partition_meta Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Test Call repair_overwrite_hoodie_props Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Test Call repair_corrupted_clean_files Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.duplicatedPartitionPath = null;
        this.duplicatedPartitionPathWithUpdates = null;
        this.duplicatedPartitionPathWithUpserts = null;
        this.repairedOutputPath = null;
        this.fileFormat = null;
        this.test("Test Call repair_deduplicate Procedure with insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("Test Call repair_deduplicate Procedure with update", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$14(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("Test Call repair_deduplicate Procedure with upsert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("Test Call repair_deduplicate Procedure with real", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        this.test("Test Call repair_migrate_partition_meta Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRepairsProcedure.$anonfun$new$27(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
    }
}

