/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C\u00055\tyB+Z:u+B<'/\u00193f\u001fJ$un\u001e8he\u0006$W\r\u0015:pG\u0016$WO]3\u000b\u0005\u00151\u0011!\u00039s_\u000e,G-\u001e:f\u0015\t9\u0001\"\u0001\u0003ik\u0012L'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0005\u0013\t)BA\u0001\u000fI_>$\u0017.Z*qCJ\\\u0007K]8dK\u0012,(/\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005A\u0002CA\n\u0001\u0003\t\n7o]3siR\u000b'\r\\3WKJ\u001c\u0018n\u001c8Ge>l\u0007K]8qKJ$\u0018PR5mKR\u00191$\t\u0017\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006E\t\u0001\raI\u0001\u000b[\u0016$\u0018m\u00117jK:$\bC\u0001\u0013+\u001b\u0005)#B\u0001\u0014(\u0003\u0015!\u0018M\u00197f\u0015\tA\u0013&\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f1I!aK\u0013\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\")QF\u0001a\u0001]\u0005Ya/\u001a:tS>t7i\u001c3f!\tar&\u0003\u00021;\t\u0019\u0011J\u001c;)\u0007\t\u0011T\bE\u0002\u001dgUJ!\u0001N\u000f\u0003\rQD'o\\<t!\t14(D\u00018\u0015\tA\u0014(\u0001\u0002j_*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u0005-Iu*\u0012=dKB$\u0018n\u001c82\tyq\u0014J\u0019\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005kR\"\u0001\"\u000b\u0005\r\u0003\u0012A\u0002\u001fs_>$h(\u0003\u0002F;\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)U$M\u0003$\u0015:kv*\u0006\u0002L\u0019V\ta\bB\u0003N!\t\u0007!KA\u0001U\u0013\ty\u0005+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0003#v\ta\u0001\u001e5s_^\u001c\u0018CA*W!\taB+\u0003\u0002V;\t9aj\u001c;iS:<\u0007CA,[\u001d\ta\u0002,\u0003\u0002Z;\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005%!\u0006N]8xC\ndWM\u0003\u0002Z;E*1EX0a#:\u0011AdX\u0005\u0003#v\tDA\t\u000f\u001eC\n)1oY1mCF\u0012a%\u000e")
public class TestUpgradeOrDowngradeProcedure
extends HoodieSparkProcedureTestBase {
    private void assertTableVersionFromPropertyFile(HoodieTableMetaClient metaClient, int versionCode) throws IOException {
        Path propertyFile = new Path(new StringBuilder(18).append(metaClient.getMetaPath()).append("/").append("hoodie.properties").toString());
        FSDataInputStream fsDataInputStream = metaClient.getFs().open(propertyFile);
        HoodieConfig hoodieConfig = HoodieConfig.create((FSDataInputStream)fsDataInputStream);
        fsDataInputStream.close();
        this.assertResult(Integer.toString(versionCode), hoodieConfig.getString(HoodieTableConfig.VERSION), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestUpgradeOrDowngradeProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.checkExceptionContain(new StringBuilder(33).append("call downgrade_table(table => '").append(tableName).append("')").toString(), "Argument: to_version is required");
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext($this.spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.FIVE.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        $this.assertTableVersionFromPropertyFile(metaClient, HoodieTableVersion.FIVE.versionCode());
        $this.checkAnswer(new StringBuilder(55).append("call downgrade_table(table => '").append(tableName).append("', to_version => 'ZERO')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.ZERO.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        $this.assertTableVersionFromPropertyFile(metaClient, HoodieTableVersion.ZERO.versionCode());
        $this.checkAnswer(new StringBuilder(52).append("call upgrade_table(table => '").append(tableName).append("', to_version => 'ONE')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.ONE.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        $this.assertTableVersionFromPropertyFile(metaClient, HoodieTableVersion.ONE.versionCode());
    }

    public TestUpgradeOrDowngradeProcedure() {
        this.test("Test Call downgrade_table and upgrade_table Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpgradeOrDowngradeProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
    }
}

