/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.PartitionValueExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestHoodieSyncClient {
    TestHoodieSyncClient() {
    }

    @Test
    void partitionValueExtractorLoaded() {
        Properties properties = new Properties();
        properties.put("hoodie.datasource.hive_sync.partition_extractor_class", DummyExtractor.class.getName());
        HoodieSyncConfig config = new HoodieSyncConfig(properties, new Configuration());
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        try (DummySyncClient client = new DummySyncClient(config, metaClient);){
            Assertions.assertSame((Object)metaClient, (Object)client.getMetaClient());
            Assertions.assertTrue((boolean)(client.getPartitionValueExtractor() instanceof DummyExtractor));
        }
    }

    public static class DummyExtractor
    implements PartitionValueExtractor {
        public List<String> extractPartitionValuesInPath(String partitionPath) {
            return Collections.emptyList();
        }
    }

    private static class DummySyncClient
    extends HoodieSyncClient {
        protected DummySyncClient(HoodieSyncConfig config, HoodieTableMetaClient metaClient) {
            super(config, metaClient);
        }

        PartitionValueExtractor getPartitionValueExtractor() {
            return this.partitionValueExtractor;
        }

        public void close() {
        }
    }
}

