/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieSyncConfig {
    TestHoodieSyncConfig() {
    }

    @Test
    void testInferDatabaseAndTableNames() {
        Properties props1 = new Properties();
        props1.setProperty(HoodieTableConfig.DATABASE_NAME.key(), "db1");
        props1.setProperty("hoodie.table.name", "tbl1");
        HoodieSyncConfig config1 = new HoodieSyncConfig(props1, new Configuration());
        Assertions.assertEquals((Object)"db1", (Object)config1.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME));
        Assertions.assertEquals((Object)"tbl1", (Object)config1.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME));
        Properties props2 = new Properties();
        props2.setProperty(HoodieTableConfig.DATABASE_NAME.key(), "db2");
        props2.setProperty("hoodie.datasource.write.table.name", "tbl2");
        HoodieSyncConfig config2 = new HoodieSyncConfig(props2, new Configuration());
        Assertions.assertEquals((Object)"db2", (Object)config2.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME));
        Assertions.assertEquals((Object)"tbl2", (Object)config2.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME));
        HoodieSyncConfig config3 = new HoodieSyncConfig(new Properties(), new Configuration());
        Assertions.assertEquals((Object)"default", (Object)config3.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME));
        Assertions.assertEquals((Object)"unknown", (Object)config3.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME));
    }

    @Test
    void testInferBaseFileFormat() {
        Properties props1 = new Properties();
        props1.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), "ORC");
        HoodieSyncConfig config1 = new HoodieSyncConfig(props1, new Configuration());
        Assertions.assertEquals((Object)"ORC", (Object)config1.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT));
        HoodieSyncConfig config2 = new HoodieSyncConfig(new Properties(), new Configuration());
        Assertions.assertEquals((Object)"PARQUET", (Object)config2.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT));
    }

    @Test
    void testInferPartitionFields() {
        Properties props0 = new Properties();
        HoodieSyncConfig config0 = new HoodieSyncConfig(props0, new Configuration());
        Assertions.assertEquals((Object)"", (Object)config0.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), (String)String.format("should get default value due to absence of both %s and %s", HoodieTableConfig.PARTITION_FIELDS.key(), KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
        Properties props1 = new Properties();
        props1.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "foo,bar,baz");
        HoodieSyncConfig config1 = new HoodieSyncConfig(props1, new Configuration());
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)config1.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), (String)String.format("should infer from %s", HoodieTableConfig.PARTITION_FIELDS.key()));
        Properties props2 = new Properties();
        props2.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "foo,bar");
        HoodieSyncConfig config2 = new HoodieSyncConfig(props2, new Configuration());
        Assertions.assertEquals((Object)"foo,bar", (Object)config2.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), (String)String.format("should infer from %s", KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
        Properties props3 = new Properties();
        props3.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "foo,bar,baz");
        props3.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "foo,bar");
        HoodieSyncConfig config3 = new HoodieSyncConfig(props3, new Configuration());
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)config3.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), (String)String.format("should infer from %s, which has higher precedence.", HoodieTableConfig.PARTITION_FIELDS.key()));
    }

    @Test
    void testInferPartitionExtractorClass() {
        Properties props0 = new Properties();
        HoodieSyncConfig config0 = new HoodieSyncConfig(props0, new Configuration());
        Assertions.assertEquals((Object)"org.apache.hudi.hive.MultiPartKeysValueExtractor", (Object)config0.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS), (String)String.format("should get default value due to absence of both %s and %s", HoodieTableConfig.PARTITION_FIELDS.key(), KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
        Properties props1 = new Properties();
        props1.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "");
        HoodieSyncConfig config1 = new HoodieSyncConfig(props1, new Configuration());
        Assertions.assertEquals((Object)"org.apache.hudi.hive.NonPartitionedExtractor", (Object)config1.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS), (String)String.format("should infer from %s", HoodieTableConfig.PARTITION_FIELDS.key()));
        Properties props2 = new Properties();
        props2.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "foo,bar");
        HoodieSyncConfig config2 = new HoodieSyncConfig(props2, new Configuration());
        Assertions.assertEquals((Object)"org.apache.hudi.hive.MultiPartKeysValueExtractor", (Object)config2.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS), (String)String.format("should infer from %s", KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
        Properties props3 = new Properties();
        props3.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "");
        props3.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "foo,bar");
        HoodieSyncConfig config3 = new HoodieSyncConfig(props3, new Configuration());
        Assertions.assertEquals((Object)"org.apache.hudi.hive.NonPartitionedExtractor", (Object)config3.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS), (String)String.format("should infer from %s, which has higher precedence.", HoodieTableConfig.PARTITION_FIELDS.key()));
        Properties props4 = new Properties();
        props4.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "foo");
        props4.setProperty(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), "true");
        HoodieSyncConfig config4 = new HoodieSyncConfig(props4, new Configuration());
        Assertions.assertEquals((Object)"org.apache.hudi.hive.HiveStylePartitionValueExtractor", (Object)config4.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS));
        Properties props5 = new Properties();
        props5.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "foo");
        props5.setProperty(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), "false");
        HoodieSyncConfig config5 = new HoodieSyncConfig(props5, new Configuration());
        Assertions.assertEquals((Object)"org.apache.hudi.hive.SinglePartPartitionValueExtractor", (Object)config5.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS));
    }

    @Test
    void testInferDecodePartition() {
        Properties props1 = new Properties();
        props1.setProperty(HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), "true");
        HoodieSyncConfig config1 = new HoodieSyncConfig(props1, new Configuration());
        Assertions.assertTrue((boolean)config1.getBoolean(HoodieSyncConfig.META_SYNC_DECODE_PARTITION));
    }

    @Test
    void testInferUseFileListingFromMetadata() {
        HoodieSyncConfig config1 = new HoodieSyncConfig(new Properties(), new Configuration());
        Assertions.assertEquals((Object)true, (Object)config1.getBoolean(HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA));
        Properties props2 = new Properties();
        props2.setProperty(HoodieMetadataConfig.ENABLE.key(), "true");
        HoodieSyncConfig config2 = new HoodieSyncConfig(props2, new Configuration());
        Assertions.assertTrue((boolean)config2.getBoolean(HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA));
    }
}

