/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.metrics.HoodieMetaSyncMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestHoodieMetaSyncMetrics {
    @Mock
    HoodieSyncConfig syncConfig;
    @Mock
    HoodieMetricsConfig metricsConfig;
    HoodieMetaSyncMetrics hoodieSyncMetrics;
    Metrics metrics;
    private static Configuration hadoopConf;
    private static Path basepath;

    @BeforeEach
    void setUp() throws IOException {
        hadoopConf = new Configuration();
        basepath = Files.createTempDirectory("hivesyncmetricstest" + Instant.now().toEpochMilli(), new FileAttribute[0]);
        Mockito.when((Object)this.metricsConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.syncConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.syncConfig.getHadoopConf()).thenReturn((Object)hadoopConf);
        Mockito.when((Object)this.syncConfig.getBasePath()).thenReturn((Object)basepath.toUri().toString());
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.INMEMORY);
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)basepath.toUri().toString());
        Mockito.when((Object)this.metricsConfig.getMetricReporterMetricsNamePrefix()).thenReturn((Object)"test_prefix");
        this.hoodieSyncMetrics = new HoodieMetaSyncMetrics(this.syncConfig, "TestHiveSyncTool");
        this.metrics = this.hoodieSyncMetrics.getMetrics();
    }

    @AfterEach
    void shutdownMetrics() throws IOException {
        Files.delete(basepath);
        this.metrics.shutdown();
    }

    @Test
    void testUpdateRecreateAndSyncDurationInMs() throws InterruptedException {
        Timer.Context timerCtx = this.hoodieSyncMetrics.getRecreateAndSyncTimer();
        Thread.sleep(5L);
        long durationInNs = timerCtx.stop();
        this.hoodieSyncMetrics.updateRecreateAndSyncDurationInMs(durationInNs);
        String metricName = this.hoodieSyncMetrics.getMetricsName("meta_sync", "recreate_table_duration_ms");
        long timeIsMs = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((timeIsMs > 0L ? 1 : 0) != 0, (String)"recreate_table duration metric value should be > 0");
    }

    @Test
    void testIncrementRecreateAndSyncFailureCounter() {
        this.hoodieSyncMetrics.incrementRecreateAndSyncFailureCounter();
        String metricsName = this.hoodieSyncMetrics.getMetricsName("meta_sync", "meta_sync.recreate_table.failure.counter");
        long count = ((Counter)this.metrics.getRegistry().getCounters().get(metricsName)).getCount();
        Assertions.assertEquals((long)1L, (long)count, (String)"recreate_table failure counter value should be 1");
    }

    @Test
    void testIncrementRecreateAndSyncFailureCounter_WithoutMetricsNamePrefix() {
        Mockito.when((Object)this.metricsConfig.getMetricReporterMetricsNamePrefix()).thenReturn((Object)"");
        this.hoodieSyncMetrics = new HoodieMetaSyncMetrics(this.syncConfig, "TestHiveSyncTool");
        this.metrics = this.hoodieSyncMetrics.getMetrics();
        this.hoodieSyncMetrics.incrementRecreateAndSyncFailureCounter();
        String metricsName = this.hoodieSyncMetrics.getMetricsName("meta_sync", "meta_sync.recreate_table.failure.counter");
        long count = ((Counter)this.metrics.getRegistry().getCounters().get(metricsName)).getCount();
        Assertions.assertEquals((long)1L, (long)count, (String)"recreate_table failure counter value should be 1");
    }
}

