/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.sync.common.util.ManifestFileWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestManifestFileWriter
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testMultiLevelPartitionedTable() throws Exception {
        TestManifestFileWriter.createTestDataForPartitionedTable(this.metaClient, 10);
        ManifestFileWriter manifestFileWriter = ManifestFileWriter.builder().setMetaClient(this.metaClient).build();
        Assertions.assertEquals((long)30L, (long)manifestFileWriter.fetchLatestBaseFilesForAllPartitions(false).count());
    }

    @Test
    public void testCreateManifestFile() throws Exception {
        TestManifestFileWriter.createTestDataForPartitionedTable(this.metaClient, 3);
        ManifestFileWriter manifestFileWriter = ManifestFileWriter.builder().setMetaClient(this.metaClient).build();
        manifestFileWriter.writeManifestFile(false);
        StoragePath manifestFilePath = manifestFileWriter.getManifestFilePath(false);
        try (InputStream is = this.metaClient.getStorage().open(manifestFilePath);){
            List expectedLines = FileIOUtils.readAsUTFStringLines((InputStream)is);
            Assertions.assertEquals((int)9, (int)expectedLines.size(), (String)"there should be 9 base files in total; 3 per partition.");
            expectedLines.forEach(line -> Assertions.assertFalse((boolean)line.contains(this.basePath)));
        }
    }

    @Test
    public void testCreateManifestFileWithAbsolutePath() throws Exception {
        TestManifestFileWriter.createTestDataForPartitionedTable(this.metaClient, 3);
        ManifestFileWriter manifestFileWriter = ManifestFileWriter.builder().setMetaClient(this.metaClient).build();
        manifestFileWriter.writeManifestFile(true);
        StoragePath manifestFilePath = manifestFileWriter.getManifestFilePath(true);
        try (InputStream is = this.metaClient.getStorage().open(manifestFilePath);){
            List expectedLines = FileIOUtils.readAsUTFStringLines((InputStream)is);
            Assertions.assertEquals((int)9, (int)expectedLines.size(), (String)"there should be 9 base files in total; 3 per partition.");
            expectedLines.forEach(line -> Assertions.assertTrue((boolean)line.startsWith(this.metaClient.getStorage().getScheme() + ":" + this.basePath)));
        }
    }

    private static void createTestDataForPartitionedTable(HoodieTableMetaClient metaClient, int numFilesPerPartition) throws Exception {
        String instantTime = "100";
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient).addCommit("100");
        for (String partition : HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS) {
            testTable.withPartitionMetaFiles(new String[]{partition}).withBaseFilesInPartition(partition, IntStream.range(0, numFilesPerPartition).toArray());
        }
    }

    @Test
    public void getManifestSourceUri() {
        ManifestFileWriter manifestFileWriter = ManifestFileWriter.builder().setMetaClient(this.metaClient).build();
        String sourceUri = manifestFileWriter.getManifestSourceUri(false);
        Assertions.assertEquals((Object)new Path(this.basePath, ".hoodie/manifest/*").toUri().toString(), (Object)sourceUri);
        sourceUri = manifestFileWriter.getManifestSourceUri(true);
        Assertions.assertEquals((Object)new Path(this.basePath, ".hoodie/absolute-path-manifest/*").toUri().toString(), (Object)sourceUri);
    }
}

