/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.common.util.SyncUtilHelpers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TestSyncUtilHelpers {
    private static final String BASE_PATH = "/tmp/test";
    private static final String BASE_FORMAT = "PARQUET";
    private Configuration hadoopConf;
    private FileSystem fileSystem;

    @BeforeEach
    public void setUp() throws IOException {
        this.fileSystem = HadoopFSUtils.getFs((String)BASE_PATH, (Configuration)new Configuration());
        this.hadoopConf = this.fileSystem.getConf();
    }

    @ParameterizedTest
    @ValueSource(classes={DummySyncTool1.class, DummySyncTool2.class})
    public void testCreateValidSyncClass(Class<?> clazz) {
        HoodieSyncTool syncTool = SyncUtilHelpers.instantiateMetaSyncTool((String)clazz.getName(), (TypedProperties)new TypedProperties(), (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)BASE_PATH, (String)BASE_FORMAT, (Option)Option.empty());
        Assertions.assertTrue((boolean)clazz.isAssignableFrom(syncTool.getClass()));
    }

    @Test
    public void testRunValidSyncClass() {
        String testId = UUID.randomUUID().toString();
        TypedProperties properties = new TypedProperties();
        properties.setProperty("test.key", testId);
        SyncUtilHelpers.runHoodieMetaSync((String)DummySyncTool3.class.getName(), (TypedProperties)properties, (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)BASE_PATH, (String)BASE_FORMAT);
        Assertions.assertEquals((int)1, (int)((AtomicInteger)DummySyncTool3.NUM_SYNCS.get(testId)).get());
    }

    @ParameterizedTest
    @ValueSource(classes={DeprecatedSyncTool1.class, DeprecatedSyncTool2.class})
    public void testCreateDeprecatedSyncClass(Class<?> clazz) {
        HoodieSyncTool syncTool = SyncUtilHelpers.instantiateMetaSyncTool((String)clazz.getName(), (TypedProperties)new TypedProperties(), (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)BASE_PATH, (String)BASE_FORMAT, (Option)Option.empty());
        Assertions.assertTrue((boolean)clazz.isAssignableFrom(syncTool.getClass()));
    }

    @Test
    public void testCreateInvalidSyncClass() {
        Throwable t = Assertions.assertThrows(HoodieException.class, () -> SyncUtilHelpers.instantiateMetaSyncTool((String)InvalidSyncTool.class.getName(), (TypedProperties)new TypedProperties(), (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)BASE_PATH, (String)BASE_FORMAT, (Option)Option.empty()));
        String expectedMessage = "Could not load meta sync class " + InvalidSyncTool.class.getName() + ": no valid constructor found.";
        Assertions.assertEquals((Object)expectedMessage, (Object)t.getMessage());
    }

    @Test
    void testMetaSyncConcurrency() throws Exception {
        String syncToolClassName = DummySyncTool1.class.getName();
        String baseFileFormat = BASE_FORMAT;
        String tableName1 = "table1";
        String tableName2 = "table2";
        String targetBasePath1 = "path/to/target1";
        String targetBasePath2 = "path/to/target2";
        TypedProperties props1 = new TypedProperties();
        props1.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), tableName1);
        TypedProperties props2 = new TypedProperties();
        props1.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), tableName2);
        HoodieSyncTool syncToolMock = (HoodieSyncTool)Mockito.mock(HoodieSyncTool.class);
        ((HoodieSyncTool)Mockito.doAnswer(invocation -> {
            Thread.sleep(1000L);
            return null;
        }).when((Object)syncToolMock)).syncHoodieTable();
        AtomicBoolean targetBasePath1Running = new AtomicBoolean(false);
        AtomicBoolean targetBasePath2Running = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(4);
        executor.submit(() -> {
            targetBasePath1Running.set(true);
            SyncUtilHelpers.runHoodieMetaSync((String)syncToolClassName, (TypedProperties)props1, (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)targetBasePath1, (String)baseFileFormat);
            targetBasePath1Running.set(false);
        });
        executor.submit(() -> {
            Assertions.assertEquals((int)1, (int)SyncUtilHelpers.getNumberOfLocks());
            SyncUtilHelpers.runHoodieMetaSync((String)syncToolClassName, (TypedProperties)props1, (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)targetBasePath1, (String)baseFileFormat);
        });
        executor.submit(() -> {
            targetBasePath2Running.set(true);
            SyncUtilHelpers.runHoodieMetaSync((String)syncToolClassName, (TypedProperties)props2, (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)targetBasePath2, (String)baseFileFormat);
            targetBasePath2Running.set(false);
        });
        executor.submit(() -> {
            Assertions.assertEquals((int)2, (int)SyncUtilHelpers.getNumberOfLocks());
            SyncUtilHelpers.runHoodieMetaSync((String)syncToolClassName, (TypedProperties)props2, (Configuration)this.hadoopConf, (FileSystem)this.fileSystem, (String)targetBasePath2, (String)baseFileFormat);
        });
        executor.shutdown();
        Assertions.assertTrue((boolean)executor.awaitTermination(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((targetBasePath1Running.get() && targetBasePath2Running.get() ? 1 : 0) != 0, (String)"The methods did not run concurrently for different base paths");
    }

    public static class InvalidSyncTool {
        public InvalidSyncTool(Properties props, FileSystem fs, Configuration hadoopConf) {
        }
    }

    public static class DeprecatedSyncTool2
    extends HoodieSyncTool {
        public DeprecatedSyncTool2(Properties props, FileSystem fs) {
            super(props, fs);
        }

        public void syncHoodieTable() {
            throw new HoodieException("Method unimplemented as its a test class");
        }
    }

    public static class DeprecatedSyncTool1
    extends HoodieSyncTool {
        public DeprecatedSyncTool1(TypedProperties props, Configuration hadoopConf, FileSystem fs) {
            super(props, hadoopConf, fs);
        }

        public void syncHoodieTable() {
            throw new HoodieException("Method unimplemented as its a test class");
        }
    }

    public static class DummySyncTool3
    extends HoodieSyncTool {
        private static final String SYNC_KEY = "test.key";
        private static final Map<String, AtomicInteger> NUM_SYNCS = new HashMap<String, AtomicInteger>();

        public DummySyncTool3(Properties props, Configuration hadoopconf, Option<HoodieTableMetaClient> metaClient) {
            super(props, hadoopconf);
        }

        public void syncHoodieTable() {
            NUM_SYNCS.computeIfAbsent(this.props.getProperty(SYNC_KEY), key -> new AtomicInteger(0)).getAndIncrement();
        }
    }

    public static class DummySyncTool2
    extends HoodieSyncTool {
        public DummySyncTool2(Properties props) {
            super(props);
        }

        public void syncHoodieTable() {
            throw new HoodieException("Method unimplemented as its a test class");
        }
    }

    public static class DummySyncTool1
    extends HoodieSyncTool {
        public DummySyncTool1(Properties props, Configuration hadoopConf) {
            super(props, hadoopConf);
        }

        public void syncHoodieTable() {
            throw new HoodieException("Method unimplemented as its a test class");
        }
    }
}

