/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.CacheEvictionStats;
import java.util.HashMap;
import java.util.Map;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class CacheEvictionStatsBuilder {
    long evictedBlocks = 0L;
    long maxCacheSize = 0L;
    Map<byte[], Throwable> exceptions = new HashMap<byte[], Throwable>();

    CacheEvictionStatsBuilder() {
    }

    public CacheEvictionStatsBuilder withEvictedBlocks(long evictedBlocks) {
        this.evictedBlocks = evictedBlocks;
        return this;
    }

    public CacheEvictionStatsBuilder withMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        return this;
    }

    public void addException(byte[] regionName, Throwable ie) {
        this.exceptions.put(regionName, ie);
    }

    public CacheEvictionStatsBuilder append(CacheEvictionStats stats) {
        this.evictedBlocks += stats.getEvictedBlocks();
        this.maxCacheSize += stats.getMaxCacheSize();
        this.exceptions.putAll(stats.getExceptions());
        return this;
    }

    public CacheEvictionStats build() {
        return new CacheEvictionStats(this);
    }
}

