/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.Hbck;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableState;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import io.hops.hudi.org.apache.hadoop.hbase.master.RegionState;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseHbck
implements Hbck {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseHbck.class);
    private boolean aborted;
    private final MasterProtos.HbckService.BlockingInterface hbck;
    private RpcControllerFactory rpcControllerFactory;

    HBaseHbck(MasterProtos.HbckService.BlockingInterface hbck, RpcControllerFactory rpcControllerFactory) {
        this.hbck = hbck;
        this.rpcControllerFactory = rpcControllerFactory;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public TableState setTableStateInMeta(TableState state) throws IOException {
        try {
            MasterProtos.GetTableStateResponse response = this.hbck.setTableStateInMeta(this.rpcControllerFactory.newController(), RequestConverter.buildSetTableStateInMetaRequest(state));
            return TableState.convert(state.getTableName(), response.getTableState());
        }
        catch (ServiceException se) {
            LOG.debug("table={}, state={}", new Object[]{state.getTableName(), state.getState(), se});
            throw new IOException(se);
        }
    }

    @Override
    public Map<String, RegionState.State> setRegionStateInMeta(Map<String, RegionState.State> nameOrEncodedName2State) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                nameOrEncodedName2State.forEach((k, v) -> LOG.debug("region={}, state={}", k, (Object)v));
            }
            MasterProtos.SetRegionStateInMetaResponse response = this.hbck.setRegionStateInMeta(this.rpcControllerFactory.newController(), RequestConverter.buildSetRegionStateInMetaRequest(nameOrEncodedName2State));
            HashMap<String, RegionState.State> result = new HashMap<String, RegionState.State>();
            for (MasterProtos.RegionSpecifierAndState nameAndState : response.getStatesList()) {
                result.put(nameAndState.getRegionSpecifier().getValue().toStringUtf8(), RegionState.State.convert(nameAndState.getState()));
            }
            return result;
        }
        catch (ServiceException se) {
            throw new IOException(se);
        }
    }

    @Override
    public List<Long> assigns(List<String> encodedRegionNames, boolean override) throws IOException {
        try {
            MasterProtos.AssignsResponse response = this.hbck.assigns(this.rpcControllerFactory.newController(), RequestConverter.toAssignRegionsRequest(encodedRegionNames, override));
            return response.getPidList();
        }
        catch (ServiceException se) {
            LOG.debug(HBaseHbck.toCommaDelimitedString(encodedRegionNames), (Throwable)se);
            throw new IOException(se);
        }
    }

    @Override
    public List<Long> unassigns(List<String> encodedRegionNames, boolean override) throws IOException {
        try {
            MasterProtos.UnassignsResponse response = this.hbck.unassigns(this.rpcControllerFactory.newController(), RequestConverter.toUnassignRegionsRequest(encodedRegionNames, override));
            return response.getPidList();
        }
        catch (ServiceException se) {
            LOG.debug(HBaseHbck.toCommaDelimitedString(encodedRegionNames), (Throwable)se);
            throw new IOException(se);
        }
    }

    private static String toCommaDelimitedString(List<String> list) {
        return list.stream().collect(Collectors.joining(", "));
    }

    @Override
    public List<Boolean> bypassProcedure(final List<Long> pids, final long waitTime, final boolean override, final boolean recursive) throws IOException {
        MasterProtos.BypassProcedureResponse response = ProtobufUtil.call(new Callable<MasterProtos.BypassProcedureResponse>(){

            @Override
            public MasterProtos.BypassProcedureResponse call() throws Exception {
                try {
                    return HBaseHbck.this.hbck.bypassProcedure(HBaseHbck.this.rpcControllerFactory.newController(), MasterProtos.BypassProcedureRequest.newBuilder().addAllProcId(pids).setWaitTime(waitTime).setOverride(override).setRecursive(recursive).build());
                }
                catch (Throwable t) {
                    LOG.error(pids.stream().map(i -> i.toString()).collect(Collectors.joining(", ")), t);
                    throw t;
                }
            }
        });
        return response.getBypassedList();
    }

    @Override
    public List<Long> scheduleServerCrashProcedures(List<ServerName> serverNames) throws IOException {
        try {
            MasterProtos.ScheduleServerCrashProcedureResponse response = this.hbck.scheduleServerCrashProcedure(this.rpcControllerFactory.newController(), RequestConverter.toScheduleServerCrashProcedureRequest(serverNames));
            return response.getPidList();
        }
        catch (ServiceException se) {
            LOG.debug(HBaseHbck.toCommaDelimitedString(serverNames.stream().map(serverName -> ProtobufUtil.toServerName(serverName).toString()).collect(Collectors.toList())), (Throwable)se);
            throw new IOException(se);
        }
    }

    @Override
    public List<Long> scheduleSCPsForUnknownServers() throws IOException {
        try {
            MasterProtos.ScheduleSCPsForUnknownServersResponse response = this.hbck.scheduleSCPsForUnknownServers(this.rpcControllerFactory.newController(), MasterProtos.ScheduleSCPsForUnknownServersRequest.newBuilder().build());
            return response.getPidList();
        }
        catch (ServiceException se) {
            LOG.debug("Failed to run ServerCrashProcedures for unknown servers", (Throwable)se);
            throw new IOException(se);
        }
    }

    @Override
    public boolean runHbckChore() throws IOException {
        try {
            MasterProtos.RunHbckChoreResponse response = this.hbck.runHbckChore(this.rpcControllerFactory.newController(), MasterProtos.RunHbckChoreRequest.newBuilder().build());
            return response.getRan();
        }
        catch (ServiceException se) {
            LOG.debug("Failed to run HBCK chore", (Throwable)se);
            throw new IOException(se);
        }
    }

    @Override
    public void fixMeta() throws IOException {
        try {
            this.hbck.fixMeta(this.rpcControllerFactory.newController(), MasterProtos.FixMetaRequest.newBuilder().build());
        }
        catch (ServiceException se) {
            throw new IOException(se);
        }
    }
}

