/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket.PersistentIOEngine;
import io.hops.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferAllocator;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class FileMmapIOEngine
extends PersistentIOEngine {
    static final Logger LOG = LoggerFactory.getLogger(FileMmapIOEngine.class);
    protected final String path;
    protected long size;
    protected ByteBufferArray bufferArray;
    private final FileChannel fileChannel;
    private RandomAccessFile raf = null;

    public FileMmapIOEngine(String filePath, long capacity) throws IOException {
        super(filePath);
        this.path = filePath;
        this.size = capacity;
        long fileSize = 0L;
        try {
            this.raf = new RandomAccessFile(filePath, "rw");
            fileSize = this.roundUp(capacity, 0x400000L);
            File file = new File(filePath);
            if (file.length() != fileSize) {
                this.raf.setLength(fileSize);
            }
            this.fileChannel = this.raf.getChannel();
            LOG.info("Allocating " + StringUtils.byteDesc((long)fileSize) + ", on the path:" + filePath);
        }
        catch (FileNotFoundException fex) {
            LOG.error("Can't create bucket cache file " + filePath, (Throwable)fex);
            throw fex;
        }
        catch (IOException ioex) {
            LOG.error("Can't extend bucket cache file; insufficient space for " + StringUtils.byteDesc((long)fileSize), (Throwable)ioex);
            this.shutdown();
            throw ioex;
        }
        ByteBufferAllocator allocator = new ByteBufferAllocator(){
            AtomicInteger pos = new AtomicInteger(0);

            @Override
            public ByteBuffer allocate(long size) throws IOException {
                MappedByteBuffer buffer = FileMmapIOEngine.this.fileChannel.map(FileChannel.MapMode.READ_WRITE, (long)this.pos.getAndIncrement() * size, size);
                return buffer;
            }
        };
        this.bufferArray = new ByteBufferArray(fileSize, allocator);
    }

    private long roundUp(long n, long to) {
        return (n + to - 1L) / to * to;
    }

    public String toString() {
        return "ioengine=" + this.getClass().getSimpleName() + ", path=" + this.path + ", size=" + String.format("%,d", this.size);
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public abstract Cacheable read(BucketEntry var1) throws IOException;

    @Override
    public void write(ByteBuffer srcBuffer, long offset) throws IOException {
        this.bufferArray.write(offset, ByteBuff.wrap(srcBuffer));
    }

    @Override
    public void write(ByteBuff srcBuffer, long offset) throws IOException {
        this.bufferArray.write(offset, srcBuffer);
    }

    @Override
    public void sync() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.force(true);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.fileChannel.close();
        }
        catch (IOException ex) {
            LOG.error("Can't shutdown cleanly", (Throwable)ex);
        }
        try {
            this.raf.close();
        }
        catch (IOException ex) {
            LOG.error("Can't shutdown cleanly", (Throwable)ex);
        }
    }
}

