/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RSRpcServices;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterAnnotationReadingPriorityFunction
extends AnnotationReadingPriorityFunction {
    public static final int META_TRANSITION_QOS = 300;

    public MasterAnnotationReadingPriorityFunction(RSRpcServices rpcServices) {
        this(rpcServices, rpcServices.getClass());
    }

    public MasterAnnotationReadingPriorityFunction(RSRpcServices rpcServices, Class<? extends RSRpcServices> clz) {
        super(rpcServices, clz);
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        int priorityByAnnotation = this.getAnnotatedPriority(header);
        if (priorityByAnnotation >= 0) {
            if (priorityByAnnotation >= 300) {
                return 299;
            }
            return priorityByAnnotation;
        }
        if (param instanceof RegionServerStatusProtos.ReportRegionStateTransitionRequest) {
            RegionServerStatusProtos.ReportRegionStateTransitionRequest tRequest = (RegionServerStatusProtos.ReportRegionStateTransitionRequest)param;
            for (RegionServerStatusProtos.RegionStateTransition rst : tRequest.getTransitionList()) {
                if (rst.getRegionInfoList() == null) continue;
                for (HBaseProtos.RegionInfo info : rst.getRegionInfoList()) {
                    TableName tn = ProtobufUtil.toTableName(info.getTableName());
                    if (!TableName.META_TABLE_NAME.equals(tn)) continue;
                    return 300;
                }
            }
            return 200;
        }
        if (param instanceof RegionServerStatusProtos.RegionServerReportRequest) {
            return 200;
        }
        return this.getBasePriority(header, param);
    }
}

