/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.procedure2.store.region;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.AbstractHBaseTool;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WAL;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALFactory;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALKeyImpl;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALPrettyPrinter;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import java.io.PrintStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class WALProcedurePrettyPrinter
extends AbstractHBaseTool {
    private static final String KEY_TMPL = "Sequence=%s, at write timestamp=%s";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
    private String file;
    private PrintStream out;

    public WALProcedurePrettyPrinter() {
        this(System.out);
    }

    public WALProcedurePrettyPrinter(PrintStream out) {
        this.out = out;
    }

    @Override
    protected void addOptions() {
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        if (cmd.getArgList().size() != 1) {
            throw new IllegalArgumentException("Please specify the file to dump");
        }
        this.file = cmd.getArgList().get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() throws Exception {
        Path path = new Path(this.file);
        FileSystem fs = path.getFileSystem(this.conf);
        try (WAL.Reader reader = WALFactory.createReader(fs, path, this.conf);){
            while (true) {
                WAL.Entry entry;
                if ((entry = reader.next()) == null) {
                    int n = 0;
                    return n;
                }
                WALKeyImpl key = entry.getKey();
                WALEdit edit = entry.getEdit();
                long sequenceId = key.getSequenceId();
                long writeTime = key.getWriteTime();
                this.out.println(String.format(KEY_TMPL, sequenceId, FORMATTER.format(Instant.ofEpochMilli(writeTime))));
                for (Cell cell : edit.getCells()) {
                    Map<String, Object> op = WALPrettyPrinter.toStringMap(cell);
                    if (!Bytes.equals(MasterRegionFactory.PROC_FAMILY, 0, MasterRegionFactory.PROC_FAMILY.length, cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength())) {
                        WALPrettyPrinter.printCell(this.out, op, false, false);
                        continue;
                    }
                    long procId = Bytes.toLong(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                    this.out.println("pid=" + procId + ", type=" + op.get("type") + ", column=" + op.get("family") + ":" + op.get("qualifier"));
                    if (cell.getType() == Cell.Type.Put) {
                        if (cell.getValueLength() > 0) {
                            Procedure proc = ProcedureUtil.convertToProcedure((ProcedureProtos.Procedure)ProcedureProtos.Procedure.parser().parseFrom(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                            this.out.println("\t" + proc.toStringDetails());
                        } else {
                            this.out.println("\tmark deleted");
                        }
                    }
                    this.out.println("cell total size sum: " + cell.heapSize());
                }
                this.out.println("edit heap size: " + edit.heapSize());
                this.out.println("position: " + reader.getPosition());
                continue;
                break;
            }
        }
    }

    public static void main(String[] args2) {
        new WALProcedurePrettyPrinter().doStaticMain(args2);
    }
}

