/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.quotas;

import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotView;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SpaceQuotaSnapshot
implements SpaceQuotaSnapshotView {
    private static final SpaceQuotaSnapshot NO_SUCH_SNAPSHOT = new SpaceQuotaSnapshot(SpaceQuotaStatus.notInViolation(), 0L, Long.MAX_VALUE);
    private final SpaceQuotaStatus quotaStatus;
    private final long usage;
    private final long limit;

    public SpaceQuotaSnapshot(SpaceQuotaStatus quotaStatus, long usage, long limit) {
        this.quotaStatus = Objects.requireNonNull(quotaStatus);
        this.usage = usage;
        this.limit = limit;
    }

    @Override
    public SpaceQuotaStatus getQuotaStatus() {
        return this.quotaStatus;
    }

    @Override
    public long getUsage() {
        return this.usage;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.quotaStatus.hashCode()).append(this.usage).append(this.limit).toHashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SpaceQuotaSnapshot) {
            SpaceQuotaSnapshot other = (SpaceQuotaSnapshot)o;
            return this.quotaStatus.equals(other.quotaStatus) && this.usage == other.usage && this.limit == other.limit;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("SpaceQuotaSnapshot[policy=").append(this.quotaStatus).append(", use=");
        sb.append(StringUtils.byteDesc((long)this.usage)).append("/");
        sb.append(StringUtils.byteDesc((long)this.limit)).append("]");
        return sb.toString();
    }

    public static SpaceQuotaSnapshot toSpaceQuotaSnapshot(QuotaProtos.SpaceQuotaSnapshot proto) {
        return new SpaceQuotaSnapshot(SpaceQuotaStatus.toStatus(proto.getQuotaStatus()), proto.getQuotaUsage(), proto.getQuotaLimit());
    }

    public static QuotaProtos.SpaceQuotaSnapshot toProtoSnapshot(SpaceQuotaSnapshot snapshot) {
        return QuotaProtos.SpaceQuotaSnapshot.newBuilder().setQuotaStatus(SpaceQuotaStatus.toProto(snapshot.getQuotaStatus())).setQuotaUsage(snapshot.getUsage()).setQuotaLimit(snapshot.getLimit()).build();
    }

    public static SpaceQuotaSnapshot getNoSuchSnapshot() {
        return NO_SUCH_SNAPSHOT;
    }

    @InterfaceAudience.Private
    public static class SpaceQuotaStatus
    implements SpaceQuotaSnapshotView.SpaceQuotaStatusView {
        private static final SpaceQuotaStatus NOT_IN_VIOLATION = new SpaceQuotaStatus(null, false);
        final Optional<SpaceViolationPolicy> policy;
        final boolean inViolation;

        public SpaceQuotaStatus(SpaceViolationPolicy policy) {
            this(Objects.requireNonNull(policy), true);
        }

        private SpaceQuotaStatus(SpaceViolationPolicy policy, boolean inViolation) {
            this.policy = Optional.ofNullable(policy);
            this.inViolation = inViolation;
        }

        @Override
        public Optional<SpaceViolationPolicy> getPolicy() {
            return this.policy;
        }

        @Override
        public boolean isInViolation() {
            return this.inViolation;
        }

        public static SpaceQuotaStatus notInViolation() {
            return NOT_IN_VIOLATION;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.policy == null ? 0 : this.policy.hashCode()).append(this.inViolation).toHashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SpaceQuotaStatus) {
                SpaceQuotaStatus other = (SpaceQuotaStatus)o;
                return Objects.equals(this.policy, other.policy) && this.inViolation == other.inViolation;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("[policy=").append(this.policy);
            sb.append(", inViolation=").append(this.inViolation).append("]");
            return sb.toString();
        }

        public static QuotaProtos.SpaceQuotaStatus toProto(SpaceQuotaStatus status) {
            QuotaProtos.SpaceQuotaStatus.Builder builder = QuotaProtos.SpaceQuotaStatus.newBuilder();
            builder.setInViolation(status.inViolation);
            if (status.isInViolation()) {
                builder.setViolationPolicy(ProtobufUtil.toProtoViolationPolicy(status.getPolicy().get()));
            }
            return builder.build();
        }

        public static SpaceQuotaStatus toStatus(QuotaProtos.SpaceQuotaStatus proto) {
            if (proto.getInViolation()) {
                return new SpaceQuotaStatus(ProtobufUtil.toViolationPolicy(proto.getViolationPolicy()));
            }
            return NOT_IN_VIOLATION;
        }
    }
}

