/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.quotas.policies;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractViolationPolicyEnforcement
implements SpaceViolationPolicyEnforcement {
    RegionServerServices rss;
    TableName tableName;
    SpaceQuotaSnapshot quotaSnapshot;

    public void setRegionServerServices(RegionServerServices rss) {
        this.rss = Objects.requireNonNull(rss);
    }

    public void setTableName(TableName tableName) {
        this.tableName = tableName;
    }

    public RegionServerServices getRegionServerServices() {
        return this.rss;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public void setQuotaSnapshot(SpaceQuotaSnapshot snapshot) {
        this.quotaSnapshot = Objects.requireNonNull(snapshot);
    }

    @Override
    public SpaceQuotaSnapshot getQuotaSnapshot() {
        return this.quotaSnapshot;
    }

    @Override
    public void initialize(RegionServerServices rss, TableName tableName, SpaceQuotaSnapshot snapshot) {
        this.setRegionServerServices(rss);
        this.setTableName(tableName);
        this.setQuotaSnapshot(snapshot);
    }

    @Override
    public boolean areCompactionsDisabled() {
        return false;
    }

    long getFileSize(FileSystem fs, String path) throws SpaceLimitingException {
        FileStatus status;
        try {
            status = fs.getFileStatus(new Path(Objects.requireNonNull(path)));
        }
        catch (IOException e) {
            throw new SpaceLimitingException(this.getPolicyName(), "Could not verify length of file to bulk load: " + path, e);
        }
        if (!status.isFile()) {
            throw new IllegalArgumentException(path + " is not a file.");
        }
        return status.getLen();
    }
}

