/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactionRequestImpl
implements CompactionRequest {
    private boolean isOffPeak = false;
    private DisplayCompactionType isMajor = DisplayCompactionType.MINOR;
    private int priority = Integer.MIN_VALUE;
    private Collection<HStoreFile> filesToCompact;
    private boolean isAfterSplit = false;
    private long selectionTime;
    private String regionName = "";
    private String storeName = "";
    private long totalSize = -1L;
    private CompactionLifeCycleTracker tracker = CompactionLifeCycleTracker.DUMMY;

    public CompactionRequestImpl(Collection<HStoreFile> files) {
        this.selectionTime = EnvironmentEdgeManager.currentTime();
        this.filesToCompact = Preconditions.checkNotNull(files, "files for compaction can not null");
        this.recalculateSize();
    }

    public void updateFiles(Collection<HStoreFile> files) {
        this.filesToCompact = Preconditions.checkNotNull(files, "files for compaction can not null");
        this.recalculateSize();
    }

    public Collection<HStoreFile> getFiles() {
        return Collections.unmodifiableCollection(this.filesToCompact);
    }

    public void setDescription(String regionName, String storeName) {
        this.regionName = regionName;
        this.storeName = storeName;
    }

    @Override
    public long getSize() {
        return this.totalSize;
    }

    @Override
    public boolean isAllFiles() {
        return this.isMajor == DisplayCompactionType.MAJOR || this.isMajor == DisplayCompactionType.ALL_FILES;
    }

    @Override
    public boolean isMajor() {
        return this.isMajor == DisplayCompactionType.MAJOR;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public boolean isOffPeak() {
        return this.isOffPeak;
    }

    public void setOffPeak(boolean value) {
        this.isOffPeak = value;
    }

    @Override
    public long getSelectionTime() {
        return this.selectionTime;
    }

    public void setIsMajor(boolean isMajor, boolean isAllFiles) {
        assert (isAllFiles || !isMajor);
        this.isMajor = !isAllFiles ? DisplayCompactionType.MINOR : (isMajor ? DisplayCompactionType.MAJOR : DisplayCompactionType.ALL_FILES);
    }

    public void setTracker(CompactionLifeCycleTracker tracker) {
        this.tracker = tracker;
    }

    public CompactionLifeCycleTracker getTracker() {
        return this.tracker;
    }

    public boolean isAfterSplit() {
        return this.isAfterSplit;
    }

    public void setAfterSplit(boolean afterSplit) {
        this.isAfterSplit = afterSplit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filesToCompact == null ? 0 : this.filesToCompact.hashCode());
        result = 31 * result + (this.isMajor == null ? 0 : this.isMajor.hashCode());
        result = 31 * result + (this.isOffPeak ? 1231 : 1237);
        result = 31 * result + this.priority;
        result = 31 * result + (this.regionName == null ? 0 : this.regionName.hashCode());
        result = 31 * result + (int)(this.selectionTime ^ this.selectionTime >>> 32);
        result = 31 * result + (this.storeName == null ? 0 : this.storeName.hashCode());
        result = 31 * result + (int)(this.totalSize ^ this.totalSize >>> 32);
        result = 31 * result + (this.tracker == null ? 0 : this.tracker.hashCode());
        result = 31 * result + (this.isAfterSplit ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompactionRequestImpl other = (CompactionRequestImpl)obj;
        if (this.filesToCompact == null ? other.filesToCompact != null : !this.filesToCompact.equals(other.filesToCompact)) {
            return false;
        }
        if (this.isMajor != other.isMajor) {
            return false;
        }
        if (this.isOffPeak != other.isOffPeak) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.regionName == null ? other.regionName != null : !this.regionName.equals(other.regionName)) {
            return false;
        }
        if (this.selectionTime != other.selectionTime) {
            return false;
        }
        if (this.storeName == null ? other.storeName != null : !this.storeName.equals(other.storeName)) {
            return false;
        }
        if (this.totalSize != other.totalSize) {
            return false;
        }
        if (this.isAfterSplit != other.isAfterSplit) {
            return false;
        }
        return !(this.tracker == null ? other.tracker != null : !this.tracker.equals(other.tracker));
    }

    public String toString() {
        String fsList = this.filesToCompact.stream().filter(f -> f.getReader() != null).map(f -> StringUtils.TraditionalBinaryPrefix.long2String((long)f.getReader().length(), (String)"", (int)1)).collect(Collectors.joining(", "));
        return "regionName=" + this.regionName + ", storeName=" + this.storeName + ", fileCount=" + this.getFiles().size() + ", fileSize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.totalSize, (String)"", (int)1) + (fsList.isEmpty() ? "" : " (" + fsList + ")") + ", priority=" + this.priority + ", time=" + this.selectionTime;
    }

    private void recalculateSize() {
        this.totalSize = this.filesToCompact.stream().map(HStoreFile::getReader).mapToLong(r -> r != null ? r.length() : 0L).sum();
    }

    private static enum DisplayCompactionType {
        MINOR,
        ALL_FILES,
        MAJOR;

    }
}

