/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.types;

import io.hops.hudi.org.apache.hadoop.hbase.types.DataType;
import io.hops.hudi.org.apache.hadoop.hbase.util.Order;
import io.hops.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import io.hops.hudi.org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class FixedLengthWrapper<T>
implements DataType<T> {
    protected final DataType<T> base;
    protected final int length;

    public FixedLengthWrapper(DataType<T> base, int length) {
        this.base = base;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isOrderPreserving() {
        return this.base.isOrderPreserving();
    }

    @Override
    public Order getOrder() {
        return this.base.getOrder();
    }

    @Override
    public boolean isNullable() {
        return this.base.isNullable();
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(T val) {
        return this.length;
    }

    @Override
    public Class<T> encodedClass() {
        return this.base.encodedClass();
    }

    @Override
    public int skip(PositionedByteRange src) {
        src.setPosition(src.getPosition() + this.length);
        return this.length;
    }

    @Override
    public T decode(PositionedByteRange src) {
        if (src.getRemaining() < this.length) {
            throw new IllegalArgumentException("Not enough buffer remaining. src.offset: " + src.getOffset() + " src.length: " + src.getLength() + " src.position: " + src.getPosition() + " max length: " + this.length);
        }
        SimplePositionedMutableByteRange b = new SimplePositionedMutableByteRange(this.length);
        src.get(b.getBytes());
        return this.base.decode(b);
    }

    @Override
    public int encode(PositionedByteRange dst, T val) {
        if (dst.getRemaining() < this.length) {
            throw new IllegalArgumentException("Not enough buffer remaining. dst.offset: " + dst.getOffset() + " dst.length: " + dst.getLength() + " dst.position: " + dst.getPosition() + " max length: " + this.length);
        }
        int written = this.base.encode(dst, val);
        if (written > this.length) {
            throw new IllegalArgumentException("Length of encoded value (" + written + ") exceeds max length (" + this.length + ").");
        }
        while (written < this.length) {
            dst.put((byte)0);
            ++written;
        }
        return written;
    }
}

