/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellBuilderType;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.CellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import io.hops.hudi.org.apache.hadoop.hbase.util.BloomFilterWriter;
import io.hops.hudi.org.apache.hadoop.hbase.util.RowBloomContext;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowPrefixFixedLengthBloomContext
extends RowBloomContext {
    private final int prefixLength;

    public RowPrefixFixedLengthBloomContext(BloomFilterWriter bloomFilterWriter, CellComparator comparator, int prefixLength) {
        super(bloomFilterWriter, comparator);
        this.prefixLength = prefixLength;
    }

    @Override
    public void writeBloom(Cell cell) throws IOException {
        super.writeBloom(this.getRowPrefixCell(cell));
    }

    private Cell getRowPrefixCell(Cell cell) {
        byte[] row = CellUtil.copyRow(cell);
        return ExtendedCellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(row, 0, Math.min(this.prefixLength, row.length)).setType(Cell.Type.Put).build();
    }
}

